/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterizedConfiguration<S, C extends S>
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ParameterizedConfiguration.class);
    private C object;
    private Method method;
    private S proxy;

    public ParameterizedConfiguration(C object, Class<S> clazz, String methodName) {
        this.object = object;
        try {
            this.method = clazz.getDeclaredMethod(methodName, String.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new LegoCheckedException("get method failed, error:" + ExceptionUtil.getErrorMessage((Throwable)e));
        }
        ClassLoader loader = clazz.getClassLoader();
        Class[] interfaces = new Class[]{clazz};
        this.proxy = Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)this);
    }

    public S getProxy() {
        return this.proxy;
    }

    public String normalize(String configuration) {
        if (configuration == null) {
            return configuration;
        }
        configuration = Normalizer.normalize(configuration, Normalizer.Form.NFKC);
        Pattern pattern = Pattern.compile("\\$\\{([\\w\\d._\\-]+)\\}");
        Matcher matcher = pattern.matcher(configuration);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String val = this.getConfiguration(key);
            val = val != null ? Normalizer.normalize(val, Normalizer.Form.NFKC) : "";
            matcher.appendReplacement(sb, val);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String getConfiguration(String name) {
        try {
            Object value = this.method.invoke(this.object, name);
            String configuration = value != null ? value.toString() : null;
            return this.normalize(configuration);
        }
        catch (IllegalAccessException e) {
            logger.error(ExceptionUtil.getErrorMessage((Throwable)e));
        }
        catch (IllegalArgumentException e) {
            logger.error(ExceptionUtil.getErrorMessage((Throwable)e));
        }
        catch (InvocationTargetException e) {
            logger.error(ExceptionUtil.getErrorMessage((Throwable)e));
        }
        return null;
    }

    @Override
    public Object invoke(Object proxyObject, Method theMethod, Object[] args) throws Throwable {
        Object value = theMethod.invoke(this.object, args);
        if (theMethod.equals(this.method) && value != null) {
            value = this.normalize(value.toString());
        }
        return value;
    }

    public static <S, C extends S> ParameterizedConfiguration<S, C> create(C object, Class<S> clazz, String methodName) {
        return new ParameterizedConfiguration<S, C>(object, clazz, methodName);
    }

    public static <C extends ServletContext> ParameterizedConfiguration<ServletContext, C> get(ServletContext context) {
        String name = ParameterizedConfiguration.class.getName();
        ParameterizedConfiguration<ServletContext, ServletContext> attribute = context.getAttribute(name);
        if (attribute == null) {
            attribute = ParameterizedConfiguration.create(context, ServletContext.class, "getInitParameter");
            context.setAttribute(name, attribute);
        }
        return attribute;
    }
}

