/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

public final class FaultExportUtil {
    private FaultExportUtil() {
    }

    public static void processField(Map<String, String> map, String fieldName, String value) {
        if (null != value && !value.equalsIgnoreCase("")) {
            map.put(fieldName, value);
        }
    }

    public static void processField(Map<String, String> map, String fieldName, long value) {
        if (!String.valueOf(value).equalsIgnoreCase("0")) {
            map.put(fieldName, String.valueOf(value));
        }
    }

    public static void processDateField(Map<String, String> map, String fieldName, String value) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (null != value && !value.equalsIgnoreCase("")) {
            map.put(fieldName, value);
        }
        if (value != null && !value.equalsIgnoreCase("")) {
            map.put(fieldName, String.valueOf(df.parse(value).getTime()));
        }
    }

    public static void convertAlarmType(int alarmType, List<String> tempLst) {
        switch (alarmType) {
            case 1: {
                tempLst.add("lego.dic.warningtype.comm");
                break;
            }
            case 2: {
                tempLst.add("lego.dic.warningtype.env");
                break;
            }
            case 3: {
                tempLst.add("lego.dic.warningtype.dev");
                break;
            }
            case 4: {
                tempLst.add("lego.dic.warningtype.business");
                break;
            }
            case 5: {
                tempLst.add("lego.dic.warningtype.operation");
                break;
            }
            case 6: {
                tempLst.add("lego.dic.warningtype.security");
                break;
            }
            default: {
                tempLst.add("--");
            }
        }
    }

    public static void convertAlarmLevel(int alarmLevel, List<String> tempLst) {
        switch (alarmLevel) {
            case 1: {
                tempLst.add("lego.lab.fault.alarmLevel.warning");
                break;
            }
            case 2: {
                tempLst.add("lego.lab.fault.alarmLevel.minor");
                break;
            }
            case 3: {
                tempLst.add("lego.lab.fault.alarmLevel.major");
                break;
            }
            case 4: {
                tempLst.add("lego.lab.fault.alarmLevel.critical");
                break;
            }
            default: {
                tempLst.add(String.valueOf(alarmLevel));
            }
        }
    }

    public static void convertConfirmStatus(int confirmStatus, List<String> tempLst, String userName) {
        StringBuilder buffer = new StringBuilder();
        if (confirmStatus == 1) {
            buffer.append("lego.dic.confirmstatus.confirmed");
            buffer.append(" ");
            buffer.append(userName);
        } else if (confirmStatus == 0) {
            buffer.append("lego.dic.confirmstatus.unconfirmed");
        } else {
            buffer.append(String.valueOf(confirmStatus));
        }
        tempLst.add(buffer.toString());
    }
}

