/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log4jConfigurer;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.FileNotFoundException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public abstract class Log4jWebConfigurer {
    private static final Log LOGGER = LogFactory.getLog(Log4jWebConfigurer.class);
    private static final String CONFIG_LOCATION_PARAM = "log4jConfigLocation";
    private static final String REFRESH_INTERVAL_PARAM = "log4jRefreshInterval";
    private static final String EXPOSE_WEB_APP_ROOT_PARAM = "log4jExposeWebAppRoot";

    public static void initLogging(ServletContext servletContext) {
        block8: {
            String location;
            if (Log4jWebConfigurer.exposeWebAppRoot(servletContext)) {
                Log4jWebConfigurer.setWebAppRootSystemProperty(servletContext);
            }
            if ((location = servletContext.getInitParameter(CONFIG_LOCATION_PARAM)) != null) {
                try {
                    String intervalString;
                    if (!ResourceUtils.isUrl((String)location)) {
                        location = SystemPropertyUtils.resolvePlaceholders((String)location);
                        location = Log4jWebConfigurer.getRealPath(servletContext, location);
                    }
                    if (StringUtils.hasText((String)(intervalString = servletContext.getInitParameter(REFRESH_INTERVAL_PARAM)))) {
                        try {
                            long refreshInterval = Long.parseLong(intervalString);
                            Log4jConfigurer.initLogging((String)location, (long)refreshInterval);
                            break block8;
                        }
                        catch (NumberFormatException ex) {
                            LOGGER.error((Object)"Invalid 'log4jRefreshInterval' parameter: ", (Throwable)ex);
                            throw new LegoCheckedException("Invalid 'log4jRefreshInterval' parameter: " + ex.getMessage(), (Throwable)ex);
                        }
                    }
                    Log4jConfigurer.initLogging((String)location);
                }
                catch (FileNotFoundException ex) {
                    LOGGER.error((Object)"Invalid 'log4jConfigLocation'");
                    ExceptionUtil.rethrowException((Exception)ex, (String)"Invalid 'log4jConfigLocation", (long)-1L, (String[])new String[0]);
                }
            }
        }
    }

    public static void shutdownLogging(ServletContext servletContext) {
        servletContext.log("Shutting down log4j");
        try {
            Log4jConfigurer.shutdownLogging();
        }
        finally {
            if (Log4jWebConfigurer.exposeWebAppRoot(servletContext)) {
                Log4jWebConfigurer.removeWebAppRootSystemProperty(servletContext);
            }
        }
    }

    private static boolean exposeWebAppRoot(ServletContext servletContext) {
        String exposeWebAppRootParam = servletContext.getInitParameter(EXPOSE_WEB_APP_ROOT_PARAM);
        return exposeWebAppRootParam == null || Boolean.valueOf(exposeWebAppRootParam) != false;
    }

    private static void removeWebAppRootSystemProperty(ServletContext servletContext) {
        if (null == servletContext) {
            LOGGER.error((Object)"Servlet context is null");
            throw new LegoCheckedException("Servlet context is null");
        }
        String param = servletContext.getInitParameter("webAppRootKey");
        String key = param != null ? param : "webapp.root";
        System.getProperties().remove(key);
    }

    private static String getRealPath(ServletContext servletContext, String path) throws FileNotFoundException {
        String realPath;
        if (null == servletContext) {
            LOGGER.error((Object)"Servlet context is null");
            throw new LegoCheckedException("Servlet context is null");
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((realPath = servletContext.getRealPath(path)) == null) {
            throw new FileNotFoundException("ServletContext resource [" + path + "] cannot be resolved to absolute file path - web application archive not expanded?");
        }
        return realPath;
    }

    private static void setWebAppRootSystemProperty(ServletContext servletContext) {
        if (null == servletContext) {
            LOGGER.error((Object)"Servlet context is null");
            throw new LegoCheckedException("Servlet context is null");
        }
        String root = servletContext.getRealPath("/");
        if (root == null) {
            throw new IllegalStateException("Cannot set web app root system property when WAR file is not expanded");
        }
        String param = servletContext.getInitParameter("webAppRootKey");
        String key = param != null ? param : "webapp.root";
        String oldValue = System.getProperty(key);
        if (oldValue != null && !StringUtils.pathEquals((String)oldValue, (String)root)) {
            throw new IllegalStateException("Web app root system property already set to different value: * instead of [*] - Choose unique values for the 'webAppRootKey' context-param in your web.xml files!");
        }
        System.setProperty(key, root);
    }
}

