/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.util.dbtool;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.dto.DbScript;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.postgresql.util.PSQLException;

public class InitSQL {
    private static final Log LOGGER = LogFactory.getInstance(InitSQL.class);
    private static final String GAUSS = "Gauss";
    private DbScript dbinit = null;

    public InitSQL(DbScript init) {
        this.dbinit = init;
    }

    public void fixDB(DataBaseInfo dbInfor) throws SQLException {
        Connection dbConnection = null;
        PreparedStatement pst = null;
        try {
            if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
                dbConnection = LegoDBConnection.getInstance().connectionGauss(dbInfor, false);
            }
            if (null == dbConnection) {
                throw new SQLException("Database can not  connect, stop install and exit");
            }
            Map<String, String> createDBMap = this.dbinit.getDb();
            for (Map.Entry<String, String> entry : createDBMap.entrySet()) {
                String dbName = entry.getKey();
                LOGGER.info((Object)String.format(Locale.ROOT, "DbName Valid:%s", dbName));
                if (LegoDBConnection.getInstance().dbExist(dbInfor, dbName)) continue;
                String createSql = entry.getValue();
                if (null != dbConnection) {
                    pst = this.getPreparedStatement(createSql, dbConnection);
                    LOGGER.info((Object)String.format(Locale.ROOT, "DB %s is not exist, excute create SQL.", dbName));
                }
                if (null == pst) continue;
                pst.execute();
            }
            this.extractNullCheck(dbConnection, pst);
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)"Create DB error", ExceptionUtil.getErrorMessage((Throwable)e));
                throw new SQLException("drop DB error. ");
            }
            catch (Throwable throwable) {
                this.extractNullCheck(dbConnection, pst);
                throw throwable;
            }
        }
    }

    public void dropDB(DataBaseInfo dbInfor) throws SQLException {
        Connection conn = null;
        try {
            if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
                conn = LegoDBConnection.getInstance().connectionGauss(dbInfor, false);
            }
            Map<String, String> createDBMap = this.dbinit.getDb();
            for (Map.Entry<String, String> entry : createDBMap.entrySet()) {
                String dbName = entry.getKey();
                LOGGER.info((Object)String.format(Locale.ROOT, "DbName Valid:%s", dbName));
                if (!LegoDBConnection.getInstance().dbExist(dbInfor, dbName)) continue;
                this.dealDB(entry, conn, dbName);
            }
            this.extractNullCheck(conn);
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)("Drop DB error" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new SQLException("drop DB error. ");
            }
            catch (Throwable throwable) {
                this.extractNullCheck(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealDB(Map.Entry<String, String> entry, Connection conn, String dbName) throws SQLException {
        PreparedStatement pst = null;
        try {
            String dropSql = entry.getValue();
            if (null != conn) {
                pst = this.getPreparedStatement(dropSql, conn);
            }
            LOGGER.info((Object)String.format(Locale.ROOT, "DB %s is  exist, exec drop SQL.", dbName));
            if (null != pst) {
                pst.execute();
            }
            this.closeRes(pst);
        }
        catch (Throwable throwable) {
            this.closeRes(pst);
            throw throwable;
        }
    }

    private PreparedStatement getPreparedStatement(String dropSql, Connection conn) throws SQLException {
        return conn.prepareStatement(dropSql);
    }

    private void closeRes(PreparedStatement pst) {
        if (null != pst) {
            try {
                pst.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)("PreparedStatement close SQLException" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    private Connection fixDataConnection(DataBaseInfo dbInfor, String dbName) {
        Connection conn = null;
        if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
            conn = LegoDBConnection.getInstance().connectGaussDB(dbInfor, dbName, false);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixDataExec(List<String> sqls, Connection conn) throws SQLException {
        int count = 0;
        PreparedStatement st = null;
        for (String sql : sqls) {
            if (sql.trim().length() <= 0) continue;
            LOGGER.info((Object)String.format(Locale.ROOT, "Excute sql, Count:%s", count++));
            try {
                st = conn.prepareStatement(sql);
                st.executeUpdate();
            }
            catch (PSQLException e) {
                this.judgeException(e, count);
            }
            finally {
                this.closeRes(st);
            }
        }
    }

    private void judgeException(PSQLException e, int cout) throws PSQLException {
        String message = e.getMessage();
        if (null == message) {
            throw e;
        }
        if (message.contains("multiple primary keys for table") && message.contains("are not allowed")) {
            LOGGER.warn((Object)("Excute sql, Count:" + cout), "multiple primary keys for table");
            return;
        }
        if (message.contains("constraint") && message.contains("already exists")) {
            LOGGER.warn((Object)("Excute sql, Count:" + cout), "constraint already exists");
            return;
        }
        if (message.contains("column") && message.contains("already exists")) {
            LOGGER.warn((Object)("Excute sql, Count:" + cout), "column already exists");
            return;
        }
        throw e;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fixData(DataBaseInfo dbInfor) throws SQLException, IOException {
        Connection conn = null;
        File[] insertDataFile = this.dbinit.getDataFiles();
        if (null == insertDataFile) {
            return;
        }
        File[] fileArray = insertDataFile;
        int n = fileArray.length;
        int n2 = 0;
        while (true) {
            block12: {
                String name;
                if (n2 >= n) {
                    return;
                }
                File file = fileArray[n2];
                try {
                    name = file.getName();
                    int index1 = name.indexOf("_");
                    int index2 = name.indexOf(".sql");
                    String dbName = name.substring(index1 + 1, index2);
                    conn = this.fixDataConnection(dbInfor, dbName);
                    if (null == conn) {
                        LOGGER.info((Object)String.format(Locale.ROOT, "DB :%s is not exist, need not to excute sql ", dbName));
                        this.extractNullCheck(conn, null);
                        break block12;
                    }
                }
                catch (SQLException e) {
                    try {
                        LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), "FixData SQL Exception");
                        throw new SQLException("fixData sql exception.");
                        catch (FileNotFoundException e1) {
                            LOGGER.error((Object)("FixData File Not Found: " + file.getName()), "");
                            throw new FileNotFoundException();
                        }
                        catch (IOException e2) {
                            LOGGER.error((Object)e2, "FixData IO Exception");
                            throw e2;
                        }
                    }
                    catch (Throwable throwable) {
                        this.extractNullCheck(conn, null);
                        throw throwable;
                    }
                }
                {
                    LOGGER.info((Object)String.format(Locale.ROOT, "Update file: %s", name));
                    List<String> sqls = this.getInsertList(file);
                    if (sqls.size() >= 1) {
                        this.fixDataExec(sqls, conn);
                    }
                    this.extractNullCheck(conn, null);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fixSql(DataBaseInfo dbInfor, List<File> sqlFile) throws SQLException, IOException {
        Connection conn = null;
        Statement st = null;
        if (null == sqlFile) {
            return;
        }
        Iterator<File> iterator = sqlFile.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                String dbName = dbInfor.getDbName();
                if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
                    conn = LegoDBConnection.getInstance().connectGaussDB(dbInfor, dbName, false);
                }
                if (null == conn) {
                    LOGGER.error((Object)("DB :" + dbName + "is not exist, need not to excute sql "), "");
                    this.extractNullCheck(conn, st);
                    continue;
                }
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), "SQL error");
                    throw new SQLException("fixSql failed.");
                    catch (FileNotFoundException e2) {
                        LOGGER.error((Object)("File Not found: " + file.getName()), "");
                        throw new FileNotFoundException();
                    }
                    catch (IOException e3) {
                        LOGGER.error((Object)e3, "IO error");
                        throw e3;
                    }
                }
                catch (Throwable throwable) {
                    this.extractNullCheck(conn, st);
                    throw throwable;
                }
            }
            {
                List<String> sqls = this.getInsertList(file);
                if (sqls.size() >= 1) {
                    st = conn.createStatement();
                    this.extracted(st, 0, sqls);
                }
                this.extractNullCheck(conn, st);
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fixSql(DataBaseInfo dbInfor, File file) throws SQLException, IOException {
        Connection conn = null;
        Statement st = null;
        try {
            String dbName = dbInfor.getDbName();
            if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
                conn = LegoDBConnection.getInstance().connectGaussDB(dbInfor, dbName, false);
            }
            if (null == conn) {
                LOGGER.error((Object)("DB :" + dbName + "is not exist, need not to excute sql "), "");
                this.extractNullCheck(conn, st);
                return;
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), "SQL error");
                throw new SQLException();
                catch (FileNotFoundException e2) {
                    LOGGER.error((Object)("File Not found error: " + file.getName()), "");
                    throw new FileNotFoundException();
                }
                catch (IOException e3) {
                    LOGGER.error((Object)e3, "IO error");
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                this.extractNullCheck(conn, st);
                throw throwable;
            }
        }
        {
            List<String> sqls = this.getInsertList(file);
            if (sqls.size() >= 1) {
                st = conn.createStatement();
                this.extracted(st, 0, sqls);
            }
            this.extractNullCheck(conn, st);
            return;
        }
    }

    private void extractNullCheck(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)("Close Connection SQLException" + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }

    private void extractNullCheck(Connection conn, Statement st) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)("Close Connection SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)("Close Statement SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }

    private int extracted(Statement st, int count, List<String> sqls) throws SQLException {
        for (String sql : sqls) {
            if (sql.trim().length() <= 0) continue;
            LOGGER.info((Object)String.format(Locale.ROOT, "SQL executeUpdate, Count:%s", count++));
            st.executeUpdate(sql);
        }
        return count;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getInsertList(File fileName) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
            String text = null;
            while (true) {
                if ((text = FileUtil.getLineFromFile(reader)) == null) {
                    this.closeReader(reader);
                    return list;
                }
                if (text.trim().startsWith("--")) continue;
                list.add(text);
            }
        }
        catch (FileNotFoundException e) {
            try {
                LOGGER.error((Object)("File not found error: " + fileName.getName()), "");
                throw new FileNotFoundException();
                catch (IOException e2) {
                    LOGGER.error((Object)e2, "IO error");
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.closeReader(reader);
                throw throwable;
            }
        }
    }

    private void closeReader(BufferedReader reader) {
        if (null != reader) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e, "Close BufferedReader IO error");
            }
        }
    }

    public void fixTable(DataBaseInfo dbInfor) throws SQLException {
        Connection conn = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        Map<String, String> createTableMap = this.dbinit.getTable();
        for (Map.Entry<String, String> entry : createTableMap.entrySet()) {
            String tableName;
            String key;
            block9: {
                key = entry.getKey();
                int index = key.indexOf(".");
                String dbName = null;
                tableName = null;
                if (index >= 0) {
                    dbName = key.substring(0, index);
                    tableName = key.substring(index + 1);
                }
                if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
                    conn = LegoDBConnection.getInstance().connectGaussDB(dbInfor, dbName, false);
                }
                if (null != conn) break block9;
                LOGGER.info((Object)String.format(Locale.ROOT, "DB :%s is not exist, need not to excute create table sql", dbName));
                this.closeResource(conn, pst, rs);
                continue;
            }
            try {
                DatabaseMetaData meta = conn.getMetaData();
                rs = meta.getTables(null, null, tableName, null);
                if (!rs.next()) {
                    String sql = entry.getValue();
                    LOGGER.info((Object)String.format(Locale.ROOT, "%s is not exist, So create.", key));
                    pst = this.getPreparedStatement(sql, conn);
                    pst.execute();
                }
                this.closeResource(conn, pst, rs);
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), "Sql Error");
                    throw new SQLException();
                }
                catch (Throwable throwable) {
                    this.closeResource(conn, pst, rs);
                    throw throwable;
                }
            }
        }
    }

    public void dropTable(DataBaseInfo dataBaseInfo) throws SQLException {
        Connection sqlConnection = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        Map<String, String> createTableMap = this.dbinit.getTable();
        for (Map.Entry<String, String> entry : createTableMap.entrySet()) {
            String tableName;
            String mapKey;
            block9: {
                mapKey = entry.getKey();
                int index = mapKey.indexOf(".");
                String dbName = null;
                tableName = null;
                if (index >= 0) {
                    dbName = mapKey.substring(0, index);
                    tableName = mapKey.substring(index + 1);
                }
                if (GAUSS.equalsIgnoreCase(dataBaseInfo.getDbType())) {
                    sqlConnection = LegoDBConnection.getInstance().connectGaussDB(dataBaseInfo, dbName, false);
                }
                if (null != sqlConnection) break block9;
                LOGGER.info((Object)String.format(Locale.ROOT, "DB :%s is not exist, need not to excute drop table sql", dbName));
                this.closeResource(sqlConnection, pst, rs);
                continue;
            }
            try {
                DatabaseMetaData meta = sqlConnection.getMetaData();
                rs = meta.getTables(null, null, tableName, null);
                if (rs.next()) {
                    String sql = entry.getValue();
                    LOGGER.info((Object)String.format(Locale.ROOT, "%s is exist, So Drop.", mapKey));
                    pst = this.getPreparedStatement(sql, sqlConnection);
                    pst.execute();
                }
                this.closeResource(sqlConnection, pst, rs);
            }
            catch (SQLException e) {
                try {
                    LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), "SQL error");
                    throw new SQLException();
                }
                catch (Throwable throwable) {
                    this.closeResource(sqlConnection, pst, rs);
                    throw throwable;
                }
            }
        }
    }

    private void closeResource(Connection conn, PreparedStatement pst, ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)("SQL error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)("SQL error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        if (pst != null) {
            try {
                pst.close();
            }
            catch (SQLException e) {
                LOGGER.error((Object)("SQL error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }

    public static PreparedStatement executeSQLQuery(Connection conn, String sql) throws PatchException {
        PreparedStatement pst = null;
        try {
            pst = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            PatchException ex = new PatchException("executesqlquery failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
            throw ex;
        }
        return pst;
    }

    public static void executeSQL(Connection conn, String sql) throws PatchException {
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(sql);
            st.execute();
        }
        catch (SQLException e) {
            LOGGER.error((Object)("ExecuteSQL failed." + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            PatchException ex = new PatchException("executeSQL failed.");
            throw ex;
        }
        finally {
            InitSQL.closePreparedStatement(st);
        }
    }

    public static void executeSQL(Connection conn, List<String> sqlList) {
        if (null == sqlList || sqlList.isEmpty()) {
            LOGGER.error((Object)"SqlList is empty, return.", "");
            return;
        }
        for (String sql : sqlList) {
            InitSQL.executeSQL(conn, sql, new ArrayList<String>());
        }
    }

    public static void executeSQL(Connection conn, String sql, List<String> dataList) {
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(sql);
            if (null != dataList && !dataList.isEmpty()) {
                for (int i = 0; i < dataList.size(); ++i) {
                    st.setString(i + 1, dataList.get(i));
                }
            }
            st.execute();
        }
        catch (SQLException e) {
            LOGGER.error((Object)("ExecuteSQL failed." + e), "");
            PatchException ex = new PatchException("executeSQL failed.");
            throw ex;
        }
        finally {
            InitSQL.closePreparedStatement(st);
        }
    }

    private static void closePreparedStatement(PreparedStatement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)("Close error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    public static void executeSQL(Connection con, String sql, Object[] params) throws PatchException {
        PreparedStatement pstatementObj = null;
        try {
            pstatementObj = con.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                Object objectVal = params[i];
                if (objectVal instanceof Integer) {
                    pstatementObj.setInt(i + 1, (Integer)objectVal);
                }
                if (objectVal instanceof String) {
                    pstatementObj.setString(i + 1, (String)objectVal);
                }
                if (objectVal instanceof Long) {
                    pstatementObj.setLong(i + 1, (Long)objectVal);
                }
                if (null != objectVal) continue;
                pstatementObj.setString(i + 1, null);
            }
            pstatementObj.execute();
        }
        catch (SQLException e) {
            LOGGER.error((Object)("ExecuteSQL failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            PatchException ex = new PatchException("excute failed.");
            throw ex;
        }
        finally {
            try {
                if (pstatementObj != null) {
                    pstatementObj.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error((Object)("Close faild: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            InitSQL.closePreparedStatement(pstatementObj);
        }
    }
}

