/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.clichangedb.main;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.cli.clichangedb.database.DBInfo;
import com.huawei.lego.cli.climain.CliMain;
import com.huawei.lego.common.changedb.ChangeDBRun;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.util.HalfFullCheckUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.common.util.PasswordCheckUtil;
import com.huawei.lego.common.util.PortCheckUtil;
import com.huawei.lego.common.util.SetProcessThread;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.Console;
import java.util.Arrays;
import java.util.Scanner;

public class CliChangeDB {
    private static final Log LOG = LogFactory.getInstance(CliChangeDB.class);
    private static DataBaseInfo dbInfor = null;
    private static final int INT_1000 = 1000;
    private static final int INT_100 = 100;
    private static CliChangeDB instance = null;
    private static boolean isGreenGauss = Boolean.parseBoolean(LegoResourceManager.getProValue("isGreenGauss"));
    private InstalledSystem system = InitInstalledXmlTool.getInstalledSystem();
    private Thread changeDBThread;

    public CliChangeDB() {
        dbInfor = this.system.getDbInfor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CliChangeDB getInstance() {
        Class<CliChangeDB> clazz = CliChangeDB.class;
        synchronized (CliChangeDB.class) {
            if (null == instance) {
                instance = new CliChangeDB();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public InstalledSystem getInstallSystem() {
        return this.system;
    }

    public void startChangeDataBaseInfo() {
        this.printSystemInstalledDBInfo();
        this.verifyCurrentDataBasePassword();
        this.verifyInputDataBaseInfo();
        this.startModifyDataBaseInfoThread();
    }

    public void printSystemInstalledDBInfo() {
        SystemPrint.systemPrintStr(LegoResourceManager.getString("COMMON.TXT.CHANGEDB", CliMain.SOFTWARE_NAME));
        SystemPrint.systemPrintStr(LegoResourceManager.getString("COMMON.TXT.MENUE_VALID_OLD_DBINFOR.TXT.CLI"));
        SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.SET.DB.TYPE.CLI") + dbInfor.getDbType());
        SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.SET.DB.DBSERVER.CLI") + dbInfor.getDbHost());
        SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.SET.DB.PORT.CLI") + dbInfor.getDbPort());
    }

    public boolean verifyCurrentDataBasePassword() {
        String oldPwd;
        do {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.CHANGEDB.INPUT.OLD.PASSWORD.CLI"));
            Console cons = System.console();
            char[] consolePwd = cons.readPassword();
            oldPwd = String.valueOf(consolePwd);
            if (consolePwd == null) continue;
            this.fillZero(consolePwd);
        } while (!DBInfo.checkCurrentDataBasePwd(oldPwd, dbInfor));
        return true;
    }

    private void fillZero(char[] arr) {
        for (int i = 0; i < 3; ++i) {
            Arrays.fill(arr, '\u0000');
        }
    }

    public void verifyInputDataBaseInfo() {
        SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.BLANK.ROW.CLI"));
        SystemPrint.systemPrintStr(LegoResourceManager.getString("COMMON.TXT.MENUE_CONFIG_NEW_DBINFOR.TXT.CLI"));
        while (true) {
            this.verifyInputIp();
            this.verifyInputPort();
            this.verifyInputUsername();
            this.verifyInputPassword();
            if (!DBInfo.checkDBConnection(dbInfor)) {
                SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.CONNECTION.ERROR"));
                continue;
            }
            this.verifyInputManagerPassword();
            if (DBInfo.checkManagerDBConnection(dbInfor)) break;
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.CONNECTION.ERROR"));
        }
    }

    private void verifyInputManagerPassword() {
        String newPassword = this.verifyInputPassword(LegoResourceManager.getString("LEGO.CHANGEDB.INPUT.MANAGER.PASSWORD.CLI"));
        if (!dbInfor.getManagerPassword().equals(newPassword)) {
            dbInfor.setManagerPassword(newPassword);
            dbInfor.setManagerPwdChanged(true);
        }
    }

    private void verifyInputPassword() {
        String newPassword = this.verifyInputPassword(LegoResourceManager.getString("LEGO.CHANGEDB.INPUT.NEW.PASSWORD.CLI"));
        if (!dbInfor.getDbaPassword().equals(newPassword)) {
            dbInfor.setDbaPassword(newPassword);
            dbInfor.setDbaPwdChanged(true);
        }
    }

    private String verifyInputPassword(String hint) {
        String password;
        while (true) {
            SystemPrint.systemPrintStr(hint);
            Console cons = System.console();
            char[] consolePwd = cons.readPassword();
            password = String.valueOf(consolePwd);
            if (password.length() == 0) {
                SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.SET.PASSWORD.ERROR"));
                continue;
            }
            if (PasswordCheckUtil.checkPasswordComplexity4Gauss(password)) break;
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.GAUSSDB.PASSWORD.COMPLEX.CHECK"));
        }
        return password;
    }

    private void verifyInputIp() {
        String ip;
        while (true) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.CHANGEDB.INPUT.IP.ADDRESS.CLI"));
            Scanner scanner = new Scanner(System.in);
            ip = scanner.nextLine();
            if (ParamCheck.checkIpAddress(ip)) break;
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.SET.SERVERNAME.ERROR"));
        }
        dbInfor.setDbHost(ip);
    }

    private void verifyInputPort() {
        String port;
        while (true) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.CHANGEDB.INPUT.PORT.CLI"));
            Scanner scanner = new Scanner(System.in);
            port = scanner.nextLine();
            if (PortCheckUtil.checkPort(port)) break;
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.SET.PORT.LINUX.ERROR"));
        }
        dbInfor.setDbPort(port);
    }

    private void verifyInputUsername() {
        String username;
        while (true) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.CHANGEDB.INPUT.USER.NAME.CLI"));
            Scanner scanner = new Scanner(System.in);
            username = scanner.nextLine();
            if (username.length() == 0) {
                SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.SET.USERNAME.ERROR"));
                continue;
            }
            if (!HalfFullCheckUtil.validFullChar(username)) break;
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.SET.USERNAME.ERROR"));
        }
        dbInfor.setDbaUsername(username);
    }

    public void startModifyDataBaseInfoThread() {
        int progressValue;
        SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.BLANK.ROW.CLI"));
        SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.CHANGEDB.BEGIN.TIP.CLI"));
        this.changeDBThread = new Thread(new ChangeDBRun(dbInfor));
        this.changeDBThread.start();
        SetProcessThread.getInstance().start();
        int lastProgressValue = progressValue = SetProcessThread.getInstance().getCurrentValue();
        while (progressValue < 100) {
            progressValue = SetProcessThread.getInstance().getCurrentValue();
            if (lastProgressValue != progressValue && progressValue != 100) {
                SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.CHANGINGDB.PROGRESS.TIP.CLI") + progressValue + "%");
                lastProgressValue = progressValue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Exception: " + e), "");
            }
        }
    }
}

