/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.install.autodeploy;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.cli.extendclass.ExtendClassUtil;
import com.huawei.lego.cli.install.autodeploy.IAutoDeployExtend;
import com.huawei.lego.cli.util.InstallDBTool;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.install.Install;
import com.huawei.lego.common.util.InitBundleXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.common.util.UpdateUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.util.Locale;

public class AutoDeploy {
    private static final Log LOG = LogFactory.getInstance(AutoDeploy.class);
    private static final int INT2 = 2;
    private static boolean isGreenGauss = Boolean.parseBoolean(LegoResourceManager.getProValue("isGreenGauss"));

    public static void main(String[] args) throws InterruptedException {
        if (null == args || 0 == args.length || "".equals(args[0].trim())) {
            LOG.error((Object)"CLI install can't get database password");
            PrepareParamUtil.exitFail(-1);
        }
        String managerDbaPwd = "";
        if (InitBundleXmlTool.getDBType().equals("Gauss") && isGreenGauss) {
            managerDbaPwd = args[1];
            if (args.length > 2) {
                managerDbaPwd = args[2];
            }
        }
        try {
            UpdateUtil.updateCrypt();
            UpdateUtil.exportConfig();
        }
        catch (PatchException e) {
            PrepareParamUtil.exitFail(-1);
        }
        AutoDeploy.initEnv(args[0], managerDbaPwd);
        boolean isReusingDb = Boolean.FALSE;
        if (args.length > 1) {
            if (args[1].equalsIgnoreCase("isdbvalid")) {
                AutoDeploy.checkDBValid();
            }
            if (args[1].equalsIgnoreCase("islegoDb")) {
                AutoDeploy.checkLegoReUsing();
            }
            if (args[1].equalsIgnoreCase("reusingDb")) {
                isReusingDb = Boolean.TRUE;
            }
        }
        AutoDeploy.run(isReusingDb);
    }

    private static void initEnv(String dbPwd, String managerDbaPwd) {
        String managerDbaPwdDecode;
        String dbPwdDecode = WccEncryptor.retryDecode(dbPwd);
        if (!"".equals(dbPwdDecode)) {
            dbPwd = dbPwdDecode;
        }
        if (!("".equals(managerDbaPwd) || "isdbvalid".equals(managerDbaPwd) || "islegoDb".equals(managerDbaPwd) || "".equals(managerDbaPwdDecode = WccEncryptor.retryDecode(managerDbaPwd)))) {
            managerDbaPwd = managerDbaPwdDecode;
        }
        if (ExtendClassUtil.hasExtendFile()) {
            IAutoDeployExtend extendClass = (IAutoDeployExtend)ExtendClassUtil.getExtendClass(AutoDeploy.class.getName());
            extendClass.initEnv(dbPwd, managerDbaPwd);
        } else {
            PrepareParamUtil.initEnv(dbPwd, managerDbaPwd);
        }
    }

    private static void run(boolean isReusingDb) {
        if (ExtendClassUtil.hasExtendFile()) {
            IAutoDeployExtend extendClass = (IAutoDeployExtend)ExtendClassUtil.getExtendClass(AutoDeploy.class.getName());
            extendClass.run();
        } else {
            AutoDeploy.legoRun(isReusingDb);
        }
    }

    private static void legoRun(boolean isReusingDb) {
        try {
            Install installProcess = new Install(PrepareParamUtil.getsInstallDto().getInstallpath());
            SystemPrint.systemPrintStr("Start install software. Please wait...");
            installProcess.process();
            SystemExitUtil.exitOK();
        }
        catch (Exception e) {
            LOG.error((Object)String.format(Locale.ROOT, "Install failed, errMsg=%s", ExceptionUtil.getErrorMessage((Throwable)e)));
            SystemExitUtil.exitFail();
        }
    }

    private static void checkDBValid() {
        DataBaseInfo dbInfor = PrepareParamUtil.getsInstallDto().getDbDto();
        boolean isValid = InstallDBTool.checkDbValid(dbInfor);
        if (isValid) {
            PrepareParamUtil.exitFail(0);
        } else {
            PrepareParamUtil.exitFail(1);
        }
    }

    private static void checkLegoReUsing() {
        DataBaseInfo dbInfor = PrepareParamUtil.getsInstallDto().getDbDto();
        boolean dbExit = LegoDBConnection.getInstance().dbExist(dbInfor, "lego");
        if (dbExit) {
            PrepareParamUtil.exitFail(0);
        } else {
            PrepareParamUtil.exitFail(1);
        }
    }
}

