/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.user;

import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserManager {
    private static final Log LOG = LogFactory.getInstance(UserManager.class);

    public static void main(String[] args) {
        if (args.length < 1) {
            LOG.error((Object)("Args length is: " + args.length), "");
            SystemExitUtil.exitFail();
        }
        if (!UserManager.checkUserName(args[0])) {
            LOG.error((Object)"Param format is error.", "");
            SystemExitUtil.exitFail();
        }
        try {
            String cmdLine;
            String pwd = WccEncryptor.decode(LegoResourceManager.getProValue("linux.user.pwd"));
            if (pwd == null || "".equals(pwd)) {
                LOG.error((Object)"Get user pwd failed.", "");
                SystemExitUtil.exitFail();
            }
            if (CmdUtil.execShellCmd(cmdLine = UserManager.getCmdLine(args[0], pwd))) {
                SystemExitUtil.exitOK();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Create user failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        SystemExitUtil.exitFail();
    }

    private static boolean checkUserName(String userName) {
        Pattern pattern = Pattern.compile("^[a-zA-Z]{4,10}$");
        Matcher matcher = pattern.matcher(Normalizer.normalize(userName, Normalizer.Form.NFKC));
        return matcher.matches();
    }

    private static String getCmdLine(String userName, String pwd) {
        StringBuffer cmdLine = new StringBuffer();
        cmdLine.append("useradd ").append(userName).append(" -m;").append("echo ").append(userName).append(":").append(pwd).append(" | chpasswd ");
        return cmdLine.toString();
    }
}

