/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs;

import com.huawei.lego.common.exception.InstallException;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.JarFileUtil;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.common.util.PasswordCheckUtil;
import com.huawei.lego.common.util.PortCheckUtil;
import com.huawei.lego.common.util.PropertyUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ChangeCertsPwd {
    private static final Log LOG = LogFactory.getInstance(ChangeCertsPwd.class);
    private static final String TARGET_FILE = "default.properties";
    private static final String TMP_FILE = "tmp.properties";
    private static final String CERTS_KEY = "keyStore";
    private static final String BACK_FILE = "@tmp";
    private static List<String> changedFile = new ArrayList<String>();
    private static Properties resource = new Properties();
    private static String installPath = "";

    public static void main(String[] args) {
        ChangeCertsPwd.initSystemInfo();
        int portNumber = PortCheckUtil.checkSystemUsing();
        if (-1 != portNumber) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("start.err.10001"));
            SystemExitUtil.exitFail();
        }
        ChangeCertsPwd.initResourceFile();
        try {
            String newPwd = ChangeCertsPwd.readPassword();
            SystemPrint.systemPrintStr(resource.getProperty("start.update.key.store.pass"));
            ChangeCertsPwd.changePwd(installPath, newPwd);
        }
        catch (Exception e) {
            LOG.error((Object)("Change certs pwd failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            SystemPrint.systemPrintStr(resource.getProperty("update.key.store.pass.failed"));
            SystemExitUtil.exitFail();
        }
        SystemPrint.systemPrintStr(resource.getProperty("update.key.store.pass.succ"));
        SystemExitUtil.exitOK();
    }

    private static void initSystemInfo() {
        try {
            installPath = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
        }
        catch (InstallException e) {
            SystemPrint.systemPrintStr(e.getErrorMsg());
            SystemExitUtil.exitFail();
        }
    }

    private static void initResourceFile() {
        String sp = File.separator;
        String languagesFile = installPath + sp + "Runtime" + sp + "bin" + sp + "config" + sp + "lauguages" + sp + "common_en.properties";
        PropertyUtil propertyUtil = new PropertyUtil(languagesFile);
        ChangeCertsPwd.setResource(propertyUtil.getProp());
    }

    public static void setResource(Properties resource) {
        ChangeCertsPwd.resource = resource;
    }

    private static String readPassword() {
        char[] result = null;
        char[] oldPwd = null;
        while (!ChangeCertsPwd.checkKeyStoreOldpwd(new String(oldPwd = System.console().readPassword(resource.getProperty("old.key.store.pass"), new Object[0])))) {
            SystemPrint.systemPrintStr(resource.getProperty("old.key.store.pass.err"));
        }
        while (true) {
            char[] password;
            if (PasswordCheckUtil.checkCertPasswordComplex(new String(password = System.console().readPassword(resource.getProperty("new.key.store.pass"), new Object[0])))) {
                result = System.console().readPassword(resource.getProperty("new.key.store.pass.confirm"), new Object[0]);
                if (new String(result).equals(new String(password))) break;
                SystemPrint.systemPrintStr(resource.getProperty("pass.not.eqauls"));
                continue;
            }
            SystemPrint.systemPrintStr(resource.getProperty("LEGO.KEYSTORE.PASSWORD.COMPLEX.CHECK"));
        }
        ChangeCertsPwd.updateKeyPwd(new String(oldPwd), new String(result));
        return new String(result);
    }

    private static boolean checkKeyStoreOldpwd(String pwd) {
        String sp = File.separator;
        String runtimePath = installPath + sp + LegoResourceManager.getProValue("install.java.name") + sp + "bin" + sp + "keytool";
        String keystore = installPath + sp + "Runtime" + sp + LegoResourceManager.getProValue("install.platform.keystore");
        if (!ParamCheck.checkValidConfig(runtimePath) || !ParamCheck.checkValidConfig(keystore)) {
            throw new PatchException("keytool or keystore param invalid.");
        }
        File keyTool = new File(runtimePath);
        File keyStore = new File(keystore);
        if (!keyTool.exists() || !keyStore.exists()) {
            LOG.error((Object)"CheckKeyStoreOldpwd failed, keytool or keystore is not exists.", "");
            throw new PatchException("keytool or keystore is not exists.");
        }
        StringBuffer cmd = new StringBuffer();
        cmd.append(runtimePath);
        cmd.append(" -list ");
        cmd.append("-v ");
        cmd.append("-keystore ");
        cmd.append(keystore);
        return CmdUtil.execStrCmd(cmd.toString(), new String[]{pwd});
    }

    public static boolean updateKeyPwd(String oldOwd, String newPwd) {
        if (oldOwd.equals(newPwd)) {
            LOG.info((Object)"The old and new passwords are the same.", "");
            return true;
        }
        String sp = File.separator;
        if (VerifyUtil.isEmpty((String)installPath)) {
            installPath = InitInstalledXmlTool.getInstallPath();
        }
        String runtimePath = installPath + sp + LegoResourceManager.getProValue("install.java.name") + sp + "bin" + sp + "keytool";
        String keystore = installPath + sp + "Runtime" + sp + LegoResourceManager.getProValue("install.platform.keystore");
        if (!ParamCheck.checkValidConfig(runtimePath) || !ParamCheck.checkValidConfig(keystore)) {
            throw new PatchException("keytool or keystore param invalid.");
        }
        File keyTool = new File(runtimePath);
        File keyStore = new File(keystore);
        if (!keyTool.exists() || !keyStore.exists()) {
            LOG.error((Object)"UpdateKeyPwd failed, keytool or keystore is not exists.", "");
            throw new PatchException("keytool or keystore not found.");
        }
        StringBuffer cmd = new StringBuffer();
        cmd.append(runtimePath);
        cmd.append(" -storepasswd ");
        cmd.append("-keystore ");
        cmd.append(keystore);
        return CmdUtil.execStrCmd(cmd.toString(), new String[]{oldOwd, newPwd, newPwd});
    }

    private static void rollBack() {
        if (null == changedFile || changedFile.size() == 0) {
            LOG.error((Object)"No file need rollback.", "");
            return;
        }
        for (String file : changedFile) {
            try {
                FileUtil.copyFile(file + BACK_FILE, file);
            }
            catch (Exception e) {
                LOG.error((Object)String.format(Locale.ROOT, "RollBack file failed, errMsg: %s.", ExceptionUtil.getErrorMessage((Throwable)e)));
                continue;
            }
            FileUtil.deleteFile(file + BACK_FILE);
        }
    }

    public static void changePwd(String installPath, String pwd) {
        String sp = File.separator;
        try {
            String confFile = installPath + sp + "Runtime/LegoRuntime/conf/lego.properties";
            ChangeCertsPwd.changeLegoProFile(confFile, pwd);
        }
        catch (Exception e) {
            LOG.error((Object)("Update certs pwd failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            ChangeCertsPwd.rollBack();
            throw new PatchException("update certs pwd failed.");
        }
        if (null != changedFile && changedFile.size() != 0) {
            for (String file : changedFile) {
                FileUtil.deleteFile(file + BACK_FILE);
            }
        }
    }

    private static void changeLegoProFile(String confFile, String pwd) {
        try {
            HashMap<String, String> maps = new HashMap<String, String>();
            maps.put(CERTS_KEY, WccEncryptor.encode(pwd));
            changedFile.add(confFile);
            FileUtil.modifyDBPropFileUsingStr(confFile, maps, confFile);
        }
        catch (Exception e) {
            LOG.error((Object)("Change lego.properties file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new PatchException("change lego.properties file failed.");
        }
    }

    private static void changeJarConf(String baseJar, String pwd) {
        try {
            JarFileUtil.copyFileFromJar(baseJar, TARGET_FILE, TMP_FILE);
            HashMap<String, String> maps = new HashMap<String, String>();
            String oldPwd = new PropertyUtil(TMP_FILE).getValue(CERTS_KEY);
            String decode = WccEncryptor.decode(oldPwd);
            if (!pwd.equals(decode)) {
                LOG.info((Object)"Start change properties in jar.", "");
                FileUtil.copyFile(baseJar, baseJar + BACK_FILE);
                changedFile.add(baseJar);
                maps.put(CERTS_KEY, WccEncryptor.encode(pwd));
                FileUtil.modifyDBPropFileUsingStr(TMP_FILE, maps, TMP_FILE);
                JarFileUtil.editJar(baseJar, TARGET_FILE, TMP_FILE);
                LOG.info((Object)"End change properties in jar.", "");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Change Jar config file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new PatchException("change Jar config file failed.");
        }
        finally {
            FileUtil.deleteFile(TMP_FILE);
        }
    }

    public static String getTomcatKeyStorePwd(String xmlFile) {
        SAXReader reader = new SAXReader();
        String oldPwd = "";
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(xmlFile);
            List element = document.selectNodes("/Server/Service/Connector");
            for (Node ele : element) {
                Attribute keyStore = ((Element)ele).attribute("keystoreFile");
                Attribute keyPass = ((Element)ele).attribute("keystorePass");
                if (null == keyStore || null == keyPass) continue;
                oldPwd = WccEncryptor.decode(keyPass.getValue());
            }
        }
        catch (Exception e) {
            LOG.error((Object)("GetTomcatKeyStorePwd failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new PatchException("get keystore pwd from tomcat conf file failed.");
        }
        return oldPwd;
    }

    public static String getTomcatKeyPwd(String xmlFile) {
        SAXReader reader = new SAXReader();
        String oldPwd = "";
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(xmlFile);
            List element = document.selectNodes("/Server/Service/Connector");
            for (Node ele : element) {
                Attribute keyStore = ((Element)ele).attribute("keystoreFile");
                Attribute keyStorePass = ((Element)ele).attribute("keystorePass");
                Attribute keyPass = ((Element)ele).attribute("keyPass");
                if (null == keyStore || null == keyStorePass) continue;
                oldPwd = null == keyPass ? "" : WccEncryptor.decode(keyPass.getValue());
            }
        }
        catch (Exception e) {
            LOG.error((Object)("GetTomcatKeyPwd failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        return oldPwd;
    }
}

