/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs;

import com.huawei.lego.common.certs.BackupDetail;
import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.certs.Component;
import com.huawei.lego.common.util.ConsoleUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public abstract class ComponentCommand {
    private static final Log LOG = LogFactory.getInstance(ComponentCommand.class);
    private Component component;

    public ComponentCommand(Component component) {
        this.component = component;
    }

    protected String getCertificateArchivePath() {
        return Paths.get(CertificateUtil.getInstallPath(), "Runtime/LegoRuntime/certs/components", this.component.getName() + ".cert").toString();
    }

    protected abstract void restart(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(String module, boolean async) {
        String scriptPath = Paths.get(CertificateUtil.getInstallPath(), "Runtime/ha/module/harm/plugin/script", module + ".sh").toString();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        if (async) {
            builder.command("sh", "-c", String.format("sleep 5 && %s stop", scriptPath));
            builder.inheritIO();
        } else {
            builder.command(scriptPath, "stop");
        }
        builder.redirectErrorStream(true);
        InputStream stream = null;
        try {
            Process process = builder.start();
            if (async) {
                return;
            }
            stream = process.getInputStream();
            while (process.isAlive()) {
                int available = stream.available();
                if (available > 0) {
                    stream.read(new byte[available]);
                    continue;
                }
                Thread.sleep(1L);
            }
            if (process.exitValue() != 0) {
                LOG.error((Object)String.format(Locale.ROOT, "Shutdown %s module failed.", module));
            } else {
                LOG.info((Object)String.format(Locale.ROOT, "Shutdown %s module success.", module));
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.error((Object)String.format(Locale.ROOT, "Shutdown %s module failed.", module));
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                LOG.warn((Object)"close process inputStream exception");
            }
        }
    }

    protected void rollback(Map<String, String> recordings) {
        for (Map.Entry<String, String> entry : recordings.entrySet()) {
            String backup = entry.getKey();
            String source = entry.getValue();
            if (source != null) {
                try {
                    FileUtil.copyFile(backup, source);
                }
                catch (IOException e) {
                    LOG.error((Object)("Rollback failed. file: " + new File(backup).getName()), (Throwable)e);
                    continue;
                }
            }
            if (new File(backup).delete()) continue;
            LOG.error((Object)("Delete backup file failed. file: " + new File(backup).getName()));
        }
    }

    public static void backup(Map<String, String> backups, String file, long timestamp, String message) {
        ComponentCommand.copy(file, BackupDetail.getBackupFileName(file, timestamp), message, backups);
    }

    public static void copy(String source, String target, String message, Map<String, String> backups) {
        try {
            FileUtil.copyFile(source, target);
            if (backups != null) {
                backups.put(target, null);
            }
        }
        catch (IOException e) {
            String error = message + " failed. file: " + Paths.get(FilenameUtils.normalize((String)source), new String[0]).getFileName();
            LOG.error((Object)error, (Throwable)e);
            throw new LegoCheckedException(error);
        }
    }

    public static void move(String source, String target, String message, Map<String, String> backups) {
        ComponentCommand.copy(source, target, message, backups);
        if (new File(source).delete()) {
            backups.put(target, source);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    protected void feedback(String data) {
        if (ConsoleUtil.redirected()) {
            SystemPrint.systemPrintStr("#FEEDBACK# " + data);
        }
    }

    protected static boolean confirm(String message) {
        if (ConsoleUtil.redirected()) {
            return true;
        }
        String answer = ConsoleUtil.readLine(message, new Object[0]);
        return "y".equalsIgnoreCase(answer);
    }
}

