/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs;

import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.util.Locale;

public class ConfigCertSwitch {
    private static final Log LOG = LogFactory.getInstance(ConfigCertSwitch.class);
    private static final int ARG_VALID_LENGTH = 2;
    private static final String TRUE_VALUE_CODE = "1";
    private static final String FALSE_VALUE_CODE = "0";
    private static final String LEGO_CONFIG_PATH = "/LegoRuntime/conf/lego.properties";

    public static void main(String[] args) {
        if (VerifyUtil.isEmpty((Object[])args) || args.length != 2) {
            LOG.error((Object)"ConfigCertSwitch failed, cause args is invalid.");
            SystemExitUtil.exitFail();
        }
        String certType = args[0];
        ConfigCertSwitch.checkCertType(certType);
        String switchValue = ConfigCertSwitch.convertConfigValue(args[1]);
        ConfigCertSwitch.modifyCertSwitchConfig(certType, switchValue);
        SystemExitUtil.exitOK();
    }

    private static void checkCertType(String certType) {
        if (!"cert.auth.switch".equals(certType)) {
            LOG.error((Object)"ConfigCertSwitch failed,, cause certType invalid.");
            SystemExitUtil.exitFail();
        }
    }

    private static String convertConfigValue(String switchValue) {
        String configValue = null;
        if (FALSE_VALUE_CODE.equals(switchValue)) {
            configValue = Boolean.FALSE.toString();
        } else if (TRUE_VALUE_CODE.equals(switchValue)) {
            configValue = Boolean.TRUE.toString();
        } else {
            LOG.error((Object)"ConfigCertSwitch failed, cause switchValue invalid.");
            SystemExitUtil.exitFail();
        }
        return configValue;
    }

    private static void modifyCertSwitchConfig(String certType, String switchValue) {
        try {
            LegoConfig legoConfig = LegoConfig.getInstance((String)(PathUtil.getInstallPath() + LEGO_CONFIG_PATH));
            legoConfig.setConfigValue(certType, switchValue);
            LOG.info((Object)String.format(Locale.ROOT, "Config of %s, value of: %s modify success.", certType, switchValue));
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)String.format(Locale.ROOT, "Config of %s modify failed.", certType));
            SystemExitUtil.exitFail();
        }
    }
}

