/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.kmc.common.AppException;
import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.text.Normalizer;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class ImportCert {
    private static final Log LOG = LogFactory.getInstance(ImportCert.class);
    private static final int ARG_VALID_LENGTH = 2;
    private static final String KEYSTORE = "keyStore";
    private static final String KEYSTORE_TYPE = "JKS";
    private static final String KMC_CONF_PATH = "/LegoRuntime/conf/wcc/";
    private static final String BCM_KEYSTORE_PATH = "/LegoRuntime/certs/bcm.keystore";
    private static final String LEGO_PROPERTIES_PATH = "/LegoRuntime/conf/lego.properties";
    private static final Set<String> CERT_TYPE_TRUST_LIST = ImmutableSet.of((Object)"DER", (Object)"CER", (Object)"CRT", (Object)"PEM");
    private static final Pattern ALIAS_REGEX = Pattern.compile("^[A-Za-z0-9][A-Za-z0-9.-]*$");
    private static final int MAX_ALIAS_LENGTH = 100;
    private static final int MAX_FILE_SIZE = 0x100000;

    public static void main(String[] args) {
        String aliasName;
        if (VerifyUtil.isEmpty((Object[])args) || args.length != 2) {
            LOG.error((Object)"ImportCert failed, cause args is invalid.");
            SystemExitUtil.exitFail();
        }
        if (VerifyUtil.isEmpty((String)(aliasName = args[0]))) {
            LOG.error((Object)"ImportCert fail, cause aliasName is empty.");
            SystemExitUtil.exitFail();
        }
        aliasName = Normalizer.normalize(aliasName, Normalizer.Form.NFKC);
        ImportCert.checkAliasName(aliasName);
        String certFilePath = FilenameUtils.normalize((String)args[1]);
        ImportCert.checkCertFilePath(certFilePath);
        Optional runtimePathOptional = SysPropertiesUtils.getRuntimePath();
        if (!runtimePathOptional.isPresent()) {
            LOG.error((Object)"Import cert failed, cause runtimePath not find.");
            SystemExitUtil.exitFail();
        }
        String runtimePath = (String)runtimePathOptional.get();
        String bcmKeyStorePath = runtimePath + BCM_KEYSTORE_PATH;
        String encryptBcmKeystorePwd = LegoConfig.getInstance((String)(runtimePath + LEGO_PROPERTIES_PATH)).getKeyValue(KEYSTORE);
        try {
            KmcInstance.initComponent((String)(runtimePath + KMC_CONF_PATH), (boolean)true);
            String bcmKeystorePwd = KmcInstance.decrypt((String)encryptBcmKeystorePwd);
            CertificateUtil certUtil = new CertificateUtil(bcmKeyStorePath, bcmKeystorePwd, KEYSTORE_TYPE);
            certUtil.importCertToKeystore(aliasName, certFilePath, Boolean.FALSE);
        }
        catch (AppException | PatchException e) {
            LOG.error((Object)String.format(Locale.ROOT, "Import cert failed, msg:%s", ExceptionUtil.getErrorMessage((Throwable)e)));
            SystemExitUtil.exitFail();
        }
        SystemExitUtil.exitOK();
    }

    private static void checkAliasName(String aliasName) {
        if (aliasName.length() > 100 || !ALIAS_REGEX.matcher(aliasName).matches()) {
            LOG.error((Object)"ImportCert fail, cause aliasName invalid.");
            SystemExitUtil.exitFail();
        }
    }

    private static void checkCertFilePath(String certFilePath) {
        File file;
        if (VerifyUtil.isEmpty((String)certFilePath)) {
            LOG.error((Object)"ImportCert fail, cause certFilePath is empty.");
            SystemExitUtil.exitFail();
        }
        if (!(file = new File(certFilePath)).exists()) {
            LOG.error((Object)"ImportCert fail, cause certFile not exist.");
            SystemExitUtil.exitFail();
        }
        if (file.length() > 0x100000L) {
            LOG.error((Object)"ImportCert fail, cause certFile exceeded the limit.");
            SystemExitUtil.exitFail();
        }
        String fileExtension = FilenameUtils.getExtension((String)file.getName());
        boolean isInvalid = CERT_TYPE_TRUST_LIST.stream().noneMatch(validCertType -> validCertType.equalsIgnoreCase(fileExtension));
        if (isInvalid) {
            LOG.error((Object)"ImportCert fail, cause certFile extension not Match.");
            SystemExitUtil.exitFail();
        }
    }
}

