/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs.rollback;

import com.huawei.lego.common.certs.BackupDetail;
import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.certs.Component;
import com.huawei.lego.common.certs.rollback.CertificateRollbackCommand;
import com.huawei.lego.common.util.SystemExitUtil;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Locale;
import java.util.Map;

public class WebServerCertificateRollbackCommand
extends CertificateRollbackCommand {
    private WebServerCertificateRollbackCommand() {
        super(Component.webServer());
    }

    @Override
    protected void rollbackCerts(BackupDetail detail, Map<String, String> recordings) {
        super.rollbackCerts(detail, recordings);
        Component component = this.getComponent();
        try {
            String path = Paths.get(component.getHome(), "Runtime/LegoRuntime/certs/bcm.keystore").toString();
            String password = CertificateUtil.getPasswordFromConfig(Paths.get(component.getHome(), "Runtime/LegoRuntime/conf/lego.properties").toString(), "keyStore");
            WebServerCertificateRollbackCommand.copy(path, path + ".bak.rollback", "backup bcm.keystore", recordings);
            KeyStore backup = CertificateUtil.loadKeyStore(path, "JKS", password);
            CertificateUtil.removeMatchedCertificate(backup, String.format(Locale.ROOT, "^(%s)-active-(.*)$", this.getComponent().getName()));
            CertificateUtil.renameMatchedCertificate(backup, String.format(Locale.ROOT, "^(%s)-backup-(.*)$", this.getComponent().getName()), "$1-active-$2");
            CertificateUtil.saveKeyStore(backup, path, password);
        }
        catch (IOException | GeneralSecurityException e) {
            throw SystemExitUtil.failed("rollback to trust key store for " + this.getComponent().getName() + " failed", e);
        }
    }

    @Override
    protected void restart(long timestamp) {
        this.shutdown("webServer", false);
    }

    public static void main(String ... args) {
        new WebServerCertificateRollbackCommand().execute();
        System.exit(0);
    }
}

