/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.cipher.sm;

import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FilenameUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SMFileEncryptor {
    private static final Log LOGGER = LogFactory.getInstance(SMFileEncryptor.class);
    private static final int IV_LEN = 16;
    private static final int KEY_LEN = 16;
    private static final int READ_LEN = 1024;
    private static final String ALGORITHM_NAME_SM4 = "SM4";
    private static final String ALGORITHM_NAME_SM3 = "SM3";
    private static final String ALGORITHM_NAME_CBC_PADDING = "SM4/CBC/PKCS5Padding";
    private static final String ALGORITHM_NAME_GCM_NOPADDING = "SM4/GCM/NoPadding";

    private static Cipher generateCipher(int cipherMode, byte[] keyData, byte[] iv, boolean isDecryptByGCM) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = cipherMode == 2 && !isDecryptByGCM ? Cipher.getInstance(ALGORITHM_NAME_CBC_PADDING, "BC") : Cipher.getInstance(ALGORITHM_NAME_GCM_NOPADDING, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(keyData, ALGORITHM_NAME_SM4);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(cipherMode, (Key)sm4Key, ivParameterSpec);
        return cipher;
    }

    public static void encryptFile(String ivPath, File sourceFile, String targetName, String pwd) {
        Cipher cipher = SMFileEncryptor.getEncryptCipher(ivPath, pwd);
        String outFile = sourceFile.getParent() + File.separator + targetName;
        try (FileOutputStream outputStream = new FileOutputStream(outFile);
             CipherInputStream cipherInputStream = new CipherInputStream(new FileInputStream(sourceFile), cipher);){
            int nRead;
            byte[] cache = new byte[1024];
            while ((nRead = cipherInputStream.read(cache)) != -1) {
                outputStream.write(cache, 0, nRead);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Encrypt file catch exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    private static Cipher getEncryptCipher(String ivFileName, String pwd) {
        Cipher cipher;
        try {
            SecureRandom ivRandom = SecureRandomFactory.getInstanceStrongWithDRBG();
            byte[] iv = new byte[16];
            ivRandom.nextBytes(iv);
            SMFileEncryptor.writeIvFile(iv, ivFileName);
            byte[] keyData = SMFileEncryptor.generateKey(pwd);
            cipher = SMFileEncryptor.generateCipher(1, keyData, iv, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Init SM4 Cipher failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("init SM4 Cipher failed", e);
        }
        return cipher;
    }

    private static byte[] generateKey(String pwd) throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest digest = MessageDigest.getInstance(ALGORITHM_NAME_SM3, "BC");
        byte[] key = digest.digest(pwd.getBytes(StandardCharsets.UTF_8));
        return Arrays.copyOfRange(key, 0, 16);
    }

    private static void writeIvFile(byte[] iv, String ivFileName) {
        try (FileOutputStream ivs = new FileOutputStream(FilenameUtils.normalize((String)ivFileName), false);){
            ivs.write(iv);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Write IV failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("write IV failed.");
        }
    }

    public static void decryptFile(String sourceFile, String targetFile, String pwd, byte[] iv) {
        Cipher gcmCipher = SMFileEncryptor.getDecryptCipher(pwd, iv, true);
        SMFileEncryptor.getDecryptFile(sourceFile, targetFile, gcmCipher);
        File file = new File(targetFile);
        if (file.length() <= 0L) {
            Cipher cbcCipher = SMFileEncryptor.getDecryptCipher(pwd, iv, false);
            SMFileEncryptor.getDecryptFile(sourceFile, targetFile, cbcCipher);
        }
    }

    private static void getDecryptFile(String sourceFile, String targetFile, Cipher cipher) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        CipherOutputStream cipherOutputStream = null;
        try {
            int readLen;
            File file = new File(targetFile);
            if (!file.exists()) {
                boolean createSuccess = file.createNewFile();
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Create file result: %s", createSuccess), "");
            }
            inputStream = new FileInputStream(sourceFile);
            outputStream = new FileOutputStream(file);
            cipherOutputStream = new CipherOutputStream(outputStream, cipher);
            byte[] buffer = new byte[1024];
            while ((readLen = inputStream.read(buffer)) >= 0) {
                cipherOutputStream.write(buffer, 0, readLen);
            }
            cipherOutputStream.flush();
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)("IOException when decryptFile!" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("decryptFile failed.");
            }
            catch (Throwable throwable) {
                FileUtil.close(outputStream, "close output");
                FileUtil.close(cipherOutputStream, "close ciphere");
                FileUtil.close(inputStream, "close input");
                throw throwable;
            }
        }
        FileUtil.close(outputStream, "close output");
        FileUtil.close(cipherOutputStream, "close ciphere");
        FileUtil.close(inputStream, "close input");
    }

    private static Cipher getDecryptCipher(String pwd, byte[] iv, boolean isDecryptByGCM) {
        Cipher cipher;
        try {
            byte[] keyData = SMFileEncryptor.generateKey(pwd);
            cipher = SMFileEncryptor.generateCipher(2, keyData, iv, isDecryptByGCM);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Init SM4 Cipher failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("init SM4 Cipher failed", e);
        }
        return cipher;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

