/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.cloud;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Locale;

public class VhaUpdateProcess {
    private static final Log LOG = LogFactory.getInstance(VhaUpdateProcess.class);
    private static final String SPLIT = ":";
    private static final String DEVID = "devId";
    private static final String REGIONID = "regionId";
    private Connection connect;

    public VhaUpdateProcess(Connection connect) {
        this.connect = connect;
    }

    public void updateAzMapping() {
        try {
            if (!this.isTableExists("ti_openstack_az_mapping")) {
                LOG.info((Object)"Can not find the ti_openstack_az_mapping, no need update vha az mapping.", "");
                return;
            }
            String querySql = "select id.PGID,id.PROPVALUE,az.PROPVALUE from ti_protectgroup_prop as id, ti_protectgroup_prop as az where id.PGID in (select PROTECTGROUPID from ti_serviceinstance where TYPE='vha') and id.PROPNAME='regionId' and id.PGID=az.PGID and az.PROPNAME='zoneName'";
            HashSet<String> regionList = new HashSet<String>();
            PreparedStatement statement = this.connect.prepareStatement(querySql);
            ResultSet result = statement.executeQuery();
            while (null != result && result.next()) {
                String regionInfo = result.getString(2);
                String regionId = this.getIdInfo(regionInfo, REGIONID);
                String opsId = this.getIdInfo(regionInfo, DEVID);
                String azId = result.getString(3);
                if (regionList.contains(regionId)) continue;
                regionList.add(regionId);
                if (this.isAlreadyConfiged(regionId, azId)) {
                    LOG.info((Object)String.format(Locale.ROOT, "Already found az mapping in table, no need update again, region: %s, az: %s", regionId, azId));
                    continue;
                }
                long moid = this.updateManagedObject(opsId);
                LOG.info((Object)String.format(Locale.ROOT, "Start update vha az mapping, id: %s, region: %s, az:%s", moid, regionId, azId));
                String insertSQL = "insert into ti_openstack_az_mapping(MOID, PRIMARYREGIONID, PRIMARYREGION, PRIMARYAZID, PRIMARYAZ, TYPE) values(?, ?, ?, ?, ?, ?)";
                PreparedStatement preparedStatement = this.connect.prepareStatement(insertSQL);
                preparedStatement.setLong(1, moid);
                preparedStatement.setString(2, regionId);
                preparedStatement.setString(3, regionId);
                preparedStatement.setString(4, azId);
                preparedStatement.setString(5, azId);
                preparedStatement.setString(6, "vha");
                preparedStatement.executeUpdate();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Update AZ mapping failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("update AZ mapping failed");
        }
    }

    private boolean isAlreadyConfiged(String regionId, String azId) {
        PreparedStatement preparedStatement = null;
        try {
            String querySql = "select * from ti_openstack_az_mapping where PRIMARYREGIONID=? and PRIMARYAZID=? and TYPE='vha'";
            preparedStatement = this.connect.prepareStatement(querySql);
            preparedStatement.setString(1, regionId);
            preparedStatement.setString(2, azId);
            ResultSet result = preparedStatement.executeQuery();
            boolean bl = null != result && result.next();
            this.closeStatement(preparedStatement);
            return bl;
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Query isAlreadyExists failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("query isAlreadyExists failed");
            }
            catch (Throwable throwable) {
                this.closeStatement(preparedStatement);
                throw throwable;
            }
        }
    }

    private boolean isTableExists(String tableName) {
        PreparedStatement preparedStatement = null;
        try {
            String querySql = "select TABLENAME,TABLEOWNER from pg_tables where SCHEMANAME='PUBLIC' and TABLENAME=?";
            preparedStatement = this.connect.prepareStatement(querySql);
            preparedStatement.setString(1, tableName.toUpperCase(Locale.US));
            ResultSet result = preparedStatement.executeQuery();
            boolean bl = null != result && result.next();
            this.closeStatement(preparedStatement);
            return bl;
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Query tabel exists failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("query tabel exists failed");
            }
            catch (Throwable throwable) {
                this.closeStatement(preparedStatement);
                throw throwable;
            }
        }
    }

    private String getIdInfo(String value, String type) {
        if (VerifyUtil.isEmpty((String)value) || !value.contains(SPLIT)) {
            throw new PatchException("update vha az mapping failed, the region id value is empty or not illegal");
        }
        return value.split(SPLIT)[REGIONID.equals(type) ? 1 : 0];
    }

    private long updateManagedObject(String opsId) {
        PreparedStatement preparedStatement;
        block5: {
            preparedStatement = null;
            String uuid = opsId + SPLIT + UUIDGenerator.getUUID();
            String insertSQL = "insert into t_managedobject(uuid, DISCRIMINATOR, managed, type, is_top_mo) values (?, ?, TRUE, ?, FALSE)";
            preparedStatement = this.connect.prepareStatement(insertSQL, 1);
            preparedStatement.setString(1, uuid);
            preparedStatement.setString(2, "OpenStackAvailabilityZoneMapping");
            preparedStatement.setString(3, "vha");
            preparedStatement.executeUpdate();
            ResultSet rs = preparedStatement.getGeneratedKeys();
            if (!rs.next()) break block5;
            long l = rs.getLong(1);
            this.closeStatement(preparedStatement);
            return l;
        }
        try {
            try {
                throw new PatchException("update managed object failed, get moid keys failed.");
            }
            catch (Exception e) {
                LOG.error((Object)("Update managed object failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("update managed object failed");
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(preparedStatement);
            throw throwable;
        }
    }

    private void closeStatement(PreparedStatement state) {
        if (null != state) {
            try {
                state.close();
            }
            catch (Exception e) {
                LOG.error((Object)("Close state ment failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }
}

