/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.dto;

import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;

public class NetInterface {
    private static final Log LOG = LogFactory.getInstance(NetInterface.class);
    private String devName;
    private String ip;
    private String mac;
    private String netmask;

    public String getNetmaskIP() {
        if (VerifyUtil.isEmpty((String)this.netmask)) {
            return this.netmask;
        }
        if (this.netmask.contains(".")) {
            return this.netmask;
        }
        try {
            int maskValue = Integer.parseInt(this.netmask);
            StringBuilder sb = new StringBuilder();
            sb.append(maskValue >> 24 & 0xFF).append(".");
            sb.append(maskValue >> 16 & 0xFF).append(".");
            sb.append(maskValue >> 8 & 0xFF).append(".");
            sb.append(maskValue & 0xFF);
            return sb.toString();
        }
        catch (Exception e) {
            LOG.error((Object)("GetNetmaskIP failed, errMsg: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            return this.netmask;
        }
    }

    public String getDevName() {
        return this.devName;
    }

    public void setDevName(String devName) {
        this.devName = devName;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ip);
        sb.append(" (");
        sb.append(LegoResourceManager.getString("LEGO.SYSTEM.NET.CARD.NAME"));
        sb.append(" " + this.devName);
        sb.append(")");
        return sb.toString();
    }
}

