/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.extend;

import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.AESEncryptor;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;

public class ExtendCommon {
    private static final Log LOG = LogFactory.getInstance(ExtendCommon.class);
    private static InstalledSystem system = null;
    private static Map<String, ProductBundles> installedBundle = null;
    private static String oldVersion = "";
    private static final String V1R3 = "V100R003C10";
    private static final String V1R3SPC200 = "V100R003C10SPC200";
    private static final String VR_NAME = "UltraVR";

    public static void setOldVersion(String oldVersion) {
        ExtendCommon.oldVersion = oldVersion;
    }

    public static boolean isR3Upgrade() {
        if (!oldVersion.contains(V1R3)) {
            return false;
        }
        if (oldVersion.contains(VR_NAME) && !oldVersion.contains(V1R3SPC200)) {
            LOG.info((Object)"UltraVR V1R3C10SPC200", "");
            return false;
        }
        return true;
    }

    public static void setInstalledSystem() {
        system = InitInstalledXmlTool.getInstalledSystem();
        installedBundle = system.getPdMap();
    }

    public static void queryData(Connection connect, String querySql, String updateSql) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = InitSQL.executeSQLQuery(connect, querySql);
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                ExtendCommon.updateData(connect, rs, updateSql);
            }
        }
        catch (PatchException ep) {
            LOG.error((Object)"", (Throwable)ep, "");
            throw new PatchException("", ep);
        }
        catch (SQLException e) {
            LOG.error((Object)("QueryData failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("queryData failed");
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                LOG.error((Object)("Close faile: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateProtectGroupOsOptionsType(Connection connect) {
        Statement preparedStatement = null;
        int poIdIndex = 1;
        int propValueIndex = 2;
        try {
            String queryPo = "select POID, PROPVALUE from ti_po_prop where PROPNAME = 'vmMgrInfo';";
            String updatePo = "update ti_po_prop set PROPVALUE=? where POID=? and PROPNAME = 'vmMgrInfo';";
            preparedStatement = InitSQL.executeSQLQuery(connect, queryPo);
            ResultSet rs = preparedStatement.executeQuery();
            while (rs.next()) {
                String resultDecode;
                String poId = rs.getString(poIdIndex);
                String propsValue = rs.getString(propValueIndex);
                JSONObject config = JSONObject.fromObject((Object)propsValue);
                String osOption = config.getString("osOption");
                if (VerifyUtil.isEmpty((String)osOption) || !AESEncryptor.encode(resultDecode = AESEncryptor.decode(osOption)).equals(osOption)) continue;
                osOption = WccEncryptor.encode(resultDecode);
                config.put((Object)"osOption", (Object)osOption);
                InitSQL.executeSQL(connect, updatePo, new Object[]{config.toString(), poId});
            }
        }
        catch (PatchException ep) {
            try {
                LOG.error((Object)String.format(Locale.ROOT, "Update OsOptionsType failed: %s", ExceptionUtil.getErrorMessage((Throwable)ep)));
                throw ep;
                catch (SQLException e) {
                    LOG.error((Object)String.format(Locale.ROOT, "Update OsOptionsType failed: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
                    throw new PatchException("queryData failed");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement == null) throw throwable;
                    preparedStatement.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    LOG.error((Object)String.format(Locale.ROOT, "Close fail: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                throw throwable;
            }
        }
        try {
            if (preparedStatement == null) return;
            preparedStatement.close();
            return;
        }
        catch (SQLException e) {
            LOG.error((Object)String.format(Locale.ROOT, "Close fail: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
            return;
        }
    }

    public static void updateData(Connection connect, ResultSet rs, String sql) throws PatchException {
        try {
            String value = rs.getString(1);
            String key1 = rs.getString(2);
            String key2 = rs.getString(3);
            if (null != value && !"".equals(value) && AESEncryptor.encode(AESEncryptor.decode(value)).equals(value)) {
                String pw = WccEncryptor.encode(AESEncryptor.decode(value));
                InitSQL.executeSQL(connect, sql, new Object[]{pw, key1, key2});
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("Update Data failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("update Data failed");
        }
    }

    public static boolean isBundleInstalled(String bundleID) {
        boolean isInstalled = false;
        if (null == installedBundle || installedBundle.size() == 0) {
            return isInstalled;
        }
        if (installedBundle.containsKey(bundleID)) {
            isInstalled = true;
        }
        return isInstalled;
    }
}

