/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.patch.util;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.patch.model.PatchDto;
import com.huawei.lego.common.patch.model.PatchFile;
import com.huawei.lego.common.patch.model.SqlFile;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class InitPatchZipTool {
    private static final Log LOGGER = LogFactory.getInstance(InitPatchZipTool.class);
    private static final int BUFFER_2048 = 2048;
    private static String installPath = null;
    private static final String PATCH_VERSION_CONF = "patchVersion.conf";
    private static final String PATCH_VERSION_KEY = "PATCH_VER";

    public static PatchDto getPatchInforFromXml() {
        String patchPath = InitPatchZipTool.getRuntimePath() + "Runtime" + File.separator + "patch";
        String packagePath = patchPath + File.separator + "package";
        String patchxmlPath = packagePath + File.separator + "patch.xml";
        return InitPatchZipTool.getPatchInfoFromXml(patchxmlPath);
    }

    public static PatchDto getPatchInfoFromXml(String patchxmlPath) {
        PatchDto dto = new PatchDto();
        InputStream in = null;
        BufferedReader br = null;
        try {
            File patchxmlFile = new File(patchxmlPath);
            if (!patchxmlFile.exists()) {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "The old patch file is not exist: %s.", patchxmlFile.getName()));
                PatchDto patchDto = null;
                return patchDto;
            }
            in = new BufferedInputStream(new FileInputStream(patchxmlFile));
            br = new BufferedReader(new InputStreamReader(in));
            dto = InitPatchZipTool.getPatchInfor(br);
        }
        catch (PatchException e) {
            LOGGER.error((Object)"GetPatchInforFromXml", (Throwable)e);
            throw e;
        }
        catch (FileNotFoundException e) {
            PatchException ex = new PatchException("FileNotFoundException");
            ex.setErrorCode(20005L);
            throw ex;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"GetPatchInforFromXml close error ", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"GetPatchInforFromXml close error ", (Throwable)e);
                }
            }
        }
        return dto;
    }

    public static PatchDto getPatchInforFromZip(File file) {
        if (!file.exists()) {
            LOGGER.error((Object)("GetPatchInforFromZip failed, file not found: " + file.getName()));
            throw new PatchException(20001L);
        }
        PatchDto dto = new PatchDto();
        BufferedReader br = null;
        InputStreamReader brIn = null;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(file);
            brIn = new InputStreamReader(fs);
            br = new BufferedReader(brIn);
            dto = InitPatchZipTool.getPatchInfor(br);
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)"GetPatchInforFromZip error", (Throwable)e);
                PatchException ex = new PatchException("", e);
                ex.setErrorCode(20006L);
                throw ex;
            }
            catch (Throwable throwable) {
                InitPatchZipTool.releaseStream(br);
                InitPatchZipTool.releaseStream(brIn);
                InitPatchZipTool.releaseStream(fs);
                throw throwable;
            }
        }
        InitPatchZipTool.releaseStream(br);
        InitPatchZipTool.releaseStream(brIn);
        InitPatchZipTool.releaseStream(fs);
        dto.setPatchFileNames(InitPatchZipTool.traverseFiles(file.getParent()));
        return dto;
    }

    private static Set<String> traverseFiles(String path) {
        File file = new File(path);
        HashSet<String> results = new HashSet<String>();
        if (!file.exists()) {
            return results;
        }
        LinkedList<File> list = new LinkedList<File>();
        list.add(file);
        while (!list.isEmpty()) {
            File[] files;
            File tmpFile = (File)list.removeFirst();
            for (File file2 : files = tmpFile.listFiles()) {
                if (file2.isDirectory()) {
                    list.add(file2);
                    continue;
                }
                results.add(file2.getName());
            }
        }
        return results;
    }

    private static void releaseStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                LOGGER.error((Object)"Release Stream is Error:");
            }
        }
    }

    private static void getPatchInforNull(String sqlfile, String dbName, int index) {
        if (sqlfile == null || dbName == null || index == -1) {
            throw new PatchException(20015L);
        }
    }

    private static boolean getPatchInforValidate(List<Node> list) {
        return list != null && !list.isEmpty();
    }

    public static PatchDto getPatchInfor(Reader reader) {
        PatchDto dto = new PatchDto();
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(reader);
            Element eleTmp = (Element)document.selectSingleNode("/files/patchversion");
            String patchversion = eleTmp.getTextTrim();
            dto.setPatchVersion(patchversion);
            ArrayList<PatchFile> rpFiles = new ArrayList<PatchFile>();
            List list = document.selectNodes("/files/replacefile/file");
            if (InitPatchZipTool.getPatchInforValidate(list)) {
                for (Node ele : list) {
                    PatchFile rpFile = new PatchFile();
                    if (ele == null) continue;
                    rpFile.setSrcName(((Element)ele).attributeValue("srcName"));
                    rpFile.setDistName(((Element)ele).attributeValue("distName"));
                    rpFile.setBundleName(((Element)ele).attributeValue("bundle"));
                    String paths = ((Element)ele).attributeValue("path");
                    InitPatchZipTool.setPath(rpFile, paths);
                    rpFiles.add(rpFile);
                }
                dto.setRpFiles(rpFiles);
            }
            ArrayList<PatchFile> delFiles = new ArrayList<PatchFile>();
            list = document.selectNodes("/files/delfile/file");
            InitPatchZipTool.setFilesToDto(dto, document, list, delFiles);
            InitPatchZipTool.installSQL(dto, document);
            InitPatchZipTool.uninstallSQL(dto, document);
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)"GetPatchInfor error ", e);
            PatchException ex = new PatchException("", e);
            ex.setErrorCode(20015L);
            throw ex;
        }
        return dto;
    }

    private static void setFilesToDto(PatchDto dto, Document document, List<Node> list, List<PatchFile> delFiles) {
        List tmepList = list;
        if (InitPatchZipTool.getPatchInforValidate(tmepList)) {
            for (Node ele : tmepList) {
                PatchFile delFile = new PatchFile();
                if (ele == null) continue;
                delFile.setSrcName(((Element)ele).attributeValue("srcName"));
                delFile.setDistName(((Element)ele).attributeValue("distName"));
                delFile.setBundleName(((Element)ele).attributeValue("bundle"));
                String paths = ((Element)ele).attributeValue("path");
                InitPatchZipTool.setPath(delFile, paths);
                delFiles.add(delFile);
            }
            dto.setDelFiles(delFiles);
        }
        ArrayList<PatchFile> addfiles = new ArrayList<PatchFile>();
        tmepList = document.selectNodes("/files/addfile/file");
        if (InitPatchZipTool.getPatchInforValidate(tmepList)) {
            for (Node ele : tmepList) {
                PatchFile addFile = new PatchFile();
                if (ele == null) continue;
                addFile.setSrcName(((Element)ele).attributeValue("srcName"));
                addFile.setDistName(((Element)ele).attributeValue("distName"));
                addFile.setBundleName(((Element)ele).attributeValue("bundle"));
                String paths = ((Element)ele).attributeValue("path");
                InitPatchZipTool.setPath(addFile, paths);
                addfiles.add(addFile);
            }
            dto.setAddFiles(addfiles);
        }
    }

    private static void installSQL(PatchDto dto, Document document) {
        ArrayList<SqlFile> isqlfiles = new ArrayList<SqlFile>();
        List list = document.selectNodes("/files/sqlfile/install");
        if (InitPatchZipTool.getPatchInforValidate(list)) {
            for (Node ele : list) {
                String isqlfile = ((Element)ele).attributeValue("file");
                String dbName = ((Element)ele).attributeValue("dbName");
                int index = isqlfile.indexOf("_");
                InitPatchZipTool.getPatchInforNull(isqlfile, dbName, index);
                String version = isqlfile.substring(0, index);
                SqlFile sqlF = new SqlFile();
                sqlF.setDbName(dbName);
                sqlF.setSrcName(isqlfile);
                sqlF.setVersion(version);
                isqlfiles.add(sqlF);
            }
            dto.setInstallSqlFiles(isqlfiles);
        }
    }

    private static void uninstallSQL(PatchDto dto, Document document) {
        ArrayList<SqlFile> usqlfiles = new ArrayList<SqlFile>();
        List list = document.selectNodes("/files/sqlfile/uninstall");
        if (InitPatchZipTool.getPatchInforValidate(list)) {
            for (Node ele : list) {
                String usqlfile = ((Element)ele).attributeValue("file");
                String dbName = ((Element)ele).attributeValue("dbName");
                int index = usqlfile.indexOf("_");
                InitPatchZipTool.getPatchInforNull(usqlfile, dbName, index);
                String version = usqlfile.substring(0, index);
                SqlFile sqlF = new SqlFile();
                sqlF.setDbName(dbName);
                sqlF.setSrcName(usqlfile);
                sqlF.setVersion(version);
                usqlfiles.add(sqlF);
            }
            dto.setUninstallSqlFiles(usqlfiles);
        }
    }

    private static void setPath(PatchFile rpFile, String paths) {
        if (null != paths) {
            for (String str : paths.split(",")) {
                String realPath = str.startsWith("/") || !str.startsWith("/") && str.contains(":") ? str : InitPatchZipTool.getRuntimePath() + str;
                if (!(realPath = realPath.replace("/", File.separator).replace("\\", File.separator)).substring(realPath.length() - 1, realPath.length()).equals(File.separator)) {
                    realPath = realPath + File.separator;
                }
                if ((str = str.replace("/", File.separator).replace("\\", File.separator)).substring(str.length() - 1, str.length()).equals(File.separator)) {
                    str = str.substring(0, realPath.length() - 1);
                }
                rpFile.getPaths().put(str, realPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemVersion() {
        String deployFile = InitPatchZipTool.getRuntimePath() + LegoResourceManager.getProValue("patch.software.name.version.file");
        String version = "";
        FileInputStream deploy = null;
        Properties properties = new Properties();
        try {
            deploy = new FileInputStream(deployFile);
            properties.load(deploy);
            version = properties.getProperty("version");
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"GetSystemVersion failed, can not find the legoDeploy.conf");
        }
        catch (IOException e) {
            LOGGER.error((Object)"Load FileInputStream failed.", (Throwable)e);
        }
        finally {
            if (deploy != null) {
                try {
                    deploy.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Close ioexception failed.", (Throwable)e);
                }
            }
        }
        return version;
    }

    public static String getRuntimePath() {
        if (installPath != null) {
            return installPath;
        }
        String fileName = "RDInstalled.xml";
        SAXReader sax = new SAXReader();
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                LOGGER.error((Object)("File is not exists. getRuntimePath failed." + file.getName()));
                throw new DocumentException("file is not exists. getRuntimePath failed." + file.getName());
            }
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(fileName));
            Element installElement = (Element)document.selectSingleNode("/install/installpath");
            String installPathStr = installElement.attribute("path").getValue();
            if (installPathStr != null) {
                boolean isSpLinux = installPathStr.endsWith("/");
                boolean isSpWindows = installPathStr.endsWith("\\");
                if (!isSpLinux && !isSpWindows) {
                    installPathStr = installPathStr + File.separator;
                }
                installPath = installPathStr;
            }
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)"GetRuntimePath error. ", e);
            PatchException ex = new PatchException("", e);
            ex.setErrorCode(20009L);
            throw ex;
        }
        return installPath;
    }

    public static PatchDto getBackupPatchPto() {
        String patchPath = InitPatchZipTool.getRuntimePath() + "Runtime" + File.separator + "patch";
        String backupOldPatchConfPath = patchPath + File.separator + "backup" + File.separator + "oldPatchConf";
        String patchxmlPath = backupOldPatchConfPath + File.separator + "patch.xml";
        File patchxmlFile = new File(patchxmlPath);
        if (!patchxmlFile.exists()) {
            return null;
        }
        PatchDto dto = InitPatchZipTool.getPatchInfoFromXml(patchxmlPath);
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPatchVersion(String packagePath, PatchDto dto) {
        String confFileName = packagePath + File.separator + PATCH_VERSION_CONF;
        LOGGER.info((Object)String.format(Locale.ENGLISH, "SetPatchVersion path is %s.", PATCH_VERSION_CONF));
        FileOutputStream fileOutput = null;
        File flagFile = null;
        try {
            flagFile = new File(confFileName);
            Boolean result = Boolean.FALSE;
            if (flagFile.exists()) {
                LOGGER.info((Object)"SetPatchVersion file is exist!");
                flagFile.setWritable(true);
                boolean flag = flagFile.delete();
                if (!flag) {
                    LOGGER.error((Object)"Delete error.");
                }
            }
            if ((result = Boolean.valueOf(flagFile.createNewFile())).booleanValue()) {
                fileOutput = new FileOutputStream(flagFile);
            }
            Properties pro = new Properties();
            pro.setProperty(PATCH_VERSION_KEY, dto.getPatchVersion());
            pro.store(fileOutput, "patch version");
        }
        catch (IOException e) {
            LOGGER.error((Object)"SetStartStatus error", (Throwable)e);
        }
        finally {
            if (fileOutput != null) {
                try {
                    fileOutput.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"SetStartStatus error", (Throwable)e);
                }
            }
        }
    }
}

