/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.ism.drm.wcc.util.WccHelper;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FilenameUtils;

public class AESEncryptor {
    private static final Log LOG = LogFactory.getInstance(AESEncryptor.class);
    private static final int INT_0XFF = 255;
    private static final int INT_0X10 = 16;
    private static final int KEYLEN = 128;
    private static final int IVLEN = 16;
    private static final int IREATOR = 50000;
    private static final int LEN = 1024;
    private static final String AES_CBC_MODE = "AES/CBC/PKCS5Padding";
    private static final String AES_GCM_MODE = "AES/GCM/PKCS5Padding";
    private Cipher cbcCipher;
    private Cipher gcmCipher;
    private IvParameterSpec dps;
    private GCMParameterSpec gcmSpec;
    private SecretKeySpec skeySpec;

    public AESEncryptor() throws NumberFormatException, PatchException, GeneralSecurityException {
        String sp = File.separator;
        String installPath = InitInstalledXmlTool.getInstallPath();
        String currPath = installPath.isEmpty() ? InstallConstant.getCurrentPath() : installPath;
        String appConfigFile = currPath + sp + "Runtime" + sp + "LegoRuntime" + sp + "conf" + sp + "lego.properties";
        Properties pro = new Properties();
        try (FileInputStream inputStream = new FileInputStream(appConfigFile);){
            pro.load(inputStream);
        }
        catch (IOException ex) {
            throw new PatchException("lego.properties Not Found.");
        }
        String passKeyStr = pro.getProperty("common.util.AESEncryptor", "");
        try {
            passKeyStr = WccHelper.getInstance().decrypt(passKeyStr);
        }
        catch (IOException ex) {
            throw new PatchException("Get common.util.AESEncryptor from lego.properties failed.");
        }
        byte[] passkey = this.hex2Bin(passKeyStr);
        byte[] key = this.getAESKey(passkey);
        byte[] iv = this.getAESIV(passkey);
        this.dps = new IvParameterSpec(iv);
        this.gcmSpec = new GCMParameterSpec(128, iv);
        this.skeySpec = new SecretKeySpec(key, "AES");
        this.cbcCipher = Cipher.getInstance(AES_CBC_MODE);
        this.gcmCipher = Cipher.getInstance(AES_GCM_MODE);
    }

    private byte[] getAESIV(byte[] keyRaw) {
        byte[] iv = new byte[16];
        System.arraycopy(keyRaw, 8, iv, 0, 16);
        return iv;
    }

    private byte[] getAESKey(byte[] keyRaw) {
        byte[] key = new byte[16];
        System.arraycopy(keyRaw, 0, key, 0, 8);
        System.arraycopy(keyRaw, 24, key, 8, 8);
        return key;
    }

    private String encrypt(String command) {
        try {
            this.gcmCipher.init(1, (Key)this.skeySpec, this.gcmSpec);
            byte[] buf = this.gcmCipher.doFinal(command.getBytes(StandardCharsets.UTF_8));
            return this.byte2hexString(buf);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException es) {
            throw new PatchException("", es);
        }
    }

    private String decrypt(String sSrc, boolean isDecryptByGCM) {
        byte[] bin = this.hex2Bin(sSrc);
        if (bin == null) {
            throw new PatchException("hex is null value");
        }
        try {
            if (isDecryptByGCM) {
                this.gcmCipher.init(2, (Key)this.skeySpec, this.gcmSpec);
                return new String(this.gcmCipher.doFinal(bin));
            }
            this.cbcCipher.init(2, (Key)this.skeySpec, this.dps);
            return new String(this.cbcCipher.doFinal(bin));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException eb) {
            throw new PatchException("", eb);
        }
    }

    private byte[] hex2Bin(String src) {
        if (src.length() < 1) {
            return null;
        }
        byte[] encrypted = new byte[src.length() / 2];
        for (int i = 0; i < src.length() / 2; ++i) {
            int high = Integer.parseInt(src.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(src.substring(i * 2 + 1, i * 2 + 2), 16);
            encrypted[i] = (byte)(high * 16 + low);
        }
        return encrypted;
    }

    private String byte2hexString(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append('0');
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
        }
        return strbuf.toString();
    }

    private static void writeSaltAndIV(String ivFile, String saltFile, String destPath, byte[] salt, byte[] iv) {
        FileOutputStream out1 = null;
        FileOutputStream out2 = null;
        try {
            out1 = new FileOutputStream(FilenameUtils.normalize((String)saltFile), false);
            ((OutputStream)out1).write(salt);
            out1.flush();
            out2 = new FileOutputStream(FilenameUtils.normalize((String)ivFile), false);
            ((OutputStream)out2).write(iv);
            out2.flush();
        }
        catch (IOException e) {
            try {
                LOG.error((Object)("WriteSaltAndIV failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("writeSaltAndIV failed.");
            }
            catch (Throwable throwable) {
                AESEncryptor.closeOutStream(out1, out2);
                throw throwable;
            }
        }
        AESEncryptor.closeOutStream(out1, out2);
    }

    private static void closeOutStream(OutputStream stream1, OutputStream stream2) {
        try {
            if (stream1 != null) {
                stream1.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Close error:", "");
        }
        try {
            if (stream2 != null) {
                stream2.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Close error:", "");
        }
    }

    private static Cipher initAESDecryptCipher(String sKey, byte[] salt, byte[] iv, boolean isDecryptByGCM) {
        Cipher cipher = null;
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec keyspec = new PBEKeySpec(sKey.toCharArray(), salt, 50000, 128);
            SecretKeySpec key = new SecretKeySpec(factory.generateSecret(keyspec).getEncoded(), "AES");
            if (isDecryptByGCM) {
                GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
                cipher = Cipher.getInstance(AES_GCM_MODE);
                cipher.init(2, (Key)key, gcmSpec);
            } else {
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher = Cipher.getInstance(AES_CBC_MODE);
                cipher.init(2, (Key)key, ivSpec);
            }
        }
        catch (Exception e) {
            LOG.error((Object)String.format(Locale.ROOT, "InvalidKeyException when initAESCipher! %s", ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return cipher;
    }

    private static Cipher initAESEncryptCipher(String ivFile, String saltFile, String destPath, String sKey) {
        Cipher cipher = null;
        try {
            SecureRandom saltRandom = SecureRandomFactory.getInstanceStrongWithDRBG();
            SecureRandom ivRandom = SecureRandomFactory.getInstanceStrongWithDRBG();
            byte[] salt = new byte[128];
            saltRandom.nextBytes(salt);
            byte[] iv = new byte[16];
            ivRandom.nextBytes(iv);
            AESEncryptor.writeSaltAndIV(ivFile, saltFile, destPath, salt, iv);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec keyspec = new PBEKeySpec(sKey.toCharArray(), salt, 50000, 128);
            SecretKeySpec key = new SecretKeySpec(factory.generateSecret(keyspec).getEncoded(), "AES");
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher = Cipher.getInstance(AES_GCM_MODE);
            cipher.init(1, (Key)key, gcmSpec);
        }
        catch (Exception e) {
            throw new PatchException("initAESCipher failed", e);
        }
        return cipher;
    }

    public static void encryptFile(String ivFile, String saltFile, File sourceFile, String destName, String sKey) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        CipherInputStream cipherInputStream = null;
        try {
            int nRead;
            inputStream = new FileInputStream(sourceFile);
            String outFile = sourceFile.getParent() + File.separator + destName;
            outputStream = new FileOutputStream(FilenameUtils.normalize((String)outFile));
            Cipher cipher = AESEncryptor.initAESEncryptCipher(ivFile, saltFile, sourceFile.getParent(), sKey);
            cipherInputStream = new CipherInputStream(inputStream, cipher);
            byte[] cache = new byte[1024];
            while ((nRead = cipherInputStream.read(cache)) != -1) {
                ((OutputStream)outputStream).write(cache, 0, nRead);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Encrypt file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new LegoCheckedException("encrypt file failed.");
            }
            catch (Throwable throwable) {
                AESEncryptor.doCloseStream(inputStream, outputStream, cipherInputStream);
                throw throwable;
            }
        }
        AESEncryptor.doCloseStream(inputStream, outputStream, cipherInputStream);
    }

    public static void decryptFile(String sourceFile, String destFile, String sKey, byte[] salt, byte[] iv) {
        Cipher gcmCipher = AESEncryptor.initAESDecryptCipher(sKey, salt, iv, true);
        AESEncryptor.getDecryptFile(sourceFile, destFile, gcmCipher);
        File file = new File(destFile);
        if (file.length() <= 0L) {
            Cipher cbcCipher = AESEncryptor.initAESDecryptCipher(sKey, salt, iv, false);
            AESEncryptor.getDecryptFile(sourceFile, destFile, cbcCipher);
        }
    }

    private static void getDecryptFile(String sourceFile, String destFile, Cipher cipher) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        CipherOutputStream cipherOutputStream = null;
        try {
            int r;
            File file = new File(destFile);
            if (!file.exists()) {
                LOG.info((Object)String.format(Locale.ROOT, "Create file result: %s", file.createNewFile()));
            }
            inputStream = new FileInputStream(sourceFile);
            outputStream = new FileOutputStream(file);
            cipherOutputStream = new CipherOutputStream(outputStream, cipher);
            byte[] buffer = new byte[1024];
            while ((r = ((InputStream)inputStream).read(buffer)) >= 0) {
                cipherOutputStream.write(buffer, 0, r);
            }
            cipherOutputStream.flush();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("IOException when decryptFile!" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("decryptFile failed.");
            }
            catch (Throwable throwable) {
                FileUtil.close(cipherOutputStream, "close ciphere");
                FileUtil.close(inputStream, "close input");
                FileUtil.close(outputStream, "close output");
                throw throwable;
            }
        }
        FileUtil.close(cipherOutputStream, "close ciphere");
        FileUtil.close(inputStream, "close input");
        FileUtil.close(outputStream, "close output");
    }

    private static void doCloseStream(InputStream inputStream, OutputStream outputStream, CipherInputStream cipherInputStream) {
        try {
            if (cipherInputStream != null) {
                cipherInputStream.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"CipherInputStream close error", "");
        }
        try {
            if (null != outputStream) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"EncryptFile close error.", "");
        }
        try {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"encryptFile close error.", "");
        }
    }

    public static String aes123encrypt(String user, String decryptCtxt) {
        String encryptCtxt;
        try {
            AESEncryptor aes = new AESEncryptor();
            encryptCtxt = user.length() == "".length() ? aes.encrypt(decryptCtxt) : aes.encrypt(user + decryptCtxt);
        }
        catch (Exception ex) {
            encryptCtxt = "";
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return encryptCtxt;
    }

    private static String aes123decrypt(String user, String encryptCtxt, boolean isDecryptByGCM) {
        String decryptCtxt = "";
        try {
            AESEncryptor aes = new AESEncryptor();
            String param = aes.decrypt(encryptCtxt, isDecryptByGCM);
            if (user.length() == "".length()) {
                decryptCtxt = param;
            } else {
                boolean isStartWithUser = param.startsWith(user);
                if (isStartWithUser) {
                    decryptCtxt = param.substring(user.length());
                }
            }
        }
        catch (Exception ex) {
            decryptCtxt = "";
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return decryptCtxt;
    }

    public static String encode(String rawData) {
        return AESEncryptor.aes123encrypt("", rawData);
    }

    public static String decode(String encryptedData) {
        String gcmTxt = AESEncryptor.aes123decrypt("", encryptedData, true);
        if (VerifyUtil.isEmpty((String)gcmTxt)) {
            return AESEncryptor.aes123decrypt("", encryptedData, false);
        }
        return gcmTxt;
    }
}

