/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.dto.InstallScript;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.ErrHandleTask;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.IOHandleTask;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.core.sdk.exception.LegoUncaughtExceptionHandler;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CmdUtil {
    private static final String ERRLOG = "logs/importDBErr.log";
    private static final String INFOLOG = "logs/importDBInput.log";
    private static final Log LOGGER = LogFactory.getInstance(CmdUtil.class);
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(2, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    public static void runInstallScript(InstallScript script) {
        File tmpFile;
        if (null == script) {
            LOGGER.info((Object)"Install System Script: null", "");
            return;
        }
        String scriptPath = script.getName();
        boolean absPath = script.isAbsolutePath();
        String[] params = script.getParams();
        if (!absPath) {
            scriptPath = InstallConstant.getsBasePath() + script.getName();
        }
        if (!(tmpFile = new File(scriptPath)).exists()) {
            LOGGER.error((Object)("the script is not exists: " + tmpFile.getName()), "");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(scriptPath);
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" ").append(param);
            }
        }
        try {
            CmdUtil.runShell(sb.toString());
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error((Object)"Install System Script Error:", (Throwable)e, "");
        }
    }

    public static void setLinuxWithoutRoot(String savaPath) throws IOException, InterruptedException {
        File tmpPath = new File(savaPath);
        if (!tmpPath.exists()) {
            throw new FileNotFoundException("setLinuxWithoutRoot failed.");
        }
        String serverUser = "ICUser";
        String serverUserGroup = "lego";
        String webUser = "ICUser";
        if (CmdUtil.isConfigExits().booleanValue()) {
            serverUser = LegoResourceManager.getProValue("custom.user.name");
            serverUserGroup = LegoResourceManager.getProValue("custom.user.group");
            webUser = LegoResourceManager.getProValue("tomcat.user.name");
        }
        if (!(ParamCheck.checkUserName(serverUser) && ParamCheck.checkUserName(serverUserGroup) && ParamCheck.checkUserName(webUser))) {
            throw new IOException("get system user from startinfo.properties failed.");
        }
        CmdUtil.buildAndRunCmd(savaPath, serverUser, serverUserGroup, webUser);
    }

    private static void buildAndRunCmd(String savaPath, String serverUser, String serverUserGroup, String webUser) throws IOException, InterruptedException {
        String legoRuntimePath;
        String tomcatPath;
        String jrePath;
        String path;
        ArrayList<String> lists = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(savaPath.replace("\\/", "/").replace(" ", "\" \""));
        if (savaPath.endsWith("/")) {
            path = sb + LegoResourceManager.getProValue("install.lego_version.platform.runtime");
            jrePath = sb + LegoResourceManager.getProValue("install.java.name");
            tomcatPath = sb + LegoResourceManager.getProValue("install.lego_version.frontend.war");
            legoRuntimePath = sb + "Runtime/LegoRuntime";
            CmdUtil.checkPath(path, jrePath, tomcatPath);
            lists.add("chmod 700 -R " + path + "/");
            lists.add("chown -Rh " + serverUser + ":" + serverUserGroup + " " + path);
            lists.add("chmod 750 " + savaPath);
            lists.add("chown -h  " + serverUser + ":" + serverUserGroup + " " + savaPath);
            lists.add("chmod 750 " + legoRuntimePath);
            lists.add("chmod 750 " + path + "/");
            lists.add("chmod 750 -R " + jrePath);
            lists.add("chmod 750 -R " + tomcatPath);
            lists.add("chown -Rh " + webUser + ":" + serverUserGroup + " " + tomcatPath);
        } else {
            path = sb + "/" + LegoResourceManager.getProValue("install.lego_version.platform.runtime");
            jrePath = sb + "/" + LegoResourceManager.getProValue("install.java.name");
            tomcatPath = sb + "/" + LegoResourceManager.getProValue("install.lego_version.frontend.war");
            legoRuntimePath = sb + "/Runtime/LegoRuntime";
            CmdUtil.checkPath(path, jrePath, tomcatPath);
            lists.add("chmod 700 -R " + path + "/");
            lists.add("chown -Rh " + serverUser + ":" + serverUserGroup + " " + path);
            lists.add("chmod 750 " + savaPath);
            lists.add("chmod 750 " + legoRuntimePath);
            lists.add("chown -h " + serverUser + ":" + serverUserGroup + " " + savaPath);
            lists.add("chmod 750 " + path + "/");
            lists.add("chmod 750 -R " + jrePath);
            lists.add("chmod 750 -R " + tomcatPath);
            lists.add("chown -Rh " + webUser + ":" + serverUserGroup + " " + tomcatPath);
        }
        for (String cmd : lists) {
            CmdUtil.runShell(cmd);
        }
    }

    private static void checkPath(String path, String jrePath, String tomcatPath) throws IOException {
        if (!(ParamCheck.checkValidConfig(path) && ParamCheck.checkValidConfig(jrePath) && ParamCheck.checkValidConfig(tomcatPath))) {
            throw new IOException("Get path failed.");
        }
    }

    private static Boolean isConfigExits() {
        String deployFile = InstallConstant.getsBasePath() + LegoResourceManager.getProValue("start.user.info.file");
        File file = new File(deployFile);
        if (file.exists()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void runShell(String shPath, String[] params) throws IOException, InterruptedException {
        File file = new File(shPath);
        if (!file.exists()) {
            throw new FileNotFoundException("can not find the script: " + file.getName());
        }
        StringBuilder sb = new StringBuilder("sh ");
        sb.append(shPath.replace("\\/", "/").replace(" ", "\" \""));
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" ").append(param);
            }
        }
        CmdUtil.runShell(sb.toString());
    }

    public static boolean runShell(String shPath, String[] params, String result) {
        File file = new File(shPath);
        if (!file.exists()) {
            LOGGER.error((Object)("runShell failed, file is not exists: " + file.getName()), "");
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(shPath.replace("\\/", "/").replace(" ", "\" \""));
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" ").append(param);
            }
        }
        return CmdUtil.runShell(sb.toString(), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runShell(String shStr) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(shStr);
        InputStreamReader ir = null;
        LineNumberReader input = null;
        try {
            String line;
            ir = new InputStreamReader(process.getInputStream());
            input = new LineNumberReader(ir);
            while ((line = FileUtil.getLineFromFile(input)) != null) {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Linux shell output: %s.", line), "");
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error((Object)"run shell error :", e.getMessage());
            }
            catch (Throwable throwable) {
                CmdUtil.closeRealble(ir);
                CmdUtil.closeRealble(input);
                throw throwable;
            }
            CmdUtil.closeRealble(ir);
            CmdUtil.closeRealble(input);
        }
        CmdUtil.closeRealble(ir);
        CmdUtil.closeRealble(input);
        try (BufferedReader errBr = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
            IOHandleTask errTask = new IOHandleTask(errBr);
            EXECUTOR_SERVICE.execute(errTask);
            Integer waitFor = process.waitFor();
            LOGGER.info((Object)waitFor, "");
        }
        catch (IOException e) {
            LOGGER.error((Object)"Execute cmd failed.", ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runSysoShell(String shStr) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(shStr);
        InputStreamReader ir = null;
        LineNumberReader input = null;
        InputStreamReader er = null;
        LineNumberReader err = null;
        try {
            ir = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
            input = new LineNumberReader(ir);
            er = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
            err = new LineNumberReader(er);
            Runnable inputTask = CmdUtil.createInputConsumer(input);
            IOHandleTask errTask = new IOHandleTask(err);
            EXECUTOR_SERVICE.execute(inputTask);
            EXECUTOR_SERVICE.execute(errTask);
        }
        catch (Throwable throwable) {
            CmdUtil.closeRealble(ir);
            CmdUtil.closeRealble(input);
            CmdUtil.closeRealble(er);
            CmdUtil.closeRealble(err);
            throw throwable;
        }
        CmdUtil.closeRealble(ir);
        CmdUtil.closeRealble(input);
        CmdUtil.closeRealble(er);
        CmdUtil.closeRealble(err);
        Integer waitFor = process.waitFor();
        LOGGER.info((Object)waitFor, "");
    }

    private static Runnable createInputConsumer(BufferedReader reader) {
        return () -> {
            try {
                String line;
                while ((line = FileUtil.getLineFromFile(reader)) != null) {
                    SystemPrint.systemPrintStr(line);
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"Handle InputStream Error.", ExceptionUtil.getErrorMessage((Throwable)e));
            }
        };
    }

    public static boolean execStrCmd(String cmd) {
        return CmdUtil.execStrCmd(cmd, new String[0]);
    }

    public static boolean execStrCmd(String cmd, String[] params) {
        InputStreamReader input = null;
        BufferedReader inputBr = null;
        InputStreamReader err = null;
        BufferedReader errBr = null;
        BufferedWriter outputBW = null;
        boolean isSuccess = false;
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            outputBW = new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8));
            for (String param : params) {
                outputBW.write(param);
                outputBW.newLine();
            }
            outputBW.flush();
            input = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
            inputBr = new BufferedReader(input);
            ErrHandleTask inputTask = new ErrHandleTask(inputBr, INFOLOG);
            err = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
            errBr = new BufferedReader(err);
            ErrHandleTask errTask = new ErrHandleTask(errBr, ERRLOG);
            Thread inputT = new Thread((Runnable)inputTask, "ExecStrCmdInputTask");
            Thread errT = new Thread((Runnable)errTask, "ExecStrCmdErrorTask");
            inputT.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LegoUncaughtExceptionHandler.getInstance());
            errT.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LegoUncaughtExceptionHandler.getInstance());
            inputT.start();
            errT.start();
            int result = process.waitFor();
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Check result: %s.", result), "");
            if (result == 0) {
                isSuccess = true;
            }
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)("exec failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("exec cmd failed");
            }
            catch (Throwable throwable) {
                CmdUtil.closeRealble(outputBW);
                CmdUtil.closeRealble(input);
                CmdUtil.closeRealble(inputBr);
                CmdUtil.closeRealble(err);
                CmdUtil.closeRealble(errBr);
                throw throwable;
            }
        }
        CmdUtil.closeRealble(outputBW);
        CmdUtil.closeRealble(input);
        CmdUtil.closeRealble(inputBr);
        CmdUtil.closeRealble(err);
        CmdUtil.closeRealble(errBr);
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execShellCmd(String cmd) {
        boolean isSuccess;
        InputStreamReader ir;
        LineNumberReader input;
        block8: {
            Process ps = null;
            input = null;
            ir = null;
            isSuccess = false;
            try {
                String line;
                ps = Runtime.getRuntime().exec(cmd);
                ir = new InputStreamReader(ps.getInputStream());
                input = new LineNumberReader(ir);
                while ((line = FileUtil.getLineFromFile(input)) != null) {
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "Line: %s.", line), "");
                }
                while ((line = FileUtil.getLineFromFile(new LineNumberReader(new InputStreamReader(ps.getErrorStream())))) != null) {
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "Error: %s.", line), "");
                }
                int result = ps.waitFor();
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Check result: %s", result), "");
                if (result == 0) {
                    isSuccess = true;
                }
                if (null == ps) break block8;
                ps.destroy();
            }
            catch (Exception e) {
                block9: {
                    try {
                        LOGGER.error((Object)"exec failed", ExceptionUtil.getErrorMessage((Throwable)e));
                        if (null == ps) break block9;
                        ps.destroy();
                    }
                    catch (Throwable throwable) {
                        if (null != ps) {
                            ps.destroy();
                        }
                        CmdUtil.closeRealble(ir);
                        CmdUtil.closeRealble(input);
                        throw throwable;
                    }
                }
                CmdUtil.closeRealble(ir);
                CmdUtil.closeRealble(input);
            }
        }
        CmdUtil.closeRealble(ir);
        CmdUtil.closeRealble(input);
        return isSuccess;
    }

    public static boolean execShellCmd(String cmd, String[] param) {
        StringBuffer buff = new StringBuffer();
        buff.append(cmd);
        if (null != param) {
            for (String par : param) {
                buff.append(" " + par);
            }
        }
        return CmdUtil.execShellCmd(buff.toString());
    }

    /*
     * Loose catch block
     */
    private static boolean runShell(String shStr, String result) {
        boolean ret = false;
        Process process = null;
        LineNumberReader input = null;
        InputStreamReader ir = null;
        LineNumberReader err = null;
        InputStreamReader er = null;
        try {
            process = Runtime.getRuntime().exec(shStr);
            ir = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
            input = new LineNumberReader(ir);
            er = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
            err = new LineNumberReader(er);
            FutureTask<Boolean> inputFutureTask = CmdUtil.createInputFutureTask(input, result);
            IOHandleTask errTask = new IOHandleTask(err);
            EXECUTOR_SERVICE.submit(inputFutureTask);
            EXECUTOR_SERVICE.execute(errTask);
            ret = inputFutureTask.get(60L, TimeUnit.SECONDS);
            try {
                Integer waitFor = process.waitFor();
                LOGGER.info((Object)waitFor, "");
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"runshell waitFor exception:", (Throwable)e, "");
            }
        }
        catch (IOException | InterruptedException | ExecutionException ioe) {
            LOGGER.error((Object)"runshell waitFor ioexception:", (Throwable)ioe, "");
            CmdUtil.closeRealble(input);
            CmdUtil.closeRealble(ir);
            CmdUtil.closeRealble(err);
            CmdUtil.closeRealble(er);
            if (null != process) {
                process.destroy();
            }
        }
        catch (TimeoutException e) {
            LOGGER.error((Object)"Exec cmd TimeOut Exception:", (Throwable)e, "");
            throw new PatchException("Exec cmd failed");
            {
                catch (Throwable throwable) {
                    CmdUtil.closeRealble(input);
                    CmdUtil.closeRealble(ir);
                    CmdUtil.closeRealble(err);
                    CmdUtil.closeRealble(er);
                    if (null != process) {
                        process.destroy();
                    }
                    throw throwable;
                }
            }
        }
        CmdUtil.closeRealble(input);
        CmdUtil.closeRealble(ir);
        CmdUtil.closeRealble(err);
        CmdUtil.closeRealble(er);
        if (null != process) {
            process.destroy();
        }
        return ret;
    }

    private static FutureTask<Boolean> createInputFutureTask(BufferedReader reader, String result) {
        return new FutureTask<Boolean>(() -> {
            String line;
            boolean ret = false;
            while ((line = FileUtil.getLineFromFile(reader)) != null) {
                if (line.contains(result)) {
                    ret = true;
                }
                LOGGER.info((Object)line, "");
            }
            return ret;
        });
    }

    private static void closeRealble(Closeable cls) {
        if (null != cls) {
            try {
                cls.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e, "close error.");
            }
        }
    }
}

