/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;

public final class ConsoleUtil {
    private static final Log LOG = LogFactory.getInstance(ConsoleUtil.class);

    private ConsoleUtil() {
    }

    public static boolean redirected() {
        return System.console() == null;
    }

    public static String readLine(String fmt, Object ... args) {
        return ConsoleUtil.readLine(false, fmt, args);
    }

    public static String readPassword(String fmt, Object ... args) {
        return ConsoleUtil.readLine(true, fmt, args);
    }

    private static String readLine(boolean password, String fmt, Object ... args) {
        String prompt = fmt != null ? String.format(Locale.ROOT, fmt, args) : "";
        Console console = System.console();
        if (console != null) {
            if (password) {
                return new String(console.readPassword(prompt, new Object[0]));
            }
            return console.readLine(prompt, new Object[0]);
        }
        if (prompt.length() > 0) {
            SystemPrint.systemPrintStr(prompt);
        }
        return ConsoleUtil.readLine(password);
    }

    private static String readLine(boolean password) {
        String line;
        try {
            line = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException e) {
            LOG.error((Object)e, "Read line from stdin failed");
            line = "";
        }
        if (!password) {
            LOG.info((Object)String.format(Locale.ROOT, "Line:%s", line));
        }
        return line;
    }
}

