/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.util.CommonUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;

public class FileUtil {
    private static final Log LOG = LogFactory.getInstance(FileUtil.class);
    private static final int MAX_LEN = 0xFFFFFFE;
    private static final int INDEX = 1;
    private static final int BYTE_READ_SIZE = 10240;

    private static void copyFolderFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int len;
            byte[] b = new byte[2048];
            while ((len = inputStream.read(b)) != -1) {
                outputStream.write(b, 0, len);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"CopyFolderFile has error", (Throwable)e, "");
            throw e;
        }
    }

    public static void copyFolderToPatch(String oldPath, String newPath) throws IOException {
        File temp = null;
        try {
            File oldFilePath = new File(oldPath);
            if (!oldFilePath.exists()) {
                LOG.error((Object)("Old Path is not exists: " + oldFilePath.getName()), "");
                return;
            }
            boolean flag = new File(newPath).mkdirs();
            if (!flag) {
                LOG.error((Object)"Mkdirs exists!", "");
            }
            String[] files = oldFilePath.list();
            FileInputStream inputStream = null;
            FileOutputStream outputStream = null;
            for (int i = 0; i < files.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + files[i]) : new File(oldPath + File.separator + files[i]);
                if (temp.isFile()) {
                    try {
                        inputStream = new FileInputStream(temp);
                        outputStream = new FileOutputStream(newPath + File.separator + temp.getName());
                        FileUtil.copyFolderFile(inputStream, outputStream);
                        outputStream.flush();
                    }
                    catch (IOException e) {
                        try {
                            LOG.info((Object)"Copy  File Exception is:", e.getMessage());
                            throw e;
                        }
                        catch (Throwable throwable) {
                            FileUtil.releaseStream(outputStream);
                            FileUtil.releaseStream(inputStream);
                            throw throwable;
                        }
                    }
                    FileUtil.releaseStream(outputStream);
                    FileUtil.releaseStream(inputStream);
                }
                if (!temp.isDirectory()) continue;
                FileUtil.copyFolderToPatch(oldPath + File.separator + files[i], newPath);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("File " + temp.getName() + "has error"), (Throwable)e, "");
            throw e;
        }
    }

    public static void copyFolder(String oldPath, String newPath) throws IOException {
        File temp = null;
        try {
            File oldFilePath = new File(oldPath);
            if (!oldFilePath.exists()) {
                LOG.error((Object)("Old Path is not exists: " + oldFilePath.getName()), "");
                return;
            }
            boolean flag = new File(newPath).mkdirs();
            if (!flag) {
                LOG.error((Object)"Mkdirs exists!", "");
            }
            String[] files = oldFilePath.list();
            FileInputStream inputStream = null;
            FileOutputStream outputStream = null;
            for (int i = 0; i < files.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + files[i]) : new File(oldPath + File.separator + files[i]);
                if (temp.isFile()) {
                    try {
                        inputStream = new FileInputStream(temp);
                        outputStream = new FileOutputStream(newPath + File.separator + temp.getName());
                        FileUtil.copyFolderFile(inputStream, outputStream);
                        outputStream.flush();
                    }
                    catch (IOException e) {
                        try {
                            LOG.info((Object)"Copy  File Exception is:", e.getMessage());
                            throw e;
                        }
                        catch (Throwable throwable) {
                            FileUtil.releaseStream(outputStream);
                            FileUtil.releaseStream(inputStream);
                            throw throwable;
                        }
                    }
                    FileUtil.releaseStream(outputStream);
                    FileUtil.releaseStream(inputStream);
                }
                if (!temp.isDirectory()) continue;
                FileUtil.copyFolder(oldPath + File.separator + files[i], newPath + File.separator + files[i]);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("File " + temp.getName() + "has error"), (Throwable)e, "");
            throw e;
        }
    }

    public static boolean reNameFile(String src, String dest) {
        boolean status = false;
        File destFile = new File(dest);
        File srcFile = new File(src);
        if (!destFile.exists() && srcFile.exists() && srcFile.renameTo(destFile)) {
            status = true;
        }
        return status;
    }

    public static void copyFile(String src, String dest) throws IOException {
        FileOutputStream outputStream;
        FileInputStream inputStream;
        block6: {
            inputStream = null;
            outputStream = null;
            File oldfile = new File(FilenameUtils.normalize((String)src.trim()));
            try {
                int byteread = 0;
                if (oldfile.exists()) {
                    oldfile.setWritable(true);
                    inputStream = new FileInputStream(oldfile.getCanonicalPath());
                    outputStream = new FileOutputStream(new File(FilenameUtils.normalize((String)dest)).getCanonicalPath());
                    byte[] buffer = new byte[2048];
                    while ((byteread = ((InputStream)inputStream).read(buffer)) != -1) {
                        ((OutputStream)outputStream).write(buffer, 0, byteread);
                    }
                    break block6;
                }
                LOG.info((Object)String.format(Locale.ROOT, "Copy File But File is not exists:%s", oldfile.getName()), "0x000252000FB50018");
            }
            catch (IOException e) {
                try {
                    LOG.error((Object)String.format(Locale.ROOT, "CopyFile error, fileName=%s, error:%s", oldfile.getName(), ExceptionUtil.getErrorMessage((Throwable)e)));
                    throw e;
                }
                catch (Throwable throwable) {
                    FileUtil.releaseStream(outputStream);
                    FileUtil.releaseStream(inputStream);
                    throw throwable;
                }
            }
        }
        FileUtil.releaseStream(outputStream);
        FileUtil.releaseStream(inputStream);
    }

    private static void releaseStream(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                LOG.error((Object)"Release Stream is Error:", e.getMessage());
            }
        }
    }

    public static void modifyDBPropFileUsingPro(String fileName, String[] keys, String[] values) throws IOException {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        Properties prop = new Properties();
        try {
            boolean createFlag;
            File file = new File(fileName);
            if (!file.exists() && !(createFlag = file.createNewFile())) {
                LOG.error((Object)"CreateNewFile error!", "");
            }
            inputStream = new FileInputStream(file);
            prop.load(inputStream);
        }
        catch (IOException e) {
            try {
                LOG.error((Object)e, "CreateNewFile IO error");
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(inputStream);
                throw throwable;
            }
        }
        FileUtil.releaseStream(inputStream);
        try {
            outputStream = new FileOutputStream(fileName);
            for (int i = 0; i < keys.length; ++i) {
                prop.setProperty(keys[i], values[i]);
            }
            prop.store(outputStream, "Update DB value");
        }
        catch (IOException e) {
            try {
                LOG.error((Object)e, "Update db IO error");
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(outputStream);
                throw throwable;
            }
        }
        FileUtil.releaseStream(outputStream);
    }

    public static void modifyDBPropFileUsingStr(String file, String[] keys, String[] values, String targetFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        FileReader fr = null;
        FileWriter writer = null;
        try {
            File tmpFile = new File(file);
            if (!tmpFile.exists()) {
                LOG.error((Object)("The file is not exists: " + tmpFile.getName()), "");
                throw new FileNotFoundException();
            }
            fr = new FileReader(file);
            reader = new BufferedReader(fr);
            String text = null;
            while ((text = FileUtil.getLineFromFile(reader)) != null) {
                for (int i = 0; i < keys.length; ++i) {
                    if (!text.startsWith(keys[i])) continue;
                    text = keys[i] + "=" + values[i];
                }
                sb.append(text);
                sb.append(System.getProperty("line.separator"));
            }
            writer = new FileWriter(targetFile);
            writer.write(sb.toString());
            writer.flush();
        }
        catch (IOException e) {
            try {
                LOG.error((Object)e, "ModifyDBPropFileUsingStr IO Error");
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(writer);
                FileUtil.releaseStream(reader);
                FileUtil.releaseStream(fr);
                throw throwable;
            }
        }
        FileUtil.releaseStream(writer);
        FileUtil.releaseStream(reader);
        FileUtil.releaseStream(fr);
    }

    public static void modifyDBPropFileUsingStr(String file, Map<String, String> data, String targetFile) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        BufferedWriter writer = null;
        OutputStreamWriter output = null;
        InputStreamReader input = null;
        FileOutputStream outpuStream = null;
        FileInputStream inputStream = null;
        try {
            File tmpFile = new File(file);
            if (!tmpFile.exists()) {
                LOG.error((Object)("The file is not exists: " + tmpFile.getName()), "");
                throw new FileNotFoundException();
            }
            inputStream = new FileInputStream(file);
            input = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
            reader = new BufferedReader(input);
            String text = null;
            while ((text = FileUtil.getLineFromFile(reader)) != null) {
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    if (!text.startsWith(entry.getKey())) continue;
                    String value = entry.getValue();
                    if (text.contains(":") && text.contains("=")) {
                        int start = text.indexOf("=");
                        int end = text.lastIndexOf(":");
                        value = text.substring(start + 1, end) + ":" + entry.getValue();
                    }
                    text = entry.getKey() + "=" + value;
                }
                sb.append(text);
                sb.append(System.getProperty("line.separator"));
            }
            outpuStream = new FileOutputStream(targetFile);
            output = new OutputStreamWriter((OutputStream)outpuStream, StandardCharsets.UTF_8);
            writer = new BufferedWriter(output);
            writer.write(sb.toString());
            writer.flush();
        }
        catch (IOException e) {
            try {
                LOG.error((Object)e, "ModifyDBPropFileUsingStr IO Error");
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(reader);
                FileUtil.releaseStream(input);
                FileUtil.releaseStream(inputStream);
                FileUtil.releaseStream(writer);
                FileUtil.releaseStream(output);
                FileUtil.releaseStream(outpuStream);
                throw throwable;
            }
        }
        FileUtil.releaseStream(reader);
        FileUtil.releaseStream(input);
        FileUtil.releaseStream(inputStream);
        FileUtil.releaseStream(writer);
        FileUtil.releaseStream(output);
        FileUtil.releaseStream(outpuStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void combineFile(String file, String target) throws IOException {
        BufferedReader oldBufferedReader = null;
        BufferedReader targetBufferrdReader = null;
        FileWriter fileWriter = null;
        StringBuilder sb = new StringBuilder();
        FileReader oldFileReader = null;
        FileReader targetFileReader = null;
        try {
            oldFileReader = new FileReader(file);
            oldBufferedReader = new BufferedReader(oldFileReader);
            targetFileReader = new FileReader(target);
            targetBufferrdReader = new BufferedReader(targetFileReader);
            String text = null;
            while ((text = FileUtil.getLineFromFile(targetBufferrdReader)) != null) {
                sb.append(text);
                sb.append(System.getProperty("line.separator"));
            }
            while ((text = FileUtil.getLineFromFile(oldBufferedReader)) != null) {
                String oldString = sb.toString();
                if (oldString.contains(text)) continue;
                sb.append(text);
                sb.append(System.getProperty("line.separator"));
            }
            fileWriter = new FileWriter(target);
            fileWriter.write(sb.toString());
            fileWriter.flush();
        }
        catch (FileNotFoundException e) {
            try {
                LOG.error((Object)"combineFile IO error, file not founed.", "");
                throw new FileNotFoundException("combineFile failed.");
                catch (IOException e2) {
                    LOG.error((Object)e2, "CombineFile IO error");
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                FileUtil.releaseStream(fileWriter);
                FileUtil.releaseStream(targetBufferrdReader);
                FileUtil.releaseStream(oldBufferedReader);
                FileUtil.releaseStream(oldFileReader);
                FileUtil.releaseStream(targetFileReader);
                throw throwable;
            }
        }
        FileUtil.releaseStream(fileWriter);
        FileUtil.releaseStream(targetBufferrdReader);
        FileUtil.releaseStream(oldBufferedReader);
        FileUtil.releaseStream(oldFileReader);
        FileUtil.releaseStream(targetFileReader);
    }

    public static void deleteAllFolder(File file) {
        file.setWritable(true);
        if (file.exists()) {
            if (file.isFile()) {
                boolean flag = file.delete();
                if (!flag) {
                    LOG.error((Object)"Delete error!", "");
                }
            } else if (file.isDirectory()) {
                File[] files;
                for (File value : files = file.listFiles()) {
                    FileUtil.deleteAllFolder(value);
                }
            }
        }
        file.delete();
    }

    public static void deleteAllFilesInFolder(File file) throws IOException {
        file.setWritable(true);
        if (file.exists()) {
            if (file.isFile()) {
                return;
            }
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteAllFolder(files[i]);
                }
            }
        }
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.setWritable(true);
            boolean flag = file.delete();
            if (!flag) {
                LOG.error((Object)"Delete file Error", "");
            }
        }
    }

    public static void delScript4Installed(String folderPath, String delFileValue, String dbType) {
        String[] delFiles = FileUtil.getDelFileNames(delFileValue);
        if (null != delFiles && delFiles.length > 0) {
            for (String delFileName : delFiles) {
                File file = new File(folderPath + File.separator + delFileName);
                if (!file.exists()) continue;
                if (file.isDirectory() && file.getName().equals("script")) {
                    FileUtil.delDBScript(file, dbType);
                    continue;
                }
                FileUtil.deleteAllFolder(file);
            }
        }
    }

    private static String[] getDelFileNames(String delFileValuedelFileValue) {
        String delFileNames = LegoResourceManager.getProValue(delFileValuedelFileValue);
        if (delFileNames != null && delFileNames.length() > 0) {
            return delFileNames.split(";");
        }
        return new String[0];
    }

    private static void delDBScriptUninstall(File file, String dbtype) {
        for (File folder : file.listFiles()) {
            if (!folder.getName().equalsIgnoreCase("uninstall") && folder.isDirectory()) {
                FileUtil.deleteAllFolder(folder);
            }
            if (!FileUtil.extracted(folder)) continue;
            FileUtil.delDBScript(folder, dbtype);
        }
    }

    public static void delDBScript(File delFile, String dbtype) {
        block6: {
            File file = delFile;
            if (!file.exists() || !file.isDirectory()) break block6;
            List<String> fileNames = Arrays.asList(file.list());
            if (fileNames.contains(dbtype.toLowerCase(Locale.US))) {
                for (File folder : file.listFiles()) {
                    if (dbtype.equalsIgnoreCase(folder.getName()) || !folder.isDirectory()) continue;
                    FileUtil.deleteAllFolder(folder);
                }
            } else if (fileNames.contains("uninstall")) {
                FileUtil.delDBScriptUninstall(file, dbtype);
            } else {
                for (File folder : file.listFiles()) {
                    FileUtil.delDBScript(folder, dbtype);
                }
            }
        }
    }

    private static boolean extracted(File folder) {
        return folder.getName().equalsIgnoreCase("uninstall") && folder.isDirectory();
    }

    public static String getLineFromFile(LineNumberReader bufReader) throws IOException {
        StringBuffer strBuf = new StringBuffer();
        try {
            int tempChar;
            while ((tempChar = bufReader.read()) != -1) {
                if (strBuf.length() >= 0xFFFFFFE) {
                    throw new IOException("input too long");
                }
                if ((char)tempChar != '\n' && (char)tempChar != '\r') {
                    strBuf.append((char)tempChar);
                    continue;
                }
                return strBuf.toString();
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        if (strBuf.length() > 0) {
            return strBuf.toString();
        }
        return null;
    }

    public static String getLineFromFile(BufferedReader bufReader) throws IOException {
        StringBuffer strBuf = new StringBuffer();
        try {
            int tempChar;
            while ((tempChar = bufReader.read()) != -1) {
                if (strBuf.length() >= 0xFFFFFFE) {
                    throw new IOException("input too long");
                }
                if (tempChar == 13) {
                    tempChar = bufReader.read();
                    if (tempChar == 10) {
                        return strBuf.toString();
                    }
                    strBuf.append('\r');
                }
                if ((char)tempChar != '\n' && (char)tempChar != '\r') {
                    strBuf.append((char)tempChar);
                    continue;
                }
                return strBuf.toString();
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        if (strBuf.length() > 0) {
            return strBuf.toString();
        }
        return null;
    }

    public static String join(String ... pathes) {
        StringBuilder builder = null;
        for (String path : pathes) {
            if (builder != null) {
                builder.append(File.separatorChar).append(path);
                continue;
            }
            builder = new StringBuilder(path);
        }
        return builder != null ? builder.toString() : null;
    }

    public static void close(Closeable closeable, String message) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOG.error((Object)("Close closeable failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    public static void writeFile(String destFile, String message) {
        if (message.length() > 5000) {
            LOG.info((Object)String.format(Locale.ROOT, "Message length is too long, more than %s", 5000));
            throw new PatchException("writeFile failed.");
        }
        File file = new File(FilenameUtils.normalize((String)destFile));
        if (file.exists()) {
            LOG.info((Object)String.format(Locale.ROOT, "Delete tmpfile: %s", file.delete()));
        }
        FileWriter write = null;
        try {
            write = new FileWriter(file);
            write.write(message);
            write.flush();
        }
        catch (IOException e) {
            LOG.error((Object)("Write config file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("write HA config failed.");
        }
        finally {
            if (null != write) {
                try {
                    write.close();
                }
                catch (IOException e2) {
                    LOG.error((Object)("Close writer failed: " + e2), "");
                }
            }
        }
    }

    public static File zipFile(File souceFile) {
        File file;
        ZipOutputStream out = null;
        FileInputStream in = null;
        try {
            int length;
            String dir = souceFile.getParent();
            String name = souceFile.getName().replace(".sql", "");
            String zipFile = dir + File.separator + name + ".zip";
            out = new ZipOutputStream(new FileOutputStream(zipFile));
            out.putNextEntry(new ZipEntry(souceFile.getName()));
            in = new FileInputStream(souceFile);
            byte[] by = new byte[10240];
            while ((length = in.read(by)) != -1) {
                out.write(by, 0, length);
            }
            out.flush();
            file = new File(zipFile);
        }
        catch (Exception e) {
            try {
                LOG.error((Object)("Zip file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("zipFile failed.");
            }
            catch (Throwable throwable) {
                FileUtil.doCloseStream(out, in);
                throw throwable;
            }
        }
        FileUtil.doCloseStream(out, in);
        return file;
    }

    private static void doCloseStream(ZipOutputStream out, FileInputStream in) {
        try {
            if (null != out) {
                out.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"ZipFile close out error", "");
        }
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"ZipFile close in error", "");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzipFile(String srcFile, String outPath) {
        long totalFileCount = 0L;
        long totalFileSize = 0L;
        File file = new File(outPath);
        if (!file.exists() || !file.isDirectory()) {
            LOG.info((Object)String.format(Locale.ROOT, "OutPath not exists, create result: %s", file.mkdirs()));
        }
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(srcFile));
             BufferedInputStream bin = new BufferedInputStream(zin);){
            ZipEntry entry;
            while (null != (entry = zin.getNextEntry()) && !entry.isDirectory()) {
                BufferedOutputStream bout = null;
                FileOutputStream out = null;
                try {
                    int bytesRead;
                    String entryFilePath = CommonUtil.sanitizeFileName((String)outPath, (String)entry.getName());
                    File fout = new File(entryFilePath);
                    if (!fout.exists()) {
                        new File(fout.getParent()).mkdirs();
                    }
                    CommonUtil.zipFileNumCheck((long)(++totalFileCount));
                    out = new FileOutputStream(fout);
                    bout = new BufferedOutputStream(out);
                    byte[] buf = new byte[10240];
                    while ((bytesRead = bin.read(buf)) != -1) {
                        CommonUtil.zipBombCheck((long)(totalFileSize += (long)bytesRead));
                        bout.write(buf, 0, bytesRead);
                    }
                    bout.flush();
                }
                catch (Exception e) {
                    try {
                        LOG.error((Object)("Unzip failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                        throw new PatchException("");
                    }
                    catch (Throwable throwable) {
                        FileUtil.close(out, "close out");
                        FileUtil.close(bout, "close bout");
                        throw throwable;
                        return;
                    }
                }
                FileUtil.close(out, "close out");
                FileUtil.close(bout, "close bout");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Unzip file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("unzip file failed.");
        }
    }

    public static void zipFile(List<String> fileList, String zipPath, String zipFile, boolean isRecursion) {
        if (VerifyUtil.isEmpty((String)zipPath) || VerifyUtil.isEmpty((String)zipFile)) {
            LOG.error((Object)"ZipFile failed, zip path or file is empty.", "");
            throw new PatchException("zipFile failed.");
        }
        ZipOutputStream zip = null;
        File file = new File(FilenameUtils.normalize((String)zipFile));
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            zip = new ZipOutputStream(new FileOutputStream(file));
            File srcFile = new File(zipPath);
            String base = "";
            FileUtil.fileZip(fileList, srcFile, zip, base, isRecursion);
        }
        catch (IOException e) {
            LOG.error((Object)("ZipOutPutFile failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("zipOutPutFile failed.");
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)e, "Close stream failed.");
            }
        }
    }

    private static void fileZip(List<String> fileList, File srcFile, ZipOutputStream zos, String base, boolean isRecursion) {
        FileInputStream fis;
        block9: {
            fis = null;
            try {
                int n;
                if (srcFile.isDirectory()) {
                    File[] files;
                    if (isRecursion) {
                        base = base.length() == 0 ? "" : base + "/";
                    }
                    for (File file : files = srcFile.listFiles()) {
                        if (null != fileList && !fileList.isEmpty() && fileList.contains(file.getName())) {
                            FileUtil.fileZip(fileList, file, zos, base + file.getName(), isRecursion);
                        }
                        if (null != fileList && !fileList.isEmpty()) continue;
                        FileUtil.fileZip(null, file, zos, base + file.getName(), isRecursion);
                    }
                    break block9;
                }
                zos.putNextEntry(new ZipEntry(base));
                fis = new FileInputStream(srcFile);
                byte[] buf = new byte[1024];
                while ((n = fis.read(buf, 0, buf.length)) != -1) {
                    zos.write(buf, 0, n);
                }
                zos.flush();
            }
            catch (IOException e) {
                try {
                    LOG.error((Object)("ZipFile failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                    throw new PatchException("zipFile failed.");
                }
                catch (Throwable throwable) {
                    FileUtil.doCloseStream(fis);
                    throw throwable;
                }
            }
        }
        FileUtil.doCloseStream(fis);
    }

    private static void doCloseStream(FileInputStream in) {
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"ZipFile close in error", "");
        }
    }

    public static String readAll(String file) {
        return com.huawei.lego.core.sdk.file.util.FileUtil.readText((File)new File(file), (int)0, null);
    }
}

