/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.dto.InstallScript;
import com.huawei.lego.common.util.SignVerifier;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.util.CommonUtil;
import java.io.File;
import java.security.SignatureException;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class InitInstallScript {
    private static final Log LOG = LogFactory.getInstance(InitInstallScript.class);
    private static final String INSTALLSCRIPT_FILENAME = InstallConstant.getsBasePath() + "PlatFrom/installscript.xml";
    private static InitInstallScript sInstance;
    private InstallScript prescript;
    private InstallScript endscript;
    private InstallScript rollbackScript;

    private InitInstallScript() {
        File file = new File(INSTALLSCRIPT_FILENAME);
        try {
            SignVerifier.getInstance().verify(file);
        }
        catch (SignatureException e) {
            LOG.error((Object)"Verify failed", (Throwable)e, "");
            return;
        }
        if (!file.exists()) {
            LOG.info((Object)"No Install Script file is defined", "");
            return;
        }
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(file);
            List list = document.selectNodes("/script/prescript");
            this.prescript = this.assembleScript(list);
            list = document.selectNodes("/script/endscript");
            this.endscript = this.assembleScript(list);
            list = document.selectNodes("/script/rollbackScript");
            this.rollbackScript = this.assembleScript(list);
        }
        catch (SignatureException | DocumentException | SAXException e) {
            LOG.error((Object)"Read the Install script file error", e, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InitInstallScript getInstance() {
        Class<InitInstallScript> clazz = InitInstallScript.class;
        synchronized (InitInstallScript.class) {
            if (null == sInstance) {
                sInstance = new InitInstallScript();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private InstallScript assembleScript(List<?> list) throws SignatureException {
        InstallScript script = null;
        if (null != list && !list.isEmpty()) {
            for (Object object : list) {
                Element el = (Element)object;
                script = new InstallScript();
                String fileName = el.attributeValue("name");
                File file = new File(fileName);
                if (file.exists()) {
                    SignVerifier.getInstance().verify(file);
                }
                script.setName(fileName);
                script.setAbsolutePath(Boolean.parseBoolean(el.attributeValue("absolutePath")));
                String paramsStr = el.attributeValue("params");
                if (null == paramsStr || paramsStr.length() <= 0) continue;
                script.setParams(paramsStr.split(";"));
            }
        }
        return script;
    }

    public InstallScript getPrescript() {
        return this.prescript;
    }

    public void setPrescript(InstallScript prescript) {
        this.prescript = prescript;
    }

    public InstallScript getEndscript() {
        return this.endscript;
    }

    public void setEndscript(InstallScript endscript) {
        this.endscript = endscript;
    }

    public InstallScript getRollbackScript() {
        return this.rollbackScript;
    }

    public void setRollbackScript(InstallScript rollbackScript) {
        this.rollbackScript = rollbackScript;
    }
}

