/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PasswordCheckUtil {
    public static boolean checkIamPasswordComplexity(String pwd) {
        String excludeReg = "\\s";
        String numberLowerLetterRegex = "(?=.*\\d)(?=.*[a-z])(?=.*[`~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:'\",<.>/?]).{8,32}";
        String numberUpperLetterRegex = "(?=.*\\d)(?=.*[A-Z])(?=.*[`~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:'\",<.>/?]).{8,32}";
        String lowerUpperLetterRegex = "(?=.*[a-z])(?=.*[A-Z])(?=.*[`~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:'\",<.>/?]).{8,32}";
        return PasswordCheckUtil.matchRegex(pwd, excludeReg, numberLowerLetterRegex, numberUpperLetterRegex, lowerUpperLetterRegex);
    }

    private static boolean matchRegex(String pwd, String excludeReg, String numberLowerLetterRegex, String numberUpperLetterRegex, String lowerUpperLetterRegex) {
        String normalizePwd = Normalizer.normalize(pwd, Normalizer.Form.NFKC);
        Pattern pattern = Pattern.compile(excludeReg);
        Matcher match = pattern.matcher(normalizePwd);
        if (match.find()) {
            return false;
        }
        pattern = Pattern.compile(numberLowerLetterRegex);
        match = pattern.matcher(normalizePwd);
        if (match.matches()) {
            return true;
        }
        pattern = Pattern.compile(numberUpperLetterRegex);
        match = pattern.matcher(normalizePwd);
        if (match.matches()) {
            return true;
        }
        pattern = Pattern.compile(lowerUpperLetterRegex);
        match = pattern.matcher(normalizePwd);
        return match.matches();
    }

    public static boolean checkPasswordComplexity4Gauss(String pwd) {
        String excludeRegex = "[`'\"\\^&\\(\\)\\|<>\\s]";
        String numberLowerLetterRegex = "(?=.*\\d)(?=.*[a-z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,15}";
        String numberUpperLetterRegex = "(?=.*\\d)(?=.*[A-Z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,15}";
        String lowerUpperLetterRegex = "(?=.*[a-z])(?=.*[A-Z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,15}";
        return PasswordCheckUtil.matchRegex(pwd, excludeRegex, numberLowerLetterRegex, numberUpperLetterRegex, lowerUpperLetterRegex);
    }

    public static boolean checkCertPasswordComplex(String pwd) {
        String excludeRegex = "[`'\"\\^&\\(\\)\\|<>\\s]";
        String numberLowerLetterRegex = "(?=.*\\d)(?=.*[a-z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,18}";
        String numberUpperLetterRegex = "(?=.*\\d)(?=.*[A-Z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,18}";
        String lowerUpperLetterRegex = "(?=.*[a-z])(?=.*[A-Z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,18}";
        return PasswordCheckUtil.matchRegex(pwd, excludeRegex, numberLowerLetterRegex, numberUpperLetterRegex, lowerUpperLetterRegex);
    }
}

