/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util;

import com.huawei.cipher.EncryptedPropertiesHandler;
import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.ism.drm.wcc.util.utils.RandomUtil;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.entity.KmcImportCfg;
import com.huawei.kmc.entity.KmcImportMode;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.DataBaseTestUtil;
import com.huawei.lego.common.util.FileEncryptor;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;

public class SysConfigDataUtil {
    public static final String DATA_FILE_STARTS_SUPFIX = "data";
    private static final Log LOGGER = LogFactory.getInstance(SysConfigDataUtil.class);
    private static final String LINUX_DMP = "/usr/local/gaussdb/bin/gs_dump";
    private static final String LINUX_RESTORE = "/usr/local/gaussdb/bin/gsql";
    private static final String DATA_ENCRYPT_FILE = "config.data";
    private static final String DATA_ENCRYPT_KEY = "key";
    private static final String SALTFILE = "zip1.tmp";
    private static final String IVFILE = "zip2.tmp";
    private static final String SQL_FILE_NAME = "data.sql";
    private static final String WCC_CONFIG_FILE = "wcc.conf";
    private static final String WCC_HW_CONFIG_FILE = "wcc-hw.conf";

    public static void backupSystemData(String dstFile, String encrytPwd, boolean isExportWcc) {
        boolean dbStartOk = false;
        try {
            LOGGER.info((Object)"Start check db status. ", "");
            DataBaseInfo dbInfor = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            DataBaseTestUtil.setConnParam(dbInfor);
            if (OSInformation.isLinux() && !DataBaseTestUtil.connectionGauss()) {
                LOGGER.info((Object)"Need start gaussdb.", "");
                Path path = Paths.get(dbInfor.getServerInstallPath(), "Runtime/gs/bin/control.sh");
                CmdUtil.execStrCmd(String.join((CharSequence)" ", "sudo -u GaussDB -S", path.toString(), "start GaussDB /opt/gs/app/data/"));
            }
            for (int index = 0; index < 5; ++index) {
                TimeUnit.SECONDS.sleep(5L);
                if (!DataBaseTestUtil.connectionGauss()) continue;
                LOGGER.info((Object)("Try connect database success. times: " + index), "");
                dbStartOk = true;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"BackupSystemData failed. start gaussdb failed. errMsg:%s", ExceptionUtil.getErrorMessage((Throwable)e));
            throw new PatchException("");
        }
        if (!dbStartOk) {
            LOGGER.error((Object)"Start database failed.", "");
            throw new PatchException("");
        }
        String dstParent = new File(FilenameUtils.normalize((String)dstFile)).getParent();
        File outPath = new File(dstParent);
        if (!(outPath.exists() && outPath.isDirectory() || outPath.mkdirs())) {
            LOGGER.info((Object)"Create backupSystemData path failed.", "");
            throw new PatchException("backupSystemData failed.");
        }
        String sqlFile = SysConfigDataUtil.getDbSql(dstParent);
        SysConfigDataUtil.zipFile(sqlFile, dstFile, encrytPwd, isExportWcc);
    }

    private static void zipFile(String sqlFile, String dstFile, String encrytPwd, boolean isExportWcc) {
        File data = new File(sqlFile);
        if (!data.exists()) {
            LOGGER.error((Object)"Data file not exists.", "");
            throw new LegoCheckedException("backupSystemData failed.");
        }
        ArrayList<String> fileList = new ArrayList<String>();
        File zipFile = null;
        String destPath = "";
        try {
            zipFile = FileUtil.zipFile(new File(FilenameUtils.normalize((String)sqlFile)));
            destPath = zipFile.getParent();
            String destName = DATA_FILE_STARTS_SUPFIX + System.currentTimeMillis() + ".zip";
            if (VerifyUtil.isEmpty((String)encrytPwd)) {
                encrytPwd = RandomUtil.getRandomPassword();
                String pwdDestFile = destPath + File.separator + DATA_ENCRYPT_FILE;
                String value = "key=" + WccEncryptor.encode(encrytPwd);
                FileUtil.writeFile(pwdDestFile, value);
                fileList.add(DATA_ENCRYPT_FILE);
            }
            String ivFile = destPath + File.separator + IVFILE;
            String saltFile = destPath + File.separator + SALTFILE;
            FileEncryptor.encryptFileAccordingCipher(encrytPwd, zipFile, ivFile, saltFile, destName);
            fileList.add(destName);
            fileList.add(IVFILE);
            fileList.add(SALTFILE);
            if (isExportWcc) {
                String wccFile = destPath + File.separator + WCC_CONFIG_FILE;
                WccEncryptor.getInstance().exportAllCipherKey(wccFile, encrytPwd);
                fileList.add(WCC_CONFIG_FILE);
                fileList.add(WCC_HW_CONFIG_FILE);
            }
            FileUtil.zipFile(fileList, destPath, dstFile, true);
            WccEncryptor.signFile(dstFile);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"BackupSystemData failed. zip file failed. errMsg:%s", ExceptionUtil.getErrorMessage((Throwable)e));
            throw new PatchException("");
        }
        finally {
            SysConfigDataUtil.deleteTmpFiles(data, fileList, zipFile, destPath);
        }
    }

    private static void deleteTmpFiles(File data, List<String> fileList, File zipFile, String destPath) {
        if (data != null && data.exists() && !data.delete()) {
            LOGGER.warn((Object)String.format(Locale.ROOT, "Delete data file fail,data name is %s.", data.getName()), "");
        }
        if (zipFile != null && zipFile.exists() && !zipFile.delete()) {
            LOGGER.warn((Object)String.format(Locale.ROOT, "Delete zipFile fail,zipFile name is %s.", zipFile.getName()), "");
        }
        for (String fileTmp : fileList) {
            File file = new File(FilenameUtils.normalize((String)(destPath + File.separator + fileTmp)));
            if (!file.exists() || file.delete()) continue;
            LOGGER.warn((Object)String.format(Locale.ROOT, "Delete file fail,file name is %s.", file.getName()), "");
        }
    }

    private static String getDbSql(String dstParent) {
        DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        StringBuffer buffer = new StringBuffer();
        buffer.append(LINUX_DMP);
        buffer.append(" -h ").append(dbInfo.getDbHost());
        buffer.append(" -U ").append(dbInfo.getDbaUsername());
        buffer.append(" -W ").append(dbInfo.getDbaPassword());
        buffer.append(" -p ").append(dbInfo.getDbPort());
        buffer.append(" -Eutf8 ");
        buffer.append(" --pg-format ");
        buffer.append(" lego ");
        buffer.append(" -f ");
        String sqlFile = dstParent + File.separator + SQL_FILE_NAME;
        buffer.append(sqlFile.contains(" ") ? "\"" + sqlFile + "\"" : sqlFile);
        if (!CmdUtil.execStrCmd(buffer.toString())) {
            LOGGER.error((Object)"exec backup system data cmd failed.", "");
            throw new LegoCheckedException("backupSystemData failed.");
        }
        return sqlFile;
    }

    public static void recoveryConfigData(String configData, String decryptPwd) {
        LOGGER.info((Object)"Start recovery config data.", "");
        if (!new File(configData).exists()) {
            LOGGER.error((Object)"ConfigData file not found. recovery config data failed.", "");
            throw new PatchException("recoveryConfigData failed.");
        }
        String outPath = new File(configData).getParent() + File.separator + "dataTmp";
        FileUtil.unzipFile(configData, outPath);
        if (VerifyUtil.isEmpty((String)decryptPwd)) {
            decryptPwd = SysConfigDataUtil.getDecryptPwd(outPath);
        }
        String srcFile = SysConfigDataUtil.getSourceFile(outPath);
        String destFile = outPath + File.separator + "tmp.zip";
        String ivFile = outPath + File.separator + IVFILE;
        String saltFile = outPath + File.separator + SALTFILE;
        FileEncryptor.decryptFileAccordingCipher(srcFile, destFile, decryptPwd, saltFile, ivFile);
        FileUtil.unzipFile(destFile, outPath);
        String destSqlFile = outPath + File.separator + SQL_FILE_NAME;
        if (!new File(destSqlFile).exists()) {
            LOGGER.error((Object)"RecoveryConfigData failed, data.sql not found.", "");
            throw new PatchException("recoveryConfigData failed.");
        }
        SysConfigDataUtil.inputDbSql(destSqlFile);
    }

    private static void inputDbSql(String destSqlFile) {
        DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        SysConfigDataUtil.clearDb(dbInfo);
        StringBuffer buffer = new StringBuffer();
        buffer.append(LINUX_RESTORE);
        buffer.append(" -h ").append(dbInfo.getDbHost());
        buffer.append(" -U ").append(dbInfo.getDbaUsername());
        buffer.append(" -W ").append(dbInfo.getDbaPassword());
        buffer.append(" -p ").append(dbInfo.getDbPort());
        buffer.append(" lego ");
        buffer.append(" -f ");
        buffer.append(destSqlFile.contains(" ") ? "\"" + destSqlFile + "\"" : destSqlFile);
        if (!CmdUtil.execStrCmd(buffer.toString())) {
            LOGGER.error((Object)"RecoveryConfigData failed.", "");
            throw new PatchException("recoveryConfigData failed.");
        }
    }

    private static String getSourceFile(String outPath) {
        String sourceFile = "";
        File path = new File(outPath);
        if (!path.exists() || !path.isDirectory()) {
            throw new PatchException("Path not found, getSourceFile failed.");
        }
        File[] files = path.listFiles();
        if (files == null) {
            return sourceFile;
        }
        for (File file : files) {
            if (!file.getName().startsWith(DATA_FILE_STARTS_SUPFIX) || !file.getName().endsWith(".zip")) continue;
            try {
                sourceFile = file.getCanonicalPath();
                break;
            }
            catch (IOException ex) {
                LOGGER.error((Object)String.format(Locale.ROOT, "GetSourceFile failed: %s.", ExceptionUtil.getErrorMessage((Throwable)ex)), "");
                throw new PatchException("getSourceFile failed.");
            }
        }
        return sourceFile;
    }

    private static String getDecryptPwd(String outPath) {
        String encryptFile = outPath + File.separator + DATA_ENCRYPT_FILE;
        File file = new File(encryptFile);
        if (!file.exists()) {
            LOGGER.error((Object)"Encrypt file not found, getDecryptPwd failed.", "");
            throw new PatchException("getDecryptPwd failed.");
        }
        Properties properties = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(encryptFile);
            properties.load(input);
            String string = WccEncryptor.decode(properties.getProperty(DATA_ENCRYPT_KEY));
            return string;
        }
        catch (Exception ex) {
            LOGGER.error((Object)String.format(Locale.ROOT, "GetDecryptPwd failed: %s.", ExceptionUtil.getErrorMessage((Throwable)ex)), "");
            throw new PatchException("getDecryptPwd failed.");
        }
        finally {
            FileUtil.close(input, "close input");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void clearDb(DataBaseInfo dbInfo) {
        Connection connection = null;
        try {
            connection = LegoDBConnection.getInstance().connectionGauss(dbInfo, true);
            String dropScript = "DROP DATABASE if exists lego;";
            String createScript = "CREATE DATABASE lego WITH TEMPLATE = TEMPLATE0 ENCODING 'UTF8';";
            String ownerScript = "ALTER DATABASE lego OWNER TO " + dbInfo.getDbaUsername();
            String connLimit = "ALTER DATABASE lego CONNECTION LIMIT=100;";
            ArrayList<String> scripts = new ArrayList<String>();
            scripts.add(dropScript);
            scripts.add(createScript);
            scripts.add(ownerScript);
            scripts.add(connLimit);
            InitSQL.executeSQL(connection, scripts);
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException ex) {
                LOGGER.error((Object)String.format(Locale.ROOT, "Close connection failed: %s.", ExceptionUtil.getErrorMessage((Throwable)ex)), "");
            }
            throw throwable;
        }
        try {
            connection.close();
            return;
        }
        catch (SQLException ex) {
            LOGGER.error((Object)String.format(Locale.ROOT, "Close connection failed: %s.", ExceptionUtil.getErrorMessage((Throwable)ex)), "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transWccData() {
        String kmcConf = InitInstalledXmlTool.getInstallPath() + "/Runtime/LegoRuntime/conf/wcc";
        String wccConf = InitInstalledXmlTool.getInstallPath() + "/Runtime@tmp/LegoRuntime/conf/wcc";
        EncryptedPropertiesHandler encryptedPropertiesHandler = new EncryptedPropertiesHandler(wccConf, kmcConf);
        String sql = SysConfigDataUtil.getDbSql("");
        File wccStore = new File(wccConf + File.separator + "crypt" + File.separator + "wccStore.xml");
        try {
            if (wccStore.exists()) {
                encryptedPropertiesHandler.updateSqlData(sql);
            } else {
                encryptedPropertiesHandler.updateSqlDataFromKmc(sql);
            }
            SysConfigDataUtil.inputDbSql(sql);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"TransWccData failed, errMsg:%s.", ExceptionUtil.getErrorMessage((Throwable)ex));
        }
        finally {
            FileUtil.deleteFile(sql);
        }
    }

    public static void importKsf(String installPath) {
        String installConf = installPath + "/Runtime@tmp/LegoRuntime/conf/wcc";
        String masterKsFile = "/crypt/master.ks";
        String backupKsFile = "/crypt/backup.ks";
        String installedKsFile = installConf + masterKsFile;
        if (!new File(installConf).exists() || !new File(installedKsFile).exists()) {
            LOGGER.error((Object)"Ks file not found. No import is required.", "");
            return;
        }
        try {
            String suffix = ".bak";
            FileUtil.copyFile(installedKsFile, installedKsFile + suffix);
            KmcInstance.getSoftInstance().finalized();
            KmcInstance.initComponent((String)installConf, (boolean)true);
            String currentConf = installPath + "/Runtime/LegoRuntime/conf/wcc";
            KmcImportCfg kmcImportCfg = new KmcImportCfg(currentConf + masterKsFile);
            kmcImportCfg.setImportMode(KmcImportMode.IMPORT_APPAND);
            KmcInstance.getSoftInstance().importKsf(kmcImportCfg);
            FileUtil.copyFile(installedKsFile, currentConf + masterKsFile);
            FileUtil.copyFile(installedKsFile, currentConf + backupKsFile);
            FileUtil.copyFile(installedKsFile + suffix, installedKsFile);
            FileUtil.copyFile(installedKsFile + suffix, installConf + backupKsFile);
        }
        catch (AppException | IOException ex) {
            LOGGER.error((Object)String.format(Locale.ROOT, "Import ks file failed. Error:%s.", ExceptionUtil.getErrorMessage((Throwable)ex)), "");
            throw new PatchException("Import ks file failed.");
        }
    }
}

