/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.util.disk;

import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.disk.DiskResouceUse;
import com.huawei.lego.core.sdk.util.MathUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class LinuxDiskUtil {
    private static final Log LOG = LogFactory.getInstance(LinuxDiskUtil.class);
    private static final long MB2GB = 1000L;
    private static final int LINE_KEY_NUM = 7;
    private static final int LINE_TYPE = 1;
    private static final int LINE_TOTAL = 2;
    private static final int LINE_USED = 3;
    private static final int LINE_AVLID = 4;
    private static final int LINE_PERCENT = 5;
    private static final int LINE_NAME = 6;
    private static final int TIME_OUT = 5000;
    private static final int SLEEP_TIME = 500;
    private static final String ISO = "iso9660";
    private static final String UDF = "udf";

    private static DiskResouceUse getResouceUse(String str, String filesystem) {
        DiskResouceUse resourceUse = null;
        String keyword = "/dev";
        String ukeyword = "udev";
        if ((filesystem.contains(keyword) && !filesystem.contains(ukeyword) || str.contains(keyword)) && !str.contains(ukeyword)) {
            String temp = str.replaceAll("\\s", " ");
            String[] result = new String[7];
            StringTokenizer tokenizer = new StringTokenizer(temp, " \t\n\r\f%");
            for (int i = 0; tokenizer.hasMoreTokens() && i < 7; ++i) {
                result[i] = !"".equals(filesystem) && i == 0 ? filesystem : tokenizer.nextToken();
            }
            if (ISO.equalsIgnoreCase(result[1])) {
                return null;
            }
            if (UDF.equalsIgnoreCase(result[1])) {
                return null;
            }
            resourceUse = new DiskResouceUse();
            resourceUse.setDiskName(result[6]);
            resourceUse.setTotal(result[2]);
            resourceUse.setUsed(result[3]);
            resourceUse.setAvail(result[4]);
            resourceUse.setPercent(result[5]);
            resourceUse = LinuxDiskUtil.unit(resourceUse);
            resourceUse.setUnit("GB");
        }
        return resourceUse;
    }

    private static String getGb(String value) {
        Double gbValue;
        String gb = "";
        String gbUnit = "G";
        if (value.contains("M")) {
            gbValue = MathUtil.getDoubleValue((double)(Double.parseDouble(value.replaceAll("M", "")) / 1000.0), (int)2);
            gb = gbValue + gbUnit;
        }
        if (value.contains("K")) {
            gbValue = MathUtil.getDoubleValue((double)(Double.parseDouble(value.replaceAll("K", "")) / 1000000.0), (int)2);
            gb = gbValue + gbUnit;
        }
        if (value.contains("T")) {
            gbValue = MathUtil.getDoubleValue((double)(Double.parseDouble(value.replaceAll("T", "")) * 1000.0), (int)2);
            gb = gbValue + gbUnit;
        }
        if (value.contains("P")) {
            gbValue = MathUtil.getDoubleValue((double)(Double.parseDouble(value.replaceAll("P", "")) * 1000.0 * 1000.0), (int)2);
            gb = gbValue + gbUnit;
        }
        return gb;
    }

    private static DiskResouceUse unit(DiskResouceUse diskResouceUse) {
        String avail = diskResouceUse.getAvail();
        String used = diskResouceUse.getUsed();
        String total = diskResouceUse.getTotal();
        if (LinuxDiskUtil.isContains(avail)) {
            diskResouceUse.setAvail(LinuxDiskUtil.getGb(avail));
        }
        if (LinuxDiskUtil.isContains(used)) {
            diskResouceUse.setUsed(LinuxDiskUtil.getGb(used));
        }
        if (LinuxDiskUtil.isContains(total)) {
            diskResouceUse.setTotal(LinuxDiskUtil.getGb(total));
        }
        return diskResouceUse;
    }

    private static boolean isContains(String avail) {
        return avail.contains("M") || avail.contains("K") || avail.contains("T") || avail.contains("P");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getDistExitVal(long startTime, boolean processFinished, int exitValue, Process process) {
        while (System.currentTimeMillis() - startTime < 5000L && !processFinished) {
            try {
                exitValue = process.exitValue();
                if (0 != exitValue) continue;
                processFinished = Boolean.TRUE;
            }
            catch (IllegalThreadStateException ie) {
                LOG.error((Object)"IllegalThreadStateException", (Throwable)ie, "");
            }
            finally {
                LinuxDiskUtil.sleep(500);
            }
        }
        return exitValue;
    }

    private static void getDiskClose(BufferedReader br, InputStreamReader isReader, Process process) {
        try {
            if (null != br) {
                br.close();
            }
            if (null != isReader) {
                isReader.close();
            }
        }
        catch (IOException ioex) {
            LOG.error((Object)"Fail to close input", (Throwable)ioex, "");
        }
        if (null != process) {
            process.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DiskResouceUse> getDisk() {
        ArrayList<DiskResouceUse> diskList = new ArrayList<DiskResouceUse>();
        String os = System.getProperty("os.name");
        if (null != os && !os.toLowerCase(Locale.US).contains("linux")) {
            return diskList;
        }
        String cmd = "df -hT";
        Process process = null;
        BufferedReader in = null;
        InputStreamReader ir = null;
        int exitVal = -1;
        try {
            process = Runtime.getRuntime().exec(cmd);
            LinuxDiskUtil.sleep(500);
            long startTime = System.currentTimeMillis();
            boolean processFinished = false;
            exitVal = LinuxDiskUtil.getDistExitVal(startTime, processFinished, exitVal, process);
            if (0 != exitVal) {
                ArrayList<DiskResouceUse> arrayList = diskList;
                return arrayList;
            }
            ir = new InputStreamReader(process.getInputStream());
            in = new BufferedReader(ir);
            DiskResouceUse resourceUse = null;
            String str = "";
            while ((str = FileUtil.getLineFromFile(in)) != null) {
                StringTokenizer tokens = new StringTokenizer(str, " \t\n\r\f%");
                String fileSystem = "";
                String fileNameLong = tokens.nextToken();
                if (!tokens.hasMoreTokens()) {
                    str = FileUtil.getLineFromFile(in);
                    if (str == null) {
                        throw new IOException("Expecting a line not the end of stream");
                    }
                    fileSystem = fileNameLong;
                }
                if (null == (resourceUse = LinuxDiskUtil.getResouceUse(str, fileSystem))) continue;
                diskList.add(resourceUse);
            }
            LinuxDiskUtil.getDiskClose(in, ir, process);
        }
        catch (IOException e) {
            LOG.error((Object)"Fail to get root partition, IOException:", (Throwable)e, "");
        }
        finally {
            LinuxDiskUtil.getDiskClose(in, ir, process);
        }
        return diskList;
    }

    private static void sleep(int sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"System monitor thread interruptedException ", (Throwable)e, "");
        }
    }
}

