/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.plugin.common;

import com.huawei.drm.install.common.dto.PlatformBundles;
import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.lego.common.util.InitBundleXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.FileWriter;
import java.io.IOException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class BuildProductBundlesFile {
    private static final Log LOG = LogFactory.getInstance(BuildProductBundlesFile.class);

    public static void main(String[] args) {
        String outPutPath = "./productFile";
        ArrayList<String> list = new ArrayList<String>();
        try (FileWriter writer = new FileWriter(outPutPath);){
            Map<String, ProductBundles> productBundles = InitBundleXmlTool.initProductBundls();
            for (Map.Entry<String, ProductBundles> item : productBundles.entrySet()) {
                list.add(item.getKey());
            }
            Map<String, PlatformBundles> ptList = InitBundleXmlTool.initPlatFormBundls();
            PlatformBundles ptBundle = ptList.values().stream().filter(e -> e.getId().equals(LegoResourceManager.getProValue("lego.core.base.bundle.id"))).findFirst().orElseGet(null);
            int iCount = 1;
            if (ptBundle != null) {
                BuildProductBundlesFile.writeBundle(writer, ptBundle, iCount);
                ++iCount;
            }
            Collections.sort(list);
            for (String id : list) {
                iCount = BuildProductBundlesFile.writeDataToFile(productBundles, writer, iCount, id);
            }
            writer.flush();
        }
        catch (IOException | SignatureException e2) {
            LOG.error((Object)"Exception: ", (Throwable)e2, "");
        }
        System.exit(0);
    }

    private static int writeDataToFile(Map<String, ProductBundles> productBundles, FileWriter writer, int iCount, String id) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, ProductBundles> item : productBundles.entrySet()) {
            ProductBundles value = item.getValue();
            if (!value.getId().trim().equals(id.trim()) || "ism.v2r5.base.bundle".equals(value.getId().trim())) continue;
            builder.append(iCount++).append(". ").append("\t").append(item.getKey()).append("\t").append(LegoResourceManager.getString(value.getName())).append("\t").append(LegoResourceManager.getString(value.getDescription())).append("\t").append(value.getVersion()).append("\t").append(value.getExtendCallBackClz()).append("\t").append(value.getSize()).append("MB");
            writer.write(builder.toString());
            writer.write("\r\n");
        }
        return iCount;
    }

    private static void writeBundle(FileWriter writer, PlatformBundles ptBundle, int iCount) throws IOException {
        String builder = iCount + ". \t" + ptBundle.getId() + "\t" + LegoResourceManager.getString(ptBundle.getName()) + "\t" + LegoResourceManager.getString(ptBundle.getName()) + "\t" + ptBundle.getVersion() + "\tnull\t" + ptBundle.getSize() + "MB";
        writer.write(builder);
        writer.write("\r\n");
    }
}

