/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.sdk.constants;

import java.util.stream.Stream;

public final class OpenstackEnumDefine {

    public static enum HypermetroDomainWorkMode {
        HYPERMETRO_MODE("0"),
        SYNC_MODE("1");

        private String value;

        private HypermetroDomainWorkMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum AddressType {
        FIXED("fixed"),
        FLOATING("floating");

        private String value;

        private AddressType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum OsAllowType {
        IP("ip"),
        USER("user");

        private String value;

        private OsAllowType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SharePairDataState {
        COMPLETE("1"),
        INCOMPLETE("2");

        private String value;

        private SharePairDataState(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum HypermetroDomainAccess {
        FORBIDDEN("1"),
        READABLE_AND_WRITABLE("3");

        private String value;

        private HypermetroDomainAccess(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum OsAllowAccessStatus {
        ACTIVE("active"),
        ERROR("error");

        private String value;

        private OsAllowAccessStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum HypermetroDomainRole {
        PRIMARY("1"),
        SECONDARY("0");

        private String value;

        private HypermetroDomainRole(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ShareStatus {
        AVAILABLE("available"),
        CREATING("creating"),
        DELETING("deleting"),
        ERROR_DELETING("error_deleting"),
        MANAGE_STARTING("manage_starting"),
        UN_MANAGE_STARTING("unmanage_starting"),
        EXTENDING("extending"),
        SHRINKING("shrinking"),
        MIGRATING("migrating"),
        REVERTING("reverting");

        private String value;

        private ShareStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum HypermetroDomainStatus {
        NORMAL("0", "normal"),
        RECOVERING("1", "recovering"),
        ERROR("2", "error"),
        SPLIT("3", "split"),
        FORCE_PULL_UP("4", "force_pull_up"),
        INVALID("5", "invalid");

        private String key;
        private String value;

        private HypermetroDomainStatus(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static HypermetroDomainStatus getTypeFromValue(String key) {
            for (HypermetroDomainStatus type : HypermetroDomainStatus.values()) {
                if (!type.getKey().equals(key)) continue;
                return type;
            }
            return INVALID;
        }
    }

    public static enum SharePairLinkStatus {
        CONNECTED("connected", "1"),
        DISCONNECTED("disconnected", "2");

        private String key;
        private String value;

        private SharePairLinkStatus(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SharePairHealthStatus {
        UNKNOWN("unknown", "0"),
        NORMAL("normal", "1"),
        FAULTY("faulty", "2");

        private String key;
        private String value;

        private SharePairHealthStatus(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SharePairRunningStatus {
        UNKNOWN("0", "unknown"),
        NORMAL("1", "normal"),
        SYNCHRONIZING("23", "synchronizing"),
        INVALID("35", "invalid"),
        PAUSE("41", "pause"),
        FORCE_START("93", "force_start"),
        WAITING_FOR_SYNCHRONIZATION("100", "waiting_for_synchronization"),
        DELETEING("109", "deleting"),
        CREATING("119", "creating");

        private String key;
        private String value;

        private SharePairRunningStatus(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ArchitectureAndCpuVendor {
        INTEL("Intel", "x86"),
        PHYTIUM("Phytium", "aarch64"),
        HISILICON("Hisilicon", "aarch64"),
        HYGON("Hygon", "x86");

        private String cpuVendor;
        private String architecture;

        private ArchitectureAndCpuVendor(String cpuVendor, String architecture) {
            this.cpuVendor = cpuVendor;
            this.architecture = architecture;
        }

        public static String getArchitectureByCpuVendor(String cpuVendor) {
            for (ArchitectureAndCpuVendor architectureAndCpuVendor : ArchitectureAndCpuVendor.values()) {
                if (!architectureAndCpuVendor.getCpuVendor().equals(cpuVendor)) continue;
                return architectureAndCpuVendor.getArchitecture();
            }
            return INTEL.getArchitecture();
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public String getCpuVendor() {
            return this.cpuVendor;
        }

        public static String getCpuVendorByArchitecture(String architecture) {
            return HISILICON.getArchitecture().equals(architecture) ? HISILICON.getCpuVendor() : INTEL.getCpuVendor();
        }
    }

    public static enum HwFirmwareTypeE {
        BIOS("bios"),
        UEFI("uefi");

        private String value;

        private HwFirmwareTypeE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum RecoverStrategy {
        AUTO("1", "auto"),
        MANUAL("2", "manual");

        private String queryVal;
        private String updateVal;

        private RecoverStrategy(String queryVal, String updateVal) {
            this.queryVal = queryVal;
            this.updateVal = updateVal;
        }

        public String getQueryVal() {
            return this.queryVal;
        }

        public String getUpdateVal() {
            return this.updateVal;
        }

        public static RecoverStrategy getTypeFromValue(String value) {
            for (RecoverStrategy type : RecoverStrategy.values()) {
                if (!type.getQueryVal().equals(value) && !type.getUpdateVal().equals(value)) continue;
                return type;
            }
            return null;
        }
    }

    public static enum FusionCloudVersionE {
        VERSION_2_06("2.06"),
        VERSION_6_1("6.1"),
        VERSION_6_0("6.0"),
        VERSION_6_3("6.3");

        private String value;

        private FusionCloudVersionE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ArbStatusE {
        FAIL_LOCAL("fail_local"),
        FAIL_REMOTE("fail_remote"),
        OK("OK");

        private String value;

        private ArbStatusE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum VolsnapshotStatusE {
        CREATING("creating"),
        AVAIABLE("available"),
        DELETING("deleting"),
        ERROR_DELETING("error_deleting"),
        ERROR("error");

        private String value;

        private VolsnapshotStatusE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum RollbackOperationTypeE {
        CREATE_PROTECTGROUP(1),
        ADD_PROTECTOBJECT(2),
        MODIFY_VOLUME(3),
        INVALID(-1);

        private int operationType;

        private RollbackOperationTypeE(int operationType) {
            this.operationType = operationType;
        }

        public int getType() {
            return this.operationType;
        }
    }

    public static enum ReplicaBandwidthE {
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        HIGHEST(4);

        private int bandwidth;

        private ReplicaBandwidthE(int bandwidth) {
            this.bandwidth = bandwidth;
        }

        public int getBandWidth() {
            return this.bandwidth;
        }

        public static ReplicaBandwidthE valueOf(int bandwidth) {
            for (ReplicaBandwidthE value : ReplicaBandwidthE.values()) {
                if (value.bandwidth != bandwidth) continue;
                return value;
            }
            return MEDIUM;
        }
    }

    public static enum VolcgsnapshotStatusE {
        CREATING("creating"),
        AVAIABLE("available"),
        ERROR("error");

        private String value;

        private VolcgsnapshotStatusE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum VolcgStatusE {
        CREATING("creating"),
        AVAIABLE("available"),
        ERROR("error");

        private String value;

        private VolcgStatusE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum VolProtectStatusE {
        UNPROTECTED("UNPROTECTED"),
        PROTECTED("PROTECTED"),
        REMOVED("REMOVED"),
        RELEASING("RELEASING"),
        CONFIGING("CONFIGING");

        private String status;

        private VolProtectStatusE(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }

    public static enum NetneStatusE {
        ACTIVE("active", 0),
        DOWN("down", 1),
        BUILD("build", 2),
        ERROR("error", 3),
        PENDING_CREATE("pending_create", 4),
        PENDING_UPDATE("pending_update", 5),
        PENDING_DELETE("pending_delete", 6),
        UNRECOGNIZED("unrecognized", 7);

        private String type;
        private int value;

        private NetneStatusE(String type, int value) {
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public int getValue() {
            return this.value;
        }

        public static NetneStatusE getStatus(String type) {
            NetneStatusE ret = UNRECOGNIZED;
            for (NetneStatusE netEnum : NetneStatusE.values()) {
                if (!netEnum.getType().equalsIgnoreCase(type)) continue;
                ret = netEnum;
                break;
            }
            return ret;
        }
    }

    public static enum HoldVmStatusE {
        NORMAL("normal"),
        UNEXISTED("unexisted"),
        UNMATCHED("unmatched");

        private String value;

        private HoldVmStatusE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum VmStatusE {
        ACTIVE("active", 0),
        BUILD("build", 1),
        REBUILD("rebuild", 2),
        HARD_REBOOT("hard_reboot", 10),
        ERROR("error", 13),
        STOPPED("stopped", 14),
        SHUTOFF("shutoff", 15),
        MIGRATING("migrating", 16),
        UNRECOGNIZED("unrecognized", 17);

        private String type;
        private int value;

        private VmStatusE(String type, int value) {
            this.type = type;
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public static VmStatusE getStatus(String type) {
            VmStatusE ret = UNRECOGNIZED;
            for (VmStatusE vmEnum : VmStatusE.values()) {
                if (!type.equalsIgnoreCase(vmEnum.getType())) continue;
                ret = vmEnum;
                break;
            }
            return ret;
        }

        public static VmStatusE getStatusByValue(int value) {
            VmStatusE ret = UNRECOGNIZED;
            for (VmStatusE vmEnum : VmStatusE.values()) {
                if (value != vmEnum.getValue()) continue;
                ret = vmEnum;
                break;
            }
            return ret;
        }

        public static enum VmTaskStatusE {
            POWERING_OFF("powering-off"),
            REBOOTING_HARD("rebooting_hard"),
            REBOOT_PENDING_HARD("reboot_pending_hard"),
            REBOOT_STARTED_HARD("reboot_started_hard"),
            RE_BUILDING("rebuilding"),
            REBUILD_BLOCK_DEVICE_MAPPING("rebuild_block_device_mapping"),
            REBUILD_SPAWNING("rebuild_spawning");

            private String value;

            private VmTaskStatusE(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }
        }
    }

    public static enum DrStarStatus {
        ENABLE("enable"),
        DISABLE("disable"),
        ERROR("error");

        private String value;

        private DrStarStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static DrStarStatus getStatus(String name) {
            return Stream.of(DrStarStatus.values()).filter(obj -> obj.getValue().equals(name)).findFirst().orElse(ERROR);
        }
    }

    public static enum ReplicationRepStatusE {
        ACTIVE("active"),
        ACTIVESTOPPED("active-stopped"),
        INACTIVE("inactive"),
        ERROR("error"),
        DISABLED("disabled"),
        COPYING("copying"),
        STANDBY("standby"),
        UNKNOWN("unknown");

        private String value;

        private ReplicationRepStatusE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ReplicationRepStatusE getStatus(String value) {
            ReplicationRepStatusE enumType = ERROR;
            for (ReplicationRepStatusE volumeEnum : ReplicationRepStatusE.values()) {
                if (!value.equals(volumeEnum.getValue())) continue;
                enumType = volumeEnum;
                break;
            }
            return enumType;
        }

        public static long getErrorCode(String status) {
            if (COPYING.getValue().endsWith(status)) {
                return 1073948134L;
            }
            return 1073948906L;
        }
    }

    public static enum ReplicationStatusE {
        AVAILABLE("available"),
        CREATING("creating"),
        DELETING("deleting"),
        ERROR("error"),
        UPDATING("updating"),
        FAILOVERING("failovering"),
        ERRORFAILOVERING("error_failovering"),
        REVERSING("reversing"),
        ERRORREVERSING("error_reversing"),
        ERROR_DELETING("error_deleting"),
        FAILOVER_RET_FAILED("failed"),
        INVALID("invalid");

        private String value;

        private ReplicationStatusE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum VolumeStatusE {
        AVAILABLE("available", 0),
        CREATING("creating", 1),
        ATTACHING("attaching", 2),
        INUSE("in-use", 3),
        DELETING("deleting", 4),
        ERROR("error", 5),
        ERRORDELETING("error_deleting", 6),
        BACKINGUP("backing-up", 7),
        RESTORINGBACKUP("restoring-backup", 8),
        ERRORRESTORING("error_restoring", 9),
        ERROREXTENDING("error_extending", 10),
        RESERVED("reserved", 11),
        MAINTENANCE("maintenance", 12),
        INVALID("invalid", -1);

        private int value;
        private String type;

        private VolumeStatusE(String type, int value) {
            this.type = type;
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public static VolumeStatusE getStatus(String type) {
            VolumeStatusE enumType = INVALID;
            for (VolumeStatusE volumeEnum : VolumeStatusE.values()) {
                if (!volumeEnum.getType().equals(type)) continue;
                enumType = volumeEnum;
                break;
            }
            return enumType;
        }

        public static VolumeStatusE getStatus(int value) {
            VolumeStatusE enumType = INVALID;
            for (VolumeStatusE volumeEnum : VolumeStatusE.values()) {
                if (value != volumeEnum.getValue()) continue;
                enumType = volumeEnum;
                break;
            }
            return enumType;
        }
    }

    public static enum RequestUrl {
        IDENTITY_TOKEN("identity", "/identity/v3/auth/tokens?nocatalog"),
        IDENTITY_VERSION("identity", "/identity/v3"),
        IDENTITY_REGIONS("identity", "/identity/v3/regions"),
        IDENTITY_PROJECTS("identity", "/identity/v3/auth/projects"),
        IDENTITY_DOMAINS("identity", "/identity/v3/domains"),
        IDENTITY_SERVICE("identity", "/identity/v3/services"),
        IDENTITY_ENDPOINTS("identity", "/identity/v3/endpoints"),
        NOVA_CREATE_SERVERS("compute", "/%s/servers"),
        NOVA_QUERY_SERVERS("compute", "/%s/servers/detail?limit={limit}"),
        NOVA_EXT_QUERY_SERVERS("compute-ext", "/%s/servers?expect_fields=basic,flavor,addresses,interface,metadata,volume,tags&limit={limit}&offset={offset}"),
        NOVA_EXT_QUERY_SERVERS_COUNT("compute-ext", "servers"),
        NOVA_QUERY_PAGES_SERVERS("compute", "/%s/servers/detail?marker={marker}&limit={limit}"),
        NOVA_QUERY_SERVER_FLAVORS("compute", "/%s/flavors/detail"),
        NOVA_QUERY_VMADDRESS("compute-ext", "/%s/servers?expect_fields=address_map&server_id={server_id}"),
        NOVA_DELETE_VM("compute", "/%s/servers/%s"),
        NOVA_QUERY_SERVER("compute", "/%s/servers/%s"),
        NOVA_RESET_SERVER_STATE("compute", "/%s/servers/%s/action"),
        NOVA_LIST_SERVER_INTERFACES("compute", "/%s/servers/%s/os-interface"),
        NOVA_SERVER_ACTION("compute", "/%s/servers/%s/action"),
        NOVA_VOLUME_ATTACH("compute", "/%s/servers/%s/os-volume_attachments"),
        NOVA_VOLUME_DETACH("compute", "/%s/servers/%s/os-volume_attachments/%s"),
        APICOM_VOLUME_ATTACH("apicom", "%s/baremetalservers/%s/attachvolume"),
        APICOM_VOLUME_DETACH("apicom", "%s/baremetalservers/%s/detachvolume/%s"),
        NOVA_PORT_ATTACH("compute", "/%s/servers/%s/os-interface"),
        NOVA_PORT_DETACH("compute", "/%s/servers/%s/os-interface/%s"),
        NOVA_PORT_DETACH_6_1("compute-ext", "/%s/servers/%s/os-interface_force_detach"),
        NOVA_SERVER_TAG("compute", "/%s/servers/%s/tags/%s"),
        NOVA_VOLUMES_REATTACH("compute-ext", "/%s/servers/%s/os-volume_reconnect"),
        NOVA_HYPERMETRO_VOL_PATH("compute-ext", "servers/%s/block_device/%s?need_csd={need_csd}"),
        NOVA_METADATA("compute", "/%s/servers/%s/metadata"),
        NOVA_AGGREGATES_BY_AZ("compute", "/%s/os-aggregates?availability_zone={availability_zone}"),
        NOVA_HYPERVISORS_DETAILS_BY_HOSTNAME("compute", "/%s/os-hypervisors/detail?hypervisor_hostname_pattern={hypervisor_hostname_pattern}"),
        NOVA_QUERY_VMSADDRESS("compute-ext", "/%s/servers?expect_fields=address_map&limit={limit}&offset={offset}"),
        NOVA_ALL_HYPERVISORS_DETAILS("compute", "/%s/os-hypervisors/detail"),
        NOVA_HYPERVISORS_DETAILS_BY_AZ("compute-ext", "/%s/os-hypervisors/detail?availability_zone={availability_zone}"),
        SYSTEM_CAPABILITIES("compute-ext", "/system_capabilities?capability_type={capability_type}"),
        CINDER_QUERY_VOL_DETAILS("volume", "/%s/volumes/detail?offset={offset}&limit={limit}"),
        CINDER_QUERY_VOL_DETAILS_BY_CG("volume", "/%s/volumes/detail?consistencygroup_id={consistencygroup_id}&offset={offset}&limit={limit}"),
        CINDER_QUERY_VOL("volume", "/%s/volumes/%s"),
        CINDER_BATCHQUERY_VOL_DETAILS_BY_CG("volume", "/%s/volumes/detail?consistencygroup_id={consistencygroup_id}&offset={offset}&limit={limit}"),
        CINDER_CREATE_VOL("volume", "/%s/volumes"),
        CINDER_DELETE_VOL("volume", "/%s/volumes/%s"),
        CINDER_UPDATE_VOL("volume", "/%s/volumes/%s"),
        CINDER_VOL_ACTION("volume", "/%s/volumes/%s/action"),
        CINDER_CREATE_VOLCG("volume", "/%s/consistencygroups"),
        CINDER_UPDATE_VOLCG("volume", "/%s/consistencygroups/%s"),
        CINDER_DELETE_VOLCG("volume", "/%s/consistencygroups/%s"),
        CINDER_QUERY_VOLCG("volume", "/%s/consistencygroups/%s"),
        CINDER_CREATE_VOLCGSNAPSHOT("volume", "/%s/cgsnapshots"),
        CINDER_DELETE_VOLCGSNAPSHOT("volume", "/%s/cgsnapshots/%s"),
        CINDER_QUERY_VOLCGSNAPSHOT("volume", "/%s/cgsnapshots/%s"),
        CINDER_QUERY_VOLSNAPSHOTLIST_CG("volume", "/%s/snapshots/detail?cgsnapshot_id={cgsnapshot_id}"),
        CINDER_CREATE_VOLSNAPSHOT("volume", "/%s/snapshots"),
        CINDER_ACTIVE_VOLSNAPSHOTS("volume", "/%s/os-hw_snapshots/active_snapshots"),
        CINDER_QUERY_VOLSNAPSHOT_DETAIL("volume", "/%s/os-hw_snapshots/%s"),
        CINDER_DELETE_VOLSNAPSHOT("volume", "/%s/snapshots/%s"),
        CINDER_QUERY_VOLSNAPSHOTLIST("volume", "/%s/snapshots/detail?offset={offset}&limit={limit}"),
        CINDER_BATCHQUERYQUERY_VOLSNAPSHOTLIST_CG("volume", "/%s/snapshots/detail?cgsnapshot_id={cgsnapshot_id}&offset={offset}&limit={limit}"),
        CINDER_QUERY_VOLSNAPSHOTS_BY_VOLUME("volume", "/%s/snapshots/detail?volume_id={volume_id}"),
        CINDER_QUERY_VOLSNAPSHOT("volume", "/%s/snapshots/%s"),
        CINDER_CREATE_VOL_METADATA("volume", "/%s/volumes/%s/metadata"),
        CINDER_DELETE_VOL_METADATA("volume", "/%s/volumes/%s/metadata/%s"),
        DR_LIST_VOLREPS_CG("agent", "v2/%s/replications?replicationcg_id={replicationcg_id}&offset={offset}&limit={limit}"),
        DR_LIST_VOLREPS("agent", "v2/%s/replications?offset={offset}&limit={limit}"),
        DR_LIST_VOLREP_DETAILS_CG("agent", "v2/%s/replications/detail?replicationcg_id={replicationcg_id}"),
        DR_LIST_VOLREPS_DETAILS_CG_REAL("agent", "v2/%s/replications/array_info?replicationcg_id={replicationcg_id}"),
        DR_LIST_VOLREP_DETAILS("agent", "v2/%s/replications/detail?offset={offset}&limit={limit}"),
        DR_QUERY_VOLREP("agent", "v2/%s/replications/%s"),
        DR_CREATE_VOLREP("agent", "v2/%s/replications"),
        DR_DELETE_VOLREP("agent", "v2/%s/replications/%s"),
        DR_LIST_VOLREPCG_DETAILS("agent", "v2/%s/replicationcgs/detail?offset={offset}&limit={limit}"),
        DR_QUERY_VOLREPCG("agent", "v2/%s/replicationcgs/%s"),
        DR_QUERY_VOLREPCG_REAL("agent", "v2/%s/replicationcgs/array_info/%s"),
        DR_CREATE_VOLREPCG("agent", "v2/%s/replicationcgs"),
        DR_UPDATE_VOLREPCG("agent", "v2/%s/replicationcgs/%s"),
        DR_REVERSE_VOLREPCG("agent", "v2/%s/replicationcgs/%s/action"),
        DR_DELETE_VOLREPCG("agent", "v2/%s/replicationcgs/%s"),
        DR_VOLREPCG_ACTION("agent", "v2/%s/replicationcgs/%s/action"),
        DR_VOLREPCG_RING_ACTION("agent", "v2/%s/dr_stars/%s/action"),
        DR_LIST_STORAGEPOOLS("agent", "v2/%s/scheduler-stats/get_pools?detail={detail}"),
        CINDER_QUERY_VOL_TYPES("volume", "/%s/types"),
        CINDER_QUERY_AZ("volume", "/%s/os-availability-zone"),
        NETWORKING_QUERY_NETWORK("network", "/v2.0/networks"),
        NETWORKING_QUERY_PORT("network", "/v2.0/ports"),
        NETWORKING_QUERY_SUBNET("network", "/v2.0/subnets"),
        NETWORKING_QUERY_SUBNET_BY_NETWORK("network", "/v2.0/subnets?network_id={network_id}"),
        NETWORKING_UPDATE_PORT("network", "/v2.0/ports/%s"),
        NETWORKING_QUERY_ONEPORT("network", "/v2.0/ports/%s"),
        NETWORKING_DELETE_PORT("network", "/v2.0/ports/%s"),
        IAM_TOKEN("iam", "/v3/auth/tokens"),
        IAM_REGIONS("iam", "/v3/regions"),
        IAM_PROJECTS("iam", "/v3/projects"),
        IAM_DOMAIN("iam", "/v3-huawei/domain/%s"),
        IAM_SERVICE("iam", "/v3/services"),
        IAM_ENDPOINTS("iam", "/v3/endpoints"),
        IAM_SIGNCA("iam", "/v3/OS-SIMPLE-CERT/certificates"),
        CEILOMETER_POST("meters", "v2/meters/%s"),
        IMAGE_QUERY_IMAGE("image", "/v2/images"),
        DR_CREATE_RING_ACTION("agent", "v2/%s/dr_stars"),
        DR_QUERY_REPLICATION_RING("agent", "v2/%s/dr_stars/%s"),
        RING_ACTION("agent", "v2/%s/dr_stars/%s/action"),
        DR_DELETE_RING("agent", "v2/%s/dr_stars/%s"),
        NOVA_EXT_SERVER_ACTION("compute-ext", "/%s/servers/%s/action"),
        MANILA_SHARES_DETAIL("manila", "/v2/%s/shares/detail"),
        MANILA_SHARES_DETAIL_BY_ID("manila", "/v2/%s/shares/%s"),
        FILEMETER_QUERY_FILE_SYSTEM_BY_SHARE_ID("filemeter", "/v1/%s/fs_info/%s"),
        FILEMETER_CREATE_FILE_SYSTEM("filemeter", "/v1/%s/create_fs"),
        FILEMETER_CREATE_SHARE_PAIR("filemeter", "/v1/%s/share_pair"),
        FILEMETER_CREATE_SHARE("filemeter", "/v1/%s/create_share_by_fs"),
        FILEMETER_QUERY_SHARE_PAIR("filemeter", "/v1/%s/share_pair/%s"),
        FILEMETER_QUERY_HYPERMETRO_DOMAIN("filemeter", "/v1/%s/hypermetro_domain/%s"),
        DELETE_SHARE_AND_PAIR("filemeter", "/v1/%s/share_pair/%s"),
        UPDATE_SHARE_TAGS("filemeter", "/v1/%s/update_share_tags/%s"),
        DELETE_SHARE_TAGS("filemeter", "/v1/%s/delete_share_tags/%s"),
        DELETE_FILE_SYSTEM("filemeter", "/v1/%s/delete_fs/%s"),
        FILEMETER_SWITCHOVER_HYPERMETRO_DOMAIN("filemeter", "/v1/%s/switchover/%s"),
        FILEMETER_SPLIT_HYPERMETRO_DOMAIN("filemeter", "/v1/%s/split_hypermetro_domain/%s"),
        FILEMETER_CANCEL_SECONDARY_RESOURCE_PROTECTION("filemeter", "/v1/%s/cancel_protection/%s"),
        ADD_ALLOW_ACCESS("manila", "/v2/%s/shares/%s/action"),
        DELETE_SHARE("manila", "/v1/%s/shares/%s"),
        ADD_PROTECTION("filemeter", "/v1/%s/add_protection/%s"),
        RECOVER_HYPERMETRO_DOMAIN("filemeter", "/v1/%s/recover_hypermetro_domain/%s");

        private String type;
        private String uri;

        private RequestUrl(String type, String uri) {
            this.type = type;
            this.uri = uri;
        }

        public String getType() {
            return this.type;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

