/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.sdk.model;

import com.huawei.ism.drm.openstack.sdk.model.OpenStackStoragePoolRemoteDevInfo;
import com.huawei.ism.drm.openstack.sdk.msg.StoragePoolInfo;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import java.util.ArrayList;
import java.util.List;

public class OpenStackStorageResourcePool
extends ManagedObject {
    private static final long serialVersionUID = -6892329942385868140L;
    private String regionUuid;
    private String projectUuid;
    private String localDevSn;
    private String localDevWwn;
    private String remoteDevsStr;
    private String remoteHypermetroDevsStr;
    private List<OpenStackStoragePoolRemoteDevInfo> remoteDevs;
    private List<OpenStackStoragePoolRemoteDevInfo> remoteHyperMetroDevs;

    public OpenStackStorageResourcePool() {
        this.remoteDevs = new ArrayList<OpenStackStoragePoolRemoteDevInfo>();
        this.remoteHyperMetroDevs = new ArrayList<OpenStackStoragePoolRemoteDevInfo>();
    }

    public OpenStackStorageResourcePool(StoragePoolInfo storagePoolInfo) {
        if (null == storagePoolInfo) {
            return;
        }
        this.setName(storagePoolInfo.getName());
        this.remoteDevs = new ArrayList<OpenStackStoragePoolRemoteDevInfo>();
        this.remoteHyperMetroDevs = new ArrayList<OpenStackStoragePoolRemoteDevInfo>();
        if (null != storagePoolInfo.getCapabilities()) {
            String localInfo = storagePoolInfo.getCapabilities().getLocalReplicationDevice();
            if (null != localInfo && !localInfo.isEmpty()) {
                this.getLocalInfo(localInfo);
            }
            this.remoteDevsStr = storagePoolInfo.getCapabilities().getRemoteReplicationDevice();
            this.remoteHypermetroDevsStr = storagePoolInfo.getCapabilities().getRemoteHyperMetroDevice();
        }
    }

    public String getLocalDevSn() {
        return this.localDevSn;
    }

    public void setLocalDevSn(String localDevSn) {
        this.localDevSn = localDevSn;
    }

    public String getLocalDevWwn() {
        return this.localDevWwn;
    }

    public void setLocalDevWwn(String localDevWwn) {
        this.localDevWwn = localDevWwn;
    }

    public String getRemoteDevsStr() {
        return this.remoteDevsStr;
    }

    public void setRemoteDevsStr(String remoteDevsStr) {
        this.remoteDevsStr = remoteDevsStr;
    }

    public List<OpenStackStoragePoolRemoteDevInfo> getRemoteDevs() {
        return this.remoteDevs;
    }

    public void setRemoteDevs(List<OpenStackStoragePoolRemoteDevInfo> remoteDevs) {
        this.remoteDevs = remoteDevs;
    }

    public void generateRemoteDevInfo() {
        OpenStackStoragePoolRemoteDevInfo remoteDev;
        String[] remoteInfos;
        if (null != this.remoteDevsStr && !this.remoteDevsStr.isEmpty()) {
            this.remoteDevs.clear();
            for (String dev : remoteInfos = this.remoteDevsStr.split(",")) {
                if (null == dev || dev.isEmpty()) continue;
                remoteDev = this.getRemoteDevInfo(dev);
                this.remoteDevs.add(remoteDev);
            }
        }
        if (null != this.remoteHypermetroDevsStr && !this.remoteHypermetroDevsStr.isEmpty()) {
            this.remoteHyperMetroDevs.clear();
            for (String dev : remoteInfos = this.remoteHypermetroDevsStr.split(",")) {
                if (null == dev || dev.isEmpty()) continue;
                remoteDev = this.getRemoteDevInfo(dev);
                this.remoteHyperMetroDevs.add(remoteDev);
            }
        }
    }

    private OpenStackStoragePoolRemoteDevInfo getRemoteDevInfo(String remoteInfo) {
        String[] devInfos = remoteInfo.split("#");
        OpenStackStoragePoolRemoteDevInfo remoteDev = new OpenStackStoragePoolRemoteDevInfo();
        block6: for (int i = 0; i < devInfos.length; ++i) {
            String value = "NA".equals(devInfos[i]) ? null : devInfos[i];
            switch (i) {
                case 0: {
                    remoteDev.setDevSn(value);
                    continue block6;
                }
                case 1: {
                    remoteDev.setDevWwn(value);
                    continue block6;
                }
                case 2: {
                    remoteDev.setLinkType(devInfos[i]);
                    continue block6;
                }
                case 3: {
                    remoteDev.setLinkType(remoteDev.getLinkType() + "#" + devInfos[i]);
                    continue block6;
                }
            }
        }
        return remoteDev;
    }

    private void getLocalInfo(String localInfo) {
        String[] localInfos = localInfo.split("#");
        for (int i = 0; i < localInfos.length; ++i) {
            if (i == 0) {
                this.localDevSn = localInfos[i];
                continue;
            }
            if (i != 1) continue;
            this.localDevWwn = localInfos[i];
        }
    }

    public String getRegionUuid() {
        return this.regionUuid;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public void setRegionUuid(String regionUuid) {
        this.regionUuid = regionUuid;
    }

    public void setProjectUuid(String projectUuid) {
        this.projectUuid = projectUuid;
    }

    public String getRemoteHypermetroDevsStr() {
        return this.remoteHypermetroDevsStr;
    }

    public void setRemoteHypermetroDevsStr(String remoteHypermetroDevsStr) {
        this.remoteHypermetroDevsStr = remoteHypermetroDevsStr;
    }

    public List<OpenStackStoragePoolRemoteDevInfo> getRemoteHyperMetroDevs() {
        return this.remoteHyperMetroDevs;
    }

    public void setRemoteHyperMetroDevs(List<OpenStackStoragePoolRemoteDevInfo> remoteHyperMetroDevs) {
        this.remoteHyperMetroDevs = remoteHyperMetroDevs;
    }
}

