/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice;

import com.huawei.ism.drm.cloudservice.rest.cloudservice.RedirectRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.FeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features.CsdrFeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features.CshaCsdrFeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features.CshaFeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features.SfsCsdrFeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features.VhaCsdrFeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features.VhaFeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.util.InstanceTypeConverter;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstanceService;
import com.huawei.ism.drm.openstack.sdk.service.ISfsServiceInstanceService;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

public class BaseCloudRestService
extends AbstractRestService {
    public static final String CLOUD_SEVICE_TYPE = "Cloud DR Service";
    public static final String CSHA = "csha";
    protected static final float EPSINON = 1.0E-5f;
    private static final Log logger = LogFactory.getInstance(BaseCloudRestService.class);
    private static final Map<Response.Status, String> STATUS_ERROR_CODE_MAP = new HashMap<Response.Status, String>();

    public User getCurrentUser() {
        String userName = this.getRequest().getHeader("x-auth-user");
        if (VerifyUtil.isEmpty((String)userName)) {
            userName = (String)this.getRequest().getAttribute("iam-x-auth-user");
        }
        User user = new User();
        user.setUserName(userName);
        return user;
    }

    protected String getUserJson() {
        String user = (String)this.getRequest().getAttribute("iam-x-auth-user-json");
        if (VerifyUtil.isEmpty((String)user)) {
            return super.getUserJson();
        }
        return user;
    }

    public Locale getLocale() {
        return Locale.ENGLISH;
    }

    protected Response getResponse(Response.Status status, JSONObject reponseBody) throws RestException {
        if (status.getStatusCode() != Response.Status.ACCEPTED.getStatusCode() && status.getStatusCode() != Response.Status.OK.getStatusCode()) {
            return this.wrong(status, reponseBody.toString());
        }
        Response.ResponseBuilder rb = Response.status((Response.Status)status);
        if (null != reponseBody) {
            rb.entity((Object)reponseBody.toString());
        }
        return rb.build();
    }

    protected Response getResponse(Response.Status status, String msg) throws RestException {
        if (status.getStatusCode() != Response.Status.ACCEPTED.getStatusCode() && status.getStatusCode() != Response.Status.OK.getStatusCode()) {
            return this.wrong(status, msg);
        }
        Response.ResponseBuilder rb = Response.status((Response.Status)status);
        JSONObject jsonObject = new JSONObject();
        String errorCode = STATUS_ERROR_CODE_MAP.get(status);
        if (null != errorCode) {
            jsonObject.put((Object)"error_code", (Object)errorCode);
        }
        if (null != msg && !msg.isEmpty()) {
            jsonObject.put((Object)"msg", (Object)msg);
        }
        if (jsonObject.isEmpty()) {
            return rb.build();
        }
        rb.type("application/json;charset=UTF-8");
        rb.entity((Object)jsonObject.toString());
        rb.language(this.getLocale());
        return rb.build();
    }

    protected String recordRequestLog(String msg) {
        String id = this.getRequestId();
        logger.info((Object)"%s :request is :(%s), msg is:(%s) ", new Object[]{id, this.getRequest().getPathInfo(), msg});
        return id;
    }

    private String getRequestId() {
        String id;
        Object value = this.getRequest().getAttribute("REQUEST_LOG_ID");
        if (value == null) {
            id = "req-" + UUIDGenerator.getUUID();
            this.getRequest().setAttribute("REQUEST_LOG_ID", (Object)id);
        } else {
            id = value.toString();
        }
        return id;
    }

    protected HttpServletRequest getHttpServletRequest() {
        return this.getRequest();
    }

    protected void recordResponseLog(String requestId, int httpCode, String msg) {
        logger.info((Object)"%s :response is %s, msg is %s", new Object[]{requestId, httpCode, msg});
    }

    protected void recordResponseLog(int httpCode, String msg) {
        String requestId = this.getRequestId();
        logger.info((Object)"%s :response is %s, msg is %s", new Object[]{requestId, httpCode, msg});
    }

    protected IServiceInstanceService getInstanceService() {
        return (IServiceInstanceService)this.getBundleService("DRM_FusionSphere_Openstack", IServiceInstanceService.class.getName(), IServiceInstanceService.class);
    }

    protected ISfsServiceInstanceService getSfsInstanceService() {
        return (ISfsServiceInstanceService)this.getBundleService("DRM_FusionSphere_Openstack", ISfsServiceInstanceService.class.getName(), ISfsServiceInstanceService.class);
    }

    protected IOpenstackResourceService getOpenstackResourceService() {
        return (IOpenstackResourceService)this.getBundleService("DRM_FusionSphere_Openstack", IOpenstackResourceService.class.getName(), IOpenstackResourceService.class);
    }

    protected IBackTaskService getBackTaskService() {
        return (IBackTaskService)this.getBundleService("task", "backTask");
    }

    protected IVolumeService getVolumeService() {
        return (IVolumeService)this.getBundleService("DRM_FusionSphere_Openstack", IVolumeService.class.getName(), IVolumeService.class);
    }

    protected <T extends RedirectRestService> T redirect(Class<T> clazz) {
        RedirectRestService instance = (RedirectRestService)((Object)BaseCloudRestService.create(clazz));
        if (instance == null) {
            logger.error((Object)("Failed to create instance for class " + clazz.getName()));
            throw new LegoCheckedException(0x300001L);
        }
        instance.setOrigin(this);
        return (T)((Object)instance);
    }

    protected FeatureRestService redirect(String instanceType, String objectType) {
        if (ServiceInstaceEnumDefine.ObjectType.SFS.getValue().equalsIgnoreCase(objectType)) {
            return this.redirectSfsService(instanceType);
        }
        return this.redirect(instanceType);
    }

    protected FeatureRestService redirectSfsService(String instanceType) {
        ServiceInstaceEnumDefine.ServiceInstanceTypeE type = InstanceTypeConverter.new2Enum(instanceType);
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.equals((Object)type)) {
            return this.redirect(SfsCsdrFeatureRestService.class);
        }
        throw new LegoCheckedException(1073947393L);
    }

    protected FeatureRestService redirect(String instanceType) {
        ServiceInstaceEnumDefine.ServiceInstanceTypeE type = InstanceTypeConverter.new2Enum(instanceType);
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.equals((Object)type)) {
            return this.redirect(CsdrFeatureRestService.class);
        }
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.equals((Object)type)) {
            return this.redirect(CshaFeatureRestService.class);
        }
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.equals((Object)type)) {
            return this.redirect(VhaFeatureRestService.class);
        }
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.equals((Object)type)) {
            return this.redirect(VhaCsdrFeatureRestService.class);
        }
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.CSHA_REPLICATION.equals((Object)type)) {
            return this.redirect(CshaCsdrFeatureRestService.class);
        }
        throw new LegoCheckedException(1073947393L);
    }

    protected Response wrong(Response.Status status, String message) throws RestException {
        logger.error((Object)message);
        this.recordResponseLog(status.getStatusCode(), message);
        throw new RestException(Long.parseLong(STATUS_ERROR_CODE_MAP.get(status)), message);
    }

    private static <T extends BaseCloudRestService> T create(Class<T> clazz) {
        BaseCloudRestService instance;
        try {
            instance = (BaseCloudRestService)((Object)clazz.newInstance());
        }
        catch (InstantiationException e) {
            instance = null;
            logger.error((Object)"create instance failed", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            instance = null;
            logger.error((Object)"create instance failed", (Throwable)e);
        }
        return (T)((Object)instance);
    }

    protected <E, T extends E> T convertSubClass(E base, Class<T> type) {
        return (T)JSONObject.toBean((JSONObject)JSONObject.fromObject(base), type);
    }

    static {
        STATUS_ERROR_CODE_MAP.put(Response.Status.UNAUTHORIZED, String.valueOf(1073947691L));
        STATUS_ERROR_CODE_MAP.put(Response.Status.FORBIDDEN, String.valueOf(1073947400L));
        STATUS_ERROR_CODE_MAP.put(Response.Status.NOT_FOUND, String.valueOf(1073947394L));
        STATUS_ERROR_CODE_MAP.put(Response.Status.CONFLICT, String.valueOf(1073948693L));
        STATUS_ERROR_CODE_MAP.put(Response.Status.INTERNAL_SERVER_ERROR, String.valueOf(-1L));
        STATUS_ERROR_CODE_MAP.put(Response.Status.BAD_REQUEST, String.valueOf(1073947393L));
    }
}

