/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features;

import com.huawei.ism.drm.cloudservice.bo.AddServersRequest;
import com.huawei.ism.drm.cloudservice.bo.CreateInstanceRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.FeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddServersRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddVolumeToVmRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsCreateInstanceRequest;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.ProtectedVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.ServerBO;
import com.huawei.ism.drm.openstack.sdk.bo.ServiceInstanceBO;
import com.huawei.ism.drm.openstack.sdk.bo.VmInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackAvailabilityZoneMapping;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;

public abstract class BaseHaFeatureRestService
extends FeatureRestService {
    private static final Log logger = LogFactory.getInstance(BaseHaFeatureRestService.class);

    @Override
    public Response queryAzPairs(String regionId) {
        return this.queryAzPairs(regionId, this.getInstanceType());
    }

    @Override
    public Response createServiceInstanceQuotasBudget(String projectId, CreateInstanceRequest request) throws RestException {
        String description;
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(request == null ? "" : request.getInstance().getName()));
        String reqId = this.recordRequestLog("projectid is " + projectId + "," + (request == null ? "" : request.toString()));
        if (VerifyUtil.isEmpty((String)projectId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Project_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "Project_id is empty.");
        }
        this.configSlaveAzName(request);
        if (!this.validateInstanceParam((BcsCreateInstanceRequest)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)request), BcsCreateInstanceRequest.class))) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "The request parameter is error.");
            return this.getResponse(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        String serviceInstanceName = request.getInstance().getName();
        if (!this.validateNameDesc(serviceInstanceName, description = request.getInstance().getDescription())) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "The instance's name or description parameter is error.");
            return this.getResponse(Response.Status.BAD_REQUEST, "The instance's name or description parameter is error.");
        }
        String type = request.getInstance().getType();
        if (!this.getInstanceType().getValue().equals(type)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Not support instance type.type=" + type);
            return this.getResponse(Response.Status.BAD_REQUEST, "Not support instance type.");
        }
        if (!this.validateStartPriority(request, reqId)) {
            return this.getResponse(Response.Status.BAD_REQUEST, "Param illeagle:");
        }
        try {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)type);
            ProtectGroup pg = this.convertInstanceBOToPg(request, projectId);
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            List list = this.getInstanceService().checkCreateInstanceParamAndCalQuota(pg, projectId, extendParam);
            JSONObject returnJson = this.getReturnJson(projectId, type, pg, list);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), "Request success.");
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"createServiceInstanceQuotasBudget failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"createServiceInstanceQuotasBudget failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private JSONObject getReturnJson(String projectId, String type, ProtectGroup pg, List<QuotaResourcesBo> list) {
        JSONObject returnJson = new JSONObject();
        String regionId = (String)pg.getProps().get("regionId");
        String protId = (String)pg.getProps().get("projectId");
        JSONArray array = this.constructQuotaResult(type, protId, regionId, null, null, list);
        String drAzid = (String)pg.getProps().get("drZoneName");
        array.add((Object)this.constructEvsQuota(drAzid, protId, regionId, list));
        returnJson.put((Object)"quotas", (Object)array);
        logger.debug((Object)"CreateServiceInstanceQuotasBudget: projectId= %s ,budget= %s", new Object[]{projectId, array});
        return returnJson;
    }

    @Override
    public Response createServiceInstance(String projectId, BcsCreateInstanceRequest request) throws RestException {
        String reqId = this.recordRequestLog("projectid is " + projectId + "," + (null == request ? "" : request.toString()));
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        this.configSlaveAzName(request);
        if (!this.validateInstanceParam(request)) {
            return this.wrong(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        String serviceInstanceName = request.getInstance().getName();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)serviceInstanceName);
        String description = request.getInstance().getDescription();
        if (!this.validateNameDesc(serviceInstanceName, description)) {
            return this.wrong(Response.Status.BAD_REQUEST, "The instance's name or description parameter is error.");
        }
        String type = request.getInstance().getType();
        if (!this.getInstanceType().getValue().equals(type)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Not support instance type.");
        }
        if (!this.validateStartPriority(request, reqId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Param illeagle:");
        }
        try {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)type);
            JSONObject json = this.getCreateInstanceJsonObject(projectId, request, reqId);
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"createServiceInstance failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"createServiceInstance failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    @Override
    public Response addServerQuotasBudget(String projectId, String instanceId, AddServersRequest request) throws RestException {
        String reqId = this.recordRequestLog("Projectid is " + projectId + ",instanceId is " + instanceId + "," + (null == request ? "" : request.toString()));
        try {
            VerifyUtil.checkObjs((Object[])new Object[]{projectId, instanceId, request});
        }
        catch (Exception e) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "parameters is empty.");
            logger.error((Object)"Parameters is empty:projectId=%s,instanceId=%s", new Object[]{projectId, instanceId});
            return this.getResponse(Response.Status.BAD_REQUEST, "Parameters is empty.");
        }
        if (VerifyUtil.isEmpty(request.getServers())) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Servers is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "Servers is empty.");
        }
        if (!this.validateServerParam(request.getServers(), null)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Servers param is not correct.");
            return this.getResponse(Response.Status.BAD_REQUEST, "Servers param is not correct.");
        }
        HashSet<ProtectObject> addPos = new HashSet<ProtectObject>();
        for (ServerBO server : request.getServers()) {
            ProtectObject po = this.convertServerBOToPo(server);
            addPos.add(po);
        }
        InstanceInfoBO instanceInfoBO = this.getInstanceInfoBO(projectId, instanceId);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            List list = this.getInstanceService().addServerToServiceInstanceAndCalQuota(projectId, instanceId, addPos, extendParam);
            JSONObject returnJson = new JSONObject();
            JSONArray array = this.constructAddVolumeToVmQuotasBudget(instanceInfoBO, list);
            returnJson.put((Object)"quotas", (Object)array);
            logger.debug((Object)"AddServerQuotasBudget: %s, projectId=%s", new Object[]{array, projectId});
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), "Request success.");
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"addServerQuotasBudget failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"addServerQuotasBudget failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private InstanceInfoBO getInstanceInfoBO(String projectId, String instanceId) {
        InstanceInfoBO instanceInfoBO;
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceId);
            throw e;
        }
        return instanceInfoBO;
    }

    @Override
    public Response addServer(String projectId, String instanceId, BcsAddServersRequest request) throws RestException {
        String reqId = this.recordRequestLog("Projectid is " + projectId + ",instanceId is " + instanceId + "," + (null == request ? "" : request.toString()));
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((Object)request)) {
            return this.wrong(Response.Status.BAD_REQUEST, "request is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)request.getSubscriptionId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "subscription_id is incorrect.");
        }
        if (VerifyUtil.isEmpty(request.getServers())) {
            return this.wrong(Response.Status.BAD_REQUEST, "servers is empty.");
        }
        if (!this.validateServerParam(request.getServers(), request.getSubscriptionId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "servers param is not correct.");
        }
        Set<ProtectObject> addPos = this.getProtectObjects(request);
        InstanceInfoBO instanceInfoBO = this.getInfoBO(projectId, instanceId);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(request.getSubscriptionId());
            String taskId = this.getInstanceService().addServerToServiceInstance(projectId, instanceId, addPos, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordSuccLog(reqId, instanceInfoBO, taskId);
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"addServer failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"addServer failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private void recordSuccLog(String reqId, InstanceInfoBO instanceInfoBO, String taskId) {
        this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "Accept request. task_id is " + taskId + ".");
    }

    private Set<ProtectObject> getProtectObjects(BcsAddServersRequest request) {
        HashSet<ProtectObject> addPos = new HashSet<ProtectObject>();
        for (ServerBO server : request.getServers()) {
            ProtectObject po = this.convertServerBOToPo(server);
            addPos.add(po);
        }
        return addPos;
    }

    private InstanceInfoBO getInfoBO(String projectId, String instanceId) {
        InstanceInfoBO instanceInfoBO;
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceId);
            throw e;
        }
        return instanceInfoBO;
    }

    @Override
    protected JSONArray constructAddVolumeToVmQuotasBudget(InstanceInfoBO instanceInfoBO, List<QuotaResourcesBo> list) {
        String proId = instanceInfoBO.getProjectId();
        String regionId = instanceInfoBO.getRegion();
        JSONArray array = this.constructQuotaResult(instanceInfoBO.getType(), proId, regionId, null, null, list);
        String drAzid = instanceInfoBO.getSalveAvailableZone();
        array.add((Object)this.constructEvsQuota(drAzid, proId, regionId, list));
        return array;
    }

    @Override
    public Response addVolumeToVm(String projectId, String instanceId, String serverId, BcsAddVolumeToVmRequest request) throws RestException {
        VmInfoBO vmInfoBO;
        InstanceInfoBO instanceInfoBO;
        HashSet<ProtectedVolumeInfo> addVolsSet;
        String reqId = this.recordRequestLog("Projectid is " + projectId + ",instanceId is " + instanceId + ",serverId is " + serverId + "," + (null == request ? "" : request.toString()));
        Response respParam = this.checkParameters(projectId, instanceId, serverId, request, reqId);
        if (null != respParam) {
            return respParam;
        }
        if (!ParamChecker.checkGeneralId((String)request.getSubscriptionId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "subscription_id is incorrect.");
        }
        List<VolumeBO> addVolList = request.getAddVols();
        Response respAddVol = this.dealAddVol(addVolList, addVolsSet = new HashSet<ProtectedVolumeInfo>(), reqId);
        if (null != respAddVol) {
            return respAddVol;
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            vmInfoBO = this.getInstanceService().queryServer(projectId, instanceId, serverId, false);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"addVolumeToVm failed.");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(request.getSubscriptionId());
            String taskId = this.getInstanceService().addVolumesToVm(projectId, instanceId, serverId, addVolsSet, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordSucLog(reqId, vmInfoBO, instanceInfoBO, taskId);
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"addVolumeToVm failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"addVolumeToVm failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private void recordSucLog(String reqId, VmInfoBO vmInfoBO, InstanceInfoBO instanceInfoBO, String taskId) {
        this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "Accept request. task_id is " + taskId + ".");
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_PARAM, (Object)new String[]{instanceInfoBO.getName()});
    }

    private void configSlaveAzName(CreateInstanceRequest request) {
        if (null == request) {
            return;
        }
        ServiceInstanceBO serviceInstance = request.getInstance();
        if (null == serviceInstance) {
            return;
        }
        String azName = serviceInstance.getAzName();
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA == this.getInstanceType()) {
            serviceInstance.setSlaveAzName(azName);
        }
        if (!VerifyUtil.isEmpty((String)azName) && VerifyUtil.isEmpty((String)serviceInstance.getSlaveAzName())) {
            OpenStackAvailabilityZoneMapping mapping = this.getOpenstackResourceService().getSlaveAzNameByAzPairInDB(azName);
            if (VerifyUtil.isEmpty((Object)mapping)) {
                return;
            }
            if (!VerifyUtil.isEmpty((String)mapping.getPrimaryAz()) && azName.equals(mapping.getPrimaryAz())) {
                serviceInstance.setSlaveAzName(mapping.getSecondAz());
            } else if (!VerifyUtil.isEmpty((String)mapping.getSecondAz()) && azName.equals(mapping.getSecondAz())) {
                serviceInstance.setSlaveAzName(mapping.getPrimaryAz());
            }
            request.setInstance(serviceInstance);
        }
    }

    private boolean validateInstanceParam(BcsCreateInstanceRequest request) {
        String subscriptionId = request.getSubscriptionId();
        if (!ParamChecker.checkGeneralId((String)subscriptionId)) {
            logger.error((Object)"subscription_id is incorrect.");
            return false;
        }
        ServiceInstanceBO serviceInstance = request.getInstance();
        if (null == serviceInstance) {
            return false;
        }
        if (VerifyUtil.isEmpty((String)serviceInstance.getSlaveAzName())) {
            logger.error((Object)"Doesn't have the slave az");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(serviceInstance.getName());
        attributes.add(serviceInstance.getAzName());
        attributes.add(serviceInstance.getRegionName());
        attributes.add(serviceInstance.getType());
        try {
            CommUtils.verifyParameterList(attributes);
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getAzName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getRegionName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getSlaveAzName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getRemoteProjectId())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getDrAvailableZone())) {
                throw new LegoCheckedException(1073947393L);
            }
        }
        catch (LegoCheckedException e) {
            String parameter = "Name=" + serviceInstance.getName() + ",azName=" + serviceInstance.getAzName() + ",regionName=" + serviceInstance.getRegionName() + ",slaveName=" + serviceInstance.getSlaveAzName() + ",type=" + serviceInstance.getType();
            logger.error((Object)("validateParam error. instance details:" + parameter), (Throwable)e);
            return false;
        }
        List servers = serviceInstance.getServers();
        return this.validateServerParam(servers, request.getSubscriptionId());
    }

    @Override
    protected boolean validateNameDesc(String name, String description) {
        if (!CommUtil.checkDrmDescParam((String)description)) {
            logger.error((Object)("ValidateNameDesc failed. description=" + description));
            return false;
        }
        if (!CommUtil.checkDrmNameParam((String)name)) {
            logger.error((Object)("ValidateNameDesc failed. name=" + name));
            return false;
        }
        return true;
    }

    @Override
    protected ProtectGroup convertInstanceBOToPg(CreateInstanceRequest request, String projectId) {
        ProtectGroup pg = new ProtectGroup();
        ServiceInstanceBO instance = request.getInstance();
        pg.setName(instance.getName());
        pg.setDescription(instance.getDescription());
        pg.setProperty("regionId", (Object)instance.getRegionName());
        pg.setProperty("projectId", (Object)projectId);
        pg.setProperty("zoneName", (Object)instance.getAzName());
        pg.setProperty("originalAvailableZone", (Object)instance.getAzName());
        pg.setProperty("drRegionId", (Object)instance.getRegionName());
        pg.setProperty("drProjectId", (Object)projectId);
        pg.setProperty("drZoneName", (Object)instance.getSlaveAzName());
        pg.setProperty("StartPriority", (Object)String.valueOf(request.getInstance().getStartPriority()));
        pg.setProperty("serviceInstanceType", (Object)this.getInstanceType().getValue());
        pg.setPoType(12);
        PolicyTemplate template = new PolicyTemplate();
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO == this.getInstanceType()) {
            template.setType(25);
        } else if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA == this.getInstanceType()) {
            template.setType(29);
        }
        pg.setTemplate(template);
        HashSet<ProtectObject> poList = new HashSet<ProtectObject>();
        if (VerifyUtil.isEmpty((Collection)instance.getServers())) {
            logger.error((Object)"Instance servers is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        for (ServerBO server : instance.getServers()) {
            ProtectObject po = this.convertServerBOToPo(server);
            poList.add(po);
        }
        pg.setPolist(poList);
        IUserMgr userMgr = (IUserMgr)ServiceContext.getInstance().lookup("user/usermgr");
        if (null == userMgr) {
            logger.error((Object)"Get user manager failed.");
            throw new LegoCheckedException(102410L);
        }
        User user = userMgr.getUserByName("admin");
        if (null == user) {
            logger.error((Object)"Get admin user failed.");
            throw new LegoCheckedException(1073947393L);
        }
        pg.setOwnerId(user.getUserId());
        return pg;
    }

    private boolean validateServerParam(List<ServerBO> servers, String subscriptionId) {
        try {
            CommUtils.isNullCollection(servers);
            if (servers.size() > 256) {
                logger.error((Object)"validateServerParam failed. Servers in request is more than 256");
                return false;
            }
            for (ServerBO server : servers) {
                if (CommUtils.isNullStr((String)server.getServerId())) {
                    logger.error((Object)"ValidateServerParam failed. serverId is null");
                    return false;
                }
                if (!ParamChecker.checkGeneralId((String)server.getServerId())) {
                    logger.error((Object)"validateServerParam failed. serverId is incorrect");
                    return false;
                }
                if (!VerifyUtil.isEmpty((String)subscriptionId) && this.getInstanceType() == ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO && CommUtils.isNullStr((String)server.getOccupiedServerId())) {
                    logger.error((Object)"ValidateServerParam failed. occupied ServerId is null");
                    return false;
                }
                if (!ParamChecker.checkGeneralId((String)server.getOccupiedServerId())) {
                    logger.error((Object)"validateServerParam failed. occupied ServerId is incorrect");
                    return false;
                }
                List volumes = server.getVolumes();
                CommUtils.isNullCollection((Collection)volumes);
                if (volumes.size() > 60) {
                    logger.error((Object)"volumes of server is more than 60");
                    return false;
                }
                for (VolumeBO volume : volumes) {
                    if (this.validateVolumeParam(volume)) continue;
                    String parameter = "VolumeId=" + volume.getVolumeId() + ",volumeType=" + volume.getVolumeType() + ",drVolumeType=" + volume.getDrVolumeType();
                    logger.error((Object)("ValidateServerParam failed. volume details=" + parameter));
                    return false;
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"ValidateServerParam error.", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateVolumeParam(VolumeBO volume) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(volume.getVolumeId());
        try {
            CommUtils.verifyParameterList(attributes);
            if (!ParamChecker.checkGeneralId((String)volume.getVolumeId())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkVolumeType((String)volume.getVolumeType())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkVolumeType((String)volume.getDrVolumeType())) {
                throw new LegoCheckedException(1073947393L);
            }
        }
        catch (LegoCheckedException e) {
            String parameter = "VolumeId=" + volume.getVolumeId() + ",volumeType=" + volume.getVolumeType() + ",drVolumeType=" + volume.getDrVolumeType();
            logger.error((Object)("ValidateServerParam error. volume details:" + parameter), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean validateStartPriority(CreateInstanceRequest request, String reqId) {
        String startPriority = request.getInstance().getStartPriority();
        try {
            if (!VerifyUtil.isEmpty((String)startPriority)) {
                if (5 < Integer.parseInt(startPriority) || 1 > Integer.parseInt(startPriority)) {
                    this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Param illeagle:" + startPriority);
                    return Boolean.FALSE;
                }
            } else {
                request.getInstance().setStartPriority(String.valueOf(3));
            }
        }
        catch (NumberFormatException e) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "param illeagle:" + startPriority);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Response downgradeServiceInstanceCheck(String projectId, String instanceId, String instanceType, String productId) {
        return null;
    }
}

