/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features;

import com.huawei.ism.drm.cloudservice.bo.AddServersRequest;
import com.huawei.ism.drm.cloudservice.bo.CreateInstanceRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.FeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsAddServersRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsCreateInstanceRequest;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.PolicyBO;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.ServerBO;
import com.huawei.ism.drm.openstack.sdk.bo.ServiceInstanceBO;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;

public class CsdrFeatureRestService
extends FeatureRestService {
    private static final Log logger = LogFactory.getInstance(CsdrFeatureRestService.class);

    @Override
    public Response queryAzPairs(String regionId) {
        return this.queryAzPairs(regionId, ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION);
    }

    private Response createServiceInstanceParamValidate(String projectId, CreateInstanceRequest request) throws RestException {
        String reqId = this.recordRequestLog("projectid is " + projectId + ", request: " + request);
        if (VerifyUtil.isEmpty((String)projectId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "project_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (null == request) {
            logger.error((Object)"request is null");
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "The request parameter is error.");
            return this.getResponse(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        if (!this.validateInstanceParam(request)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "The request parameter is error.");
            return this.getResponse(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        String description = request.getInstance().getDescription();
        if (!this.validateNameDesc(request.getInstance().getName(), description)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "The instance's name or description parameter is error.");
            return this.getResponse(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        String type = request.getInstance().getType();
        if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(type)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Not support instance type.type=" + type);
            return this.getResponse(Response.Status.BAD_REQUEST, "Not support instance type.");
        }
        String replicationType = request.getInstance().getReplicationType();
        if (!ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.SYNCHRONIZE.getValue().equals(replicationType) && !ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(replicationType)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Not support replication type.type=" + replicationType);
            return this.getResponse(Response.Status.BAD_REQUEST, "Not support replication type.");
        }
        return null;
    }

    @Override
    public Response createServiceInstanceQuotasBudget(String projectId, CreateInstanceRequest request) throws RestException {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(request == null ? "" : request.getInstance().getName()));
        Response error = this.createServiceInstanceParamValidate(projectId, request);
        if (error != null) {
            return error;
        }
        String replicationType = request.getInstance().getReplicationType();
        PolicyBO policy = request.getInstance().getPolicy();
        if (ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(replicationType) && !this.validatePolicy(policy)) {
            this.recordResponseLog(Response.Status.BAD_REQUEST.getStatusCode(), "Not set policy.");
            return this.getResponse(Response.Status.BAD_REQUEST, "Not set policy.");
        }
        String type = request.getInstance().getType();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)type);
        try {
            ProtectGroup pg = this.convertInstanceBOToPg(request, projectId);
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            List list = this.getInstanceService().checkCreateInstanceParamAndCalQuota(pg, projectId, extendParam);
            JSONObject returnJson = new JSONObject();
            String regionId = (String)pg.getProps().get("regionId");
            String protId = (String)pg.getProps().get("projectId");
            String drRegionId = (String)pg.getProps().get("drRegionId");
            String drProId = (String)pg.getProps().get("drProjectId");
            JSONArray array = this.constructQuotaResult(type, protId, regionId, drProId, drRegionId, list);
            String drAzid = (String)pg.getProps().get("drZoneName");
            array.add((Object)this.constructEvsQuota(drAzid, drProId, drRegionId, list));
            returnJson.put((Object)"quotas", (Object)array);
            logger.debug((Object)"createServiceInstanceQuotasBudget: %s", new Object[]{array});
            this.recordResponseLog(Response.Status.OK.getStatusCode(), "request success.");
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"createServiceInstanceQuotasBudget failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"createServiceInstanceQuotasBudget failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    protected Response validateCreateRequestParam(String projectId, CreateInstanceRequest request) throws RestException {
        String description;
        String subscriptionId;
        this.recordRequestLog("projectid is " + projectId + "," + (null == request ? "" : request.toString()));
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (request instanceof BcsCreateInstanceRequest && !ParamChecker.checkGeneralId((String)(subscriptionId = ((BcsCreateInstanceRequest)request).getSubscriptionId()))) {
            return this.wrong(Response.Status.BAD_REQUEST, "subscription_id is incorrect.");
        }
        if (null == request) {
            return this.wrong(Response.Status.BAD_REQUEST, "request is null.");
        }
        if (!this.validateInstanceParam(request)) {
            return this.wrong(Response.Status.BAD_REQUEST, "The request parameter is error.");
        }
        String serviceInstanceName = request.getInstance().getName();
        if (!this.validateNameDesc(serviceInstanceName, description = request.getInstance().getDescription())) {
            return this.wrong(Response.Status.BAD_REQUEST, "The instance's name or description parameter is error.");
        }
        String type = request.getInstance().getType();
        if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(type)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Not support instance type.");
        }
        String replicationType = request.getInstance().getReplicationType();
        if (!ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.SYNCHRONIZE.getValue().equals(replicationType) && !ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(replicationType)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Not support replication type.");
        }
        PolicyBO policy = request.getInstance().getPolicy();
        if (ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(replicationType) && !this.validatePolicy(policy)) {
            return this.wrong(Response.Status.BAD_REQUEST, "Not set policy.");
        }
        return this.getResponse(Response.Status.OK, "OK");
    }

    @Override
    public Response createServiceInstance(String projectId, BcsCreateInstanceRequest request) throws RestException {
        String reqId = this.recordRequestLog("projectid is " + projectId + "," + (null == request ? "" : request.toString()));
        Response response = this.validateCreateCsdrRequestParam(projectId, request);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            return response;
        }
        String serviceInstanceName = request.getInstance().getName();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)serviceInstanceName);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)request.getInstance().getType());
        try {
            JSONObject json = this.getCreateInstanceJsonObject(projectId, request, reqId);
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"createServiceInstance failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"createServiceInstance failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    @Override
    protected boolean validateInstanceParam(CreateInstanceRequest request) {
        ServiceInstanceBO serviceInstance = request.getInstance();
        if (null == serviceInstance) {
            return false;
        }
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(serviceInstance.getName());
        attributes.add(serviceInstance.getAzName());
        attributes.add(serviceInstance.getRegionName());
        attributes.add(serviceInstance.getSlaveAzName());
        attributes.add(serviceInstance.getSlaveRegionName());
        attributes.add(serviceInstance.getRemoteProjectId());
        attributes.add(serviceInstance.getType());
        attributes.add(serviceInstance.getReplicationType());
        try {
            CommUtils.verifyParameterList(attributes);
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getAzName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getRegionName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getSlaveAzName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getSlaveRegionName())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getRemoteProjectId())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkGeneralId((String)serviceInstance.getDrAvailableZone())) {
                throw new LegoCheckedException(1073947393L);
            }
        }
        catch (LegoCheckedException e) {
            String parameter = "name=" + serviceInstance.getName() + ",azName=" + serviceInstance.getAzName() + ",regionName=" + serviceInstance.getRegionName() + ",remoteProjectId=" + serviceInstance.getRemoteProjectId() + ",slaveName=" + serviceInstance.getSlaveAzName() + ",type=" + serviceInstance.getType() + ",type=" + serviceInstance.getReplicationType();
            logger.error((Object)("validateParam error. instance details:" + parameter), (Throwable)e);
            return false;
        }
        List servers = serviceInstance.getServers();
        return this.validateServerParam(servers);
    }

    @Override
    protected boolean validateVolumeParam(VolumeBO volume) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(volume.getVolumeId());
        attributes.add(volume.getVolumeType());
        try {
            CommUtils.verifyParameterList(attributes);
            if (!ParamChecker.checkGeneralId((String)volume.getVolumeId())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkVolumeType((String)volume.getVolumeType())) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!ParamChecker.checkVolumeType((String)volume.getDrVolumeType())) {
                throw new LegoCheckedException(1073947393L);
            }
        }
        catch (LegoCheckedException e) {
            String parameter = "volumeId=" + volume.getVolumeId() + ",volumeType=" + volume.getVolumeType();
            logger.error((Object)"ValidateServerParam error. volume details: %s", new Object[]{e, parameter});
            return false;
        }
        return true;
    }

    @Override
    public Response addServerQuotasBudget(String projectId, String instanceId, AddServersRequest request) throws RestException {
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + "," + (null == request ? "" : request.toString()));
        try {
            VerifyUtil.checkObjs((Object[])new Object[]{projectId, instanceId, request});
        }
        catch (Exception e) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "parameters is empty.");
            logger.error((Object)"parameters is empty:projectId=%s,instanceId=%s", new Object[]{projectId, instanceId});
            return this.getResponse(Response.Status.BAD_REQUEST, "parameters is empty");
        }
        if (VerifyUtil.isEmpty(request.getServers())) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "servers is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "servers is empty.");
        }
        if (!this.validateServerParam(request.getServers())) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "servers param is not correct.");
            return this.getResponse(Response.Status.BAD_REQUEST, "servers param is not correct.");
        }
        HashSet<ProtectObject> addPos = new HashSet<ProtectObject>();
        for (ServerBO server : request.getServers()) {
            ProtectObject po = this.convertServerBOToPo(server);
            addPos.add(po);
        }
        InstanceInfoBO instanceInfoBO = this.getInstanceInfoBO(projectId, instanceId);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            List list = this.getInstanceService().addServerToServiceInstanceAndCalQuota(projectId, instanceId, addPos, extendParam);
            JSONObject returnJson = new JSONObject();
            JSONArray array = this.constructAddVolumeToVmQuotasBudget(instanceInfoBO, list);
            returnJson.put((Object)"quotas", (Object)array);
            logger.debug((Object)"addServerQuotasBudget: %s", new Object[]{array});
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), "request success.");
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"addServerQuotasBudget failed");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"addServerQuotasBudget failed");
            throw new LegoCheckedException(-1L);
        }
    }

    private InstanceInfoBO getInstanceInfoBO(String projectId, String instanceId) {
        InstanceInfoBO instanceInfoBO;
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceId);
            throw e;
        }
        return instanceInfoBO;
    }

    @Override
    public Response addServer(String projectId, String instanceId, BcsAddServersRequest request) throws RestException {
        String reqId = this.recordRequestLog("projectid is " + projectId + ",instanceId is " + instanceId + "," + (null == request ? "" : request.toString()));
        if (VerifyUtil.isEmpty((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)projectId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)instanceId)) {
            return this.wrong(Response.Status.BAD_REQUEST, "project_id is incorrect.");
        }
        if (VerifyUtil.isEmpty((Object)request)) {
            return this.wrong(Response.Status.BAD_REQUEST, "request is empty.");
        }
        if (!ParamChecker.checkGeneralId((String)request.getSubscriptionId())) {
            return this.wrong(Response.Status.BAD_REQUEST, "subscription_id is incorrect.");
        }
        if (VerifyUtil.isEmpty(request.getServers())) {
            return this.wrong(Response.Status.BAD_REQUEST, "servers is empty.");
        }
        if (!this.validateServerParam(request.getServers())) {
            return this.wrong(Response.Status.BAD_REQUEST, "servers param is not correct.");
        }
        Set<ProtectObject> addPos = this.getProtectObjects(request);
        InstanceInfoBO instanceInfoBO = this.getInstanceInfoBO(projectId, instanceId);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(request.getSubscriptionId());
            String taskId = this.getInstanceService().addServerToServiceInstance(projectId, instanceId, addPos, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordSuccedLog(reqId, instanceInfoBO, taskId);
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"addServer failed");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"addServer failed");
            throw new LegoCheckedException(-1L);
        }
    }

    private Set<ProtectObject> getProtectObjects(BcsAddServersRequest request) {
        HashSet<ProtectObject> addPos = new HashSet<ProtectObject>();
        for (ServerBO server : request.getServers()) {
            ProtectObject po = this.convertServerBOToPo(server);
            addPos.add(po);
        }
        return addPos;
    }

    private void recordSuccedLog(String reqId, InstanceInfoBO instanceInfoBO, String taskId) {
        this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
        this.writeSucOperationLog("instance_server_add_operationname", 3, instanceInfoBO.getName(), null, new String[0], instanceInfoBO.getType());
    }

    @Override
    protected JSONArray constructAddVolumeToVmQuotasBudget(InstanceInfoBO instanceInfoBO, List<QuotaResourcesBo> list) {
        String proId = instanceInfoBO.getProjectId();
        String regionId = instanceInfoBO.getRegion();
        String drProId = instanceInfoBO.getRemoteProjectId();
        String drRegion = instanceInfoBO.getSlaveRegionName();
        JSONArray array = this.constructQuotaResult(instanceInfoBO.getType(), proId, regionId, drProId, this.getIdFromUuid(drRegion), list);
        String drAzid = instanceInfoBO.getSalveAvailableZone();
        array.add((Object)this.constructEvsQuota(drAzid, drProId, this.getIdFromUuid(drRegion), list));
        return array;
    }

    @Override
    public Response downgradeServiceInstanceCheck(String projectId, String instanceId, String instanceType, String productId) throws RestException {
        return null;
    }

    @Override
    public ServiceInstaceEnumDefine.ServiceInstanceTypeE getInstanceType() {
        return ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION;
    }
}

