/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features;

import com.huawei.ism.drm.cloudservice.bo.CreateInstanceRequest;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bcs.features.CsdrFeatureRestService;
import com.huawei.ism.drm.cloudservice.rest.cloudservice.bo.BcsCreateInstanceRequest;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.sdk.bo.ExtendParamInfo;
import com.huawei.ism.drm.openstack.sdk.bo.InstanceInfoBO;
import com.huawei.ism.drm.openstack.sdk.bo.QuotaResourcesBo;
import com.huawei.ism.drm.openstack.sdk.bo.ServerBO;
import com.huawei.ism.drm.openstack.sdk.bo.ServiceInstanceBO;
import com.huawei.ism.drm.openstack.sdk.bo.VolumeBO;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVolTypeMapping;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.rest.util.OperationLogAttrDefine;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;

public class VhaCsdrFeatureRestService
extends CsdrFeatureRestService {
    private static final Log logger = LogFactory.getInstance(VhaCsdrFeatureRestService.class);
    private static List<String> vhaQuotaTypes = new ArrayList<String>();

    @Override
    public Response queryAzPairs(String regionId) {
        return super.queryAzPairs(regionId, ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION);
    }

    @Override
    public Response createServiceInstanceQuotasBudget(String projectId, CreateInstanceRequest request) throws RestException {
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)(request == null ? "" : request.getInstance().getName()));
        String reqId = this.recordRequestLog("projectid is " + projectId + "," + (null == request ? "" : request.toString()));
        Response response = this.validateCreateCsdrRequestParam(projectId, request);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            return response;
        }
        ServiceInstanceBO instance = request.getInstance();
        String replicationType = instance.getReplicationType();
        if (!ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(replicationType)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Not support replication type.type=" + replicationType);
            return this.getResponse(Response.Status.BAD_REQUEST, "Not support replication type.");
        }
        String type = ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instance.getType());
        try {
            JSONObject returnJson = this.getJsonObject(projectId, request, type);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), "request success.");
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"createServiceInstanceQuotasBudget failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"createServiceInstanceQuotasBudget failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private JSONObject getJsonObject(String projectId, CreateInstanceRequest request, String type) {
        ProtectGroup pg = super.convertInstanceBOToPg(request, projectId);
        pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue());
        pg.getTemplate().setType(34);
        pg.setProperty("originalAvailableRegion", pg.getProps().get("regionId"));
        ExtendParamInfo extendParam = new ExtendParamInfo();
        extendParam.setCheck(true);
        List list = this.getInstanceService().checkCreateInstanceParamAndCalQuota(pg, projectId, extendParam);
        JSONObject returnJson = new JSONObject();
        String regionId = (String)pg.getProps().get("regionId");
        String protId = (String)pg.getProps().get("projectId");
        String drRegionId = (String)pg.getProps().get("drRegionId");
        String drProId = (String)pg.getProps().get("drProjectId");
        JSONArray array = this.constructQuotaResult(type, protId, regionId, drProId, drRegionId, list);
        String drAzid = (String)pg.getProps().get("drZoneName");
        String azid = (String)pg.getProps().get("zoneName");
        ArrayList<QuotaResourcesBo> csdrQuota = new ArrayList<QuotaResourcesBo>();
        ArrayList<QuotaResourcesBo> vhaQuota = new ArrayList<QuotaResourcesBo>();
        this.getCsdrAndVhaQuotaList(csdrQuota, vhaQuota, list);
        array.add((Object)this.constructEvsQuota(drAzid, drProId, this.getIdFromUuid(drRegionId), csdrQuota));
        array.add((Object)this.constructEvsQuota(azid, protId, this.getIdFromUuid(regionId), vhaQuota));
        returnJson.put((Object)"quotas", (Object)array);
        logger.debug((Object)"createServiceInstanceQuotasBudget: %s, projectId=%s", new Object[]{array, projectId});
        return returnJson;
    }

    @Override
    public Response createServiceInstance(String projectId, BcsCreateInstanceRequest request) throws RestException {
        String reqId = this.recordRequestLog("projectid is " + projectId + "," + (null == request ? "" : request.toString()));
        Response response = this.validateCreateCsdrRequestParam(projectId, request);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            return response;
        }
        String replicationType = request.getInstance().getReplicationType();
        if (!ServiceInstaceEnumDefine.ServiceInstanceReplicationTypeE.ASYNCHRONIZE.getValue().equals(replicationType)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "Not support replication type.type=" + replicationType);
            return this.getResponse(Response.Status.BAD_REQUEST, "Not support replication type.");
        }
        String serviceInstanceName = request.getInstance().getName();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)serviceInstanceName);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)request.getInstance().getType());
        try {
            ProtectGroup pg = this.checkAndBuildPg(projectId, request);
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(request.getSubscriptionId());
            String taskId = this.getInstanceService().createServiceInstance(pg, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"createServiceInstance failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"createServiceInstance failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private ProtectGroup checkAndBuildPg(String projectId, BcsCreateInstanceRequest request) {
        ProtectGroup pg = super.convertInstanceBOToPg(request, projectId);
        pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue());
        pg.getTemplate().setType(34);
        pg.setProperty("originalAvailableRegion", pg.getProps().get("regionId"));
        List volTypeMappings = this.getOpenstackResourceService().getVolTypeMappingsFromDB();
        String regionId = pg.getProperty("regionId");
        String zoneID = pg.getProperty("zoneName");
        String azId = regionId + "_@_" + zoneID;
        HashMap<String, String> vhaVolTypeMap = new HashMap<String, String>();
        for (OpenStackVolTypeMapping volTypeMapping : volTypeMappings) {
            if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getFrontValue().equals(volTypeMapping.getType()) || !volTypeMapping.getPrimaryAzId().equals(azId)) continue;
            vhaVolTypeMap.put(volTypeMapping.getPrimaryVolType(), volTypeMapping.getSecondVolType());
        }
        HashSet<ProtectObject> poList = new HashSet<ProtectObject>();
        if (VerifyUtil.isEmpty((Collection)request.getInstance().getServers())) {
            logger.error((Object)"Instance servers is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        for (ServerBO server : request.getInstance().getServers()) {
            ProtectObject po = this.convertServerBOToPo(server, vhaVolTypeMap);
            poList.add(po);
        }
        pg.setPolist(poList);
        return pg;
    }

    @Override
    public Response upgradeServerQuotasBudget(BcsCreateInstanceRequest request) {
        this.verifyInstance(request.getInstance());
        this.upgradeServiceInstance(request, true);
        String serviceInstanceName = request.getInstance().getName();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)serviceInstanceName);
        String projectId = request.getInstance().getProjectId();
        String reqId = this.recordRequestLog("projectid is " + projectId + "," + request.toString());
        String type = ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)type);
        try {
            JSONObject returnJson = this.getJsonObject(request, projectId, type);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), "request success.");
            return this.getResponse(Response.Status.OK, returnJson);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"createServiceInstance failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"createServiceInstance failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private JSONObject getJsonObject(BcsCreateInstanceRequest request, String projectId, String type) {
        List list;
        ProtectGroup pg = this.convertInstanceBOToPg(request, projectId);
        JSONObject returnJson = new JSONObject();
        String regionId = (String)pg.getProps().get("regionId");
        String protId = (String)pg.getProps().get("projectId");
        String drRegionId = (String)pg.getProps().get("drRegionId");
        String drProId = (String)pg.getProps().get("drProjectId");
        IQuotaService service = (IQuotaService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IQuotaService.class.getName(), IQuotaService.class);
        pg.setProperty("SERVICEINSTANCE_UUID", (Object)request.getInstance().getId());
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(request.getInstance().getType())) {
            pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue());
            pg.setProperty("BEFORE_UPGRADE_TYPE", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue());
            list = service.calculateCreateInstanceQuota(protId, pg);
            pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue());
        } else if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(request.getInstance().getType())) {
            pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue());
            pg.setProperty("BEFORE_UPGRADE_TYPE", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue());
            list = service.calculateCreateInstanceQuota(protId, pg);
            pg.setProperty("serviceInstanceType", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue());
        } else {
            logger.error((Object)"The type of instance is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        JSONArray array = this.constructQuotaResult(type, protId, regionId, drProId, drRegionId, list);
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(request.getInstance().getType())) {
            String azID = (String)pg.getProps().get("zoneName");
            array.add((Object)this.constructEvsQuota(azID, protId, regionId, list));
        } else {
            String drAzID = request.getInstance().getSlaveAzName();
            array.add((Object)this.constructEvsQuota(drAzID, drProId, drRegionId, list));
        }
        returnJson.put((Object)"quotas", (Object)array);
        logger.debug((Object)"createServiceInstanceQuotasBudget: %s", new Object[]{array});
        return returnJson;
    }

    private void verifyInstance(ServiceInstanceBO instanceBO) {
        String errorMsg = null;
        if (VerifyUtil.isEmpty((String)instanceBO.getAzName())) {
            errorMsg = "Instance available name is empty.";
        }
        if (!VerifyUtil.isEmpty((String)instanceBO.getDescription()) && instanceBO.getDescription().length() > 255) {
            errorMsg = "Instance description length error";
        }
        if (!VerifyUtil.isEmpty((String)instanceBO.getName()) && !this.checkInstanceName(instanceBO.getName())) {
            errorMsg = "Instance name match error";
        }
        if (VerifyUtil.isEmpty((String)instanceBO.getRegionName())) {
            errorMsg = "Instance region is empty.";
        }
        if (VerifyUtil.isEmpty((Collection)instanceBO.getServers())) {
            errorMsg = "Instance servers is empty.";
        }
        if (VerifyUtil.isEmpty((String)instanceBO.getType())) {
            errorMsg = "Instance type is empty.";
        }
        if (!VerifyUtil.isEmpty((String)errorMsg)) {
            logger.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private boolean checkInstanceName(String name) {
        if (4 > name.length() || 32 < name.length()) {
            return false;
        }
        Pattern pat = Pattern.compile("^[a-zA-Z0-9_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$");
        Matcher mat = pat.matcher(Normalizer.normalize(name, Normalizer.Form.NFKC));
        return mat.matches() && mat.find(0) && 0 <= mat.groupCount();
    }

    @Override
    public Response upgradeServiceInstance(BcsCreateInstanceRequest request, boolean isCheck) {
        String projectId = request.getInstance().getProjectId();
        String instanceId = request.getInstance().getId();
        String reqId = this.recordRequestLog("ProjectId is " + projectId + ",InstanceId is " + instanceId + "," + request.toString());
        String serviceInstanceName = request.getInstance().getName();
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)serviceInstanceName);
        this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)request.getInstance().getType());
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(request.getSubscriptionId());
            extendParam.setCheck(isCheck);
            ServiceInstanceBO serviceInstanceBO = request.getInstance();
            String taskId = this.getInstanceService().upgradeServiceInstanceTask(extendParam, serviceInstanceBO);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"upgradeServiceInstance failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"upgradeServiceInstance failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    private ProtectObject convertServerBOToPo(ServerBO server, Map<String, String> vhaVolTypeMap) {
        ProtectObject po = new ProtectObject();
        if (VerifyUtil.isEmpty((Object)server)) {
            logger.error((Object)"the serverBO is empty");
            throw new LegoCheckedException(1073947393L);
        }
        po.setMoUuid(server.getServerId());
        JSONArray array = new JSONArray();
        CommUtils.isNullCollection((Collection)server.getVolumes());
        for (VolumeBO volume : server.getVolumes()) {
            JSONObject json = new JSONObject();
            if (VerifyUtil.isEmpty((String)volume.getVolumeId())) {
                logger.error((Object)"Volume id is empty.");
                throw new LegoCheckedException(1073947393L);
            }
            json.put((Object)"volumeId", (Object)volume.getVolumeId());
            if (!VerifyUtil.isEmpty((String)volume.getDrVolumeType())) {
                json.put((Object)"drVolumeType", (Object)volume.getDrVolumeType());
            }
            if (!VerifyUtil.isEmpty((String)volume.getVolumeType())) {
                json.put((Object)"volumeType", (Object)volume.getVolumeType());
                json.put((Object)"drHyperVolumeType", (Object)vhaVolTypeMap.get(volume.getVolumeType()));
            }
            array.add((Object)json);
        }
        po.setProperty("volumeConfig", (Object)array.toString());
        po.setProperty("occupied_vm", (Object)server.getOccupiedServerId());
        return po;
    }

    @Override
    protected JSONArray constructAddVolumeToVmQuotasBudget(InstanceInfoBO instanceInfoBO, List<QuotaResourcesBo> list) {
        String proId = instanceInfoBO.getProjectId();
        String regionId = instanceInfoBO.getRegion();
        String drProId = instanceInfoBO.getRemoteProjectId();
        String drRegion = instanceInfoBO.getSlaveRegionName();
        String type = ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue();
        JSONArray array = this.constructQuotaResult(type, proId, regionId, drProId, this.getIdFromUuid(drRegion), list);
        String drAzid = instanceInfoBO.getSalveAvailableZone();
        String azid = instanceInfoBO.getAvailableZone();
        ArrayList<QuotaResourcesBo> csdrQuota = new ArrayList<QuotaResourcesBo>();
        ArrayList<QuotaResourcesBo> vhaQuota = new ArrayList<QuotaResourcesBo>();
        this.getCsdrAndVhaQuotaList(csdrQuota, vhaQuota, list);
        array.add((Object)this.constructEvsQuota(drAzid, drProId, this.getIdFromUuid(drRegion), csdrQuota));
        array.add((Object)this.constructEvsQuota(azid, proId, this.getIdFromUuid(regionId), vhaQuota));
        return array;
    }

    private void getCsdrAndVhaQuotaList(List<QuotaResourcesBo> csdrQuota, List<QuotaResourcesBo> vhaQuota, List<QuotaResourcesBo> list) {
        for (QuotaResourcesBo quotaResourcesBo : list) {
            if (vhaQuotaTypes.contains(quotaResourcesBo.getType())) {
                vhaQuota.add(quotaResourcesBo);
                continue;
            }
            csdrQuota.add(quotaResourcesBo);
        }
    }

    @Override
    public Response deleteServiceInstanceCheck(String projectId, String instanceId) throws RestException {
        String reqId = this.recordRequestLog("projectId is " + projectId + "instanceId is " + instanceId);
        if (VerifyUtil.isEmpty((String)projectId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "project_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "instance_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        try {
            InstanceInfoBO instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"deleteServiceInstanceCheck failed.");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            String result = this.getInstanceService().deleteServiceInstance(projectId, instanceId, extendParam);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), result);
            return this.getResponse(Response.Status.OK, "quota check success");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"deleteServiceInstanceCheck failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"deleteServiceInstanceCheck failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    @Override
    public Response deleteServiceInstance(String projectId, String instanceId, String subscriptionId) throws RestException {
        InstanceInfoBO instanceInfoBO;
        String reqId = this.recordRequestLog("projectId is " + projectId + "instanceId is " + instanceId);
        if (VerifyUtil.isEmpty((String)projectId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "project_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "instance_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        try {
            instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceId);
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(subscriptionId);
            String taskId = this.getInstanceService().deleteServiceInstance(projectId, instanceId, extendParam);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"deleteServiceInstance failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"deleteServiceInstance failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    @Override
    public Response downgradeServiceInstanceCheck(String projectId, String instanceId, String instanceType, String productId) throws RestException {
        String reqId = this.recordRequestLog("projectId is " + projectId + "instanceId is " + instanceId + "instanceType is " + instanceType);
        if (VerifyUtil.isEmpty((String)projectId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "project_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "instance_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceType)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "instance_type is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "instance_type is empty.");
        }
        try {
            InstanceInfoBO instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"downgradeServiceInstanceCheck failed.");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setCheck(true);
            extendParam.setReservedInsType(instanceType);
            String result = this.getInstanceService().downgradeServiceInstance(projectId, instanceId, extendParam, productId);
            this.recordResponseLog(reqId, Response.Status.OK.getStatusCode(), result);
            return this.getResponse(Response.Status.OK, "quota check success");
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"downgradeServiceInstanceCheck failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"downgradeServiceInstanceCheck failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    @Override
    public Response downgradeServiceInstance(String projectId, String instanceId, String instanceType, String subscriptionId, String productId) throws RestException {
        String reqId = this.recordRequestLog("projectId is " + projectId + "instanceId is " + instanceId + "instanceType is " + instanceType);
        if (VerifyUtil.isEmpty((String)projectId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "project_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "project_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceId)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "instance_id is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "instance_id is empty.");
        }
        if (VerifyUtil.isEmpty((String)instanceType)) {
            this.recordResponseLog(reqId, Response.Status.BAD_REQUEST.getStatusCode(), "instance_type is empty.");
            return this.getResponse(Response.Status.BAD_REQUEST, "instance_type is empty.");
        }
        try {
            InstanceInfoBO instanceInfoBO = this.getInstanceService().queryServiceInstance(projectId, instanceId, null);
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_TARGET, (Object)instanceInfoBO.getName());
            this.getRequest().setAttribute(OperationLogAttrDefine.OPERATION_LOG_SERVICE_TYPE, (Object)instanceInfoBO.getType());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"downgradeServiceInstance failed.");
            throw e;
        }
        try {
            ExtendParamInfo extendParam = new ExtendParamInfo();
            extendParam.setSubscriptionId(subscriptionId);
            extendParam.setReservedInsType(instanceType);
            String taskId = this.getInstanceService().downgradeServiceInstance(projectId, instanceId, extendParam, productId);
            JSONObject json = new JSONObject();
            json.put((Object)"task_id", (Object)taskId);
            this.recordResponseLog(reqId, Response.Status.ACCEPTED.getStatusCode(), "accept request. task_id is " + taskId + ".");
            return this.getResponse(Response.Status.ACCEPTED, json);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"downgradeServiceInstance failed.");
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"downgradeServiceInstance failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    @Override
    public ServiceInstaceEnumDefine.ServiceInstanceTypeE getInstanceType() {
        return ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION;
    }

    @Override
    protected JSONArray constructQuotaResult(String type, String projectId, String regionId, String drProjectId, String drRegionId, List<QuotaResourcesBo> list) {
        if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(type)) {
            logger.error((Object)("type is not support , constructQuotaResult failed , type:" + type));
            throw new LegoCheckedException(1073947393L);
        }
        JSONArray csdrQuotaResourceList = new JSONArray();
        JSONArray vhaQuotaResourceList = new JSONArray();
        for (QuotaResourcesBo bo : list) {
            if ("gigabytes".equals(bo.getType()) || "volumes".equals(bo.getType())) continue;
            this.getCsdrQuotaResourceList(csdrQuotaResourceList, bo);
            this.getVhaQuotaResourceList(vhaQuotaResourceList, bo);
        }
        JSONArray usagesList = new JSONArray();
        JSONObject csdrUsage = new JSONObject();
        if (!VerifyUtil.isEmpty((Collection)csdrQuotaResourceList)) {
            csdrUsage.put((Object)"resources", (Object)csdrQuotaResourceList);
            csdrUsage.put((Object)"service_id", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getFrontValue());
            usagesList.add((Object)csdrUsage);
        }
        if (!VerifyUtil.isEmpty((Collection)vhaQuotaResourceList)) {
            JSONObject vhaUsage = new JSONObject();
            vhaUsage.put((Object)"resources", (Object)vhaQuotaResourceList);
            vhaUsage.put((Object)"service_id", (Object)ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getFrontValue());
            usagesList.add((Object)vhaUsage);
        }
        JSONArray quotas = new JSONArray();
        if (!VerifyUtil.isEmpty((Collection)usagesList)) {
            JSONObject quota = new JSONObject();
            quota.put((Object)"project_id", (Object)projectId);
            quota.put((Object)"region_id", (Object)regionId);
            quota.put((Object)"usages", (Object)usagesList);
            quotas.add((Object)quota);
        }
        if (null != drProjectId && !VerifyUtil.isEmpty((Map)csdrUsage)) {
            JSONObject drQuota = new JSONObject();
            drQuota.put((Object)"project_id", (Object)drProjectId);
            drQuota.put((Object)"region_id", (Object)drRegionId);
            JSONArray drUsagesList = new JSONArray();
            drUsagesList.add((Object)csdrUsage);
            drQuota.put((Object)"usages", (Object)drUsagesList);
            quotas.add((Object)drQuota);
        }
        return quotas;
    }

    private void getVhaQuotaResourceList(JSONArray vhaQuotaResourceList, QuotaResourcesBo bo) {
        if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(this.getInstanceType().getValue())) {
            return;
        }
        ArrayList<String> vhaMeterTypes = new ArrayList<String>();
        vhaMeterTypes.add("vha.vol.size");
        vhaMeterTypes.add("vha.vol.num");
        vhaMeterTypes.add("vha.instance.num");
        this.addQuotaResource(vhaQuotaResourceList, bo, vhaMeterTypes);
    }

    private void getCsdrQuotaResourceList(JSONArray csdrQuotaResourceList, QuotaResourcesBo bo) {
        if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.getValue().equals(this.getInstanceType().getValue())) {
            return;
        }
        ArrayList<String> csdrMeterTypes = new ArrayList<String>();
        csdrMeterTypes.add("csdr.instance.num");
        csdrMeterTypes.add("csdr.vol.num");
        csdrMeterTypes.add("csdr.vol.size");
        this.addQuotaResource(csdrQuotaResourceList, bo, csdrMeterTypes);
    }

    private void addQuotaResource(JSONArray quotaResourceList, QuotaResourcesBo bo, List<String> csdrMeterTypes) {
        if (csdrMeterTypes.contains(bo.getType())) {
            JSONObject quotaResource = new JSONObject();
            quotaResource.put((Object)"resource", (Object)bo.getType());
            quotaResource.put((Object)"used", (Object)Float.valueOf(bo.getQuota()));
            quotaResourceList.add((Object)quotaResource);
        }
    }

    static {
        vhaQuotaTypes.add("vha.instance.num");
        vhaQuotaTypes.add("vha.vol.size");
        vhaQuotaTypes.add("vha.vol.num");
    }
}

