/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cloudservice.web.security;

import com.huawei.ism.drm.cloudservice.rest.cloudservice.util.ReflectUtil;
import com.huawei.ism.drm.cloudservice.web.security.ScopeCheck;
import com.huawei.ism.drm.openstack.sdk.bo.TokenBo;
import com.huawei.ism.drm.openstack.sdk.service.IAuthenticationService;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class CloudServiceRestInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String IAM_X_AUTH_USER = "iam-x-auth-user";
    private static final Log logger = LogFactory.getInstance(CloudServiceRestInterceptor.class);

    public CloudServiceRestInterceptor() {
        super("pre-invoke");
    }

    public void handleMessage(Message message) {
        Map<String, Object> headers = this.getHeaders(message);
        List account = (List)headers.get("x-auth-token");
        if (null == account || account.isEmpty()) {
            logger.error((Object)"x-auth-token is empty");
            this.recordAccessLog(message, "--", "Request faild because of none auth info.");
            throw this.initFault(1073947691L, Response.Status.UNAUTHORIZED.getStatusCode());
        }
        TokenBo token = this.getTokenBo(message, (String)account.get(0));
        this.checkTokenValid(message, token);
        TokenBo.TokenUser tokenUser = token.getUser();
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (request == null) {
            logger.error((Object)"Failed to get http servlet request");
            throw new LegoCheckedException(0x300001L);
        }
        request.setAttribute(IAM_X_AUTH_USER, (Object)tokenUser.getName());
        request.setAttribute("auth-token", account.get(0));
        JSONObject iamUser = new JSONObject();
        iamUser.put((Object)"id", (Object)tokenUser.getId());
        iamUser.put((Object)"name", (Object)tokenUser.getName());
        iamUser.put((Object)"domain", (Object)tokenUser.getDomain());
        TokenBo.AssumedBy assumedBy = token.getAssumedBy();
        if (!VerifyUtil.isEmpty((Object)assumedBy) && !VerifyUtil.isEmpty((Object)assumedBy.getUser())) {
            iamUser.put((Object)"assumed_by", (Object)assumedBy);
            request.setAttribute(IAM_X_AUTH_USER, (Object)assumedBy.getUser().getName());
        }
        request.setAttribute("iam-x-auth-user-json", (Object)iamUser.toString());
        if (token.getProject() != null) {
            request.setAttribute("iam-x-auth-user-project", (Object)token.getProject().getId());
        }
    }

    private TokenBo getTokenBo(Message message, String tokenStr) {
        IAuthenticationService service = (IAuthenticationService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IAuthenticationService.class.getName(), IAuthenticationService.class);
        try {
            return service.decodeToken(tokenStr);
        }
        catch (Exception e) {
            this.recordAccessLog(message, "--", "Request failed because of decode token info.");
            throw this.initFault(1073947691L, Response.Status.UNAUTHORIZED.getStatusCode());
        }
    }

    private void checkTokenValid(Message message, TokenBo token) {
        String uri = (String)message.get((Object)"org.apache.cxf.request.uri");
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        IAuthenticationService service = (IAuthenticationService)ServiceLocator.getBundleService((String)"DRM_FusionSphere_Openstack", (String)IAuthenticationService.class.getName(), IAuthenticationService.class);
        if (!service.checkAuth(token, uri, method) || !this.checkScope(message, token)) {
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog((String)service.getOperationName(uri, method), (String)token.getUser().getName(), (Integer)service.getLogLevel(uri, method), (String)"lego.err.1073947400", (String)"", (String)RequestUtil.getClientIpAddress((Message)message));
            SysOpLogBuilder.writeOperateLog((SysOptLog)sysOptLog);
            throw new LegoCheckedException(1073947400L);
        }
    }

    private boolean checkScope(Message message, TokenBo token) {
        MessageContentsList parameters = MessageContentsList.getContentsList((Message)message);
        if (parameters == null) {
            logger.error((Object)"Parameters is null");
            return false;
        }
        Exchange exchange = message.getExchange();
        OperationResourceInfo operationResourceInfo = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        if (operationResourceInfo == null) {
            logger.error((Object)"Failed to get operation resource info");
            throw new LegoCheckedException(0x300001L);
        }
        Method method = operationResourceInfo.getMethodToInvoke();
        Annotation[][] annotations = method.getParameterAnnotations();
        return this.checkScope(parameters, annotations, token);
    }

    private boolean checkScope(MessageContentsList parameters, Annotation[][] annotations, TokenBo token) {
        int length = Math.min(parameters.size(), annotations.length);
        for (int i = 0; i < length; ++i) {
            ScopeCheck scopeCheck = this.getScopeCheck(annotations[i]);
            if (scopeCheck == null || this.checkScope(parameters.get(i), scopeCheck.value(), token)) continue;
            logger.error((Object)"parameter %s: check scope failed", new Object[]{String.valueOf(i)});
            return false;
        }
        return true;
    }

    private boolean checkScope(Object parameter, String path, TokenBo token) {
        List<Object> values = ReflectUtil.getValues(parameter, path);
        for (Object e : values) {
            if (token.getProject().getId().equals(e)) continue;
            logger.error((Object)"Expect: %s, actual: %s", new Object[]{token.getProject().getId(), e});
            return false;
        }
        return true;
    }

    private ScopeCheck getScopeCheck(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof ScopeCheck)) continue;
            return (ScopeCheck)annotation;
        }
        return null;
    }

    private Fault initFault(long errorcode, int statusCode) {
        RestException exception = new RestException(errorcode);
        Fault ftVerify = new Fault((Throwable)exception);
        ftVerify.setFaultCode(Fault.FAULT_CODE_CLIENT);
        ftVerify.setStatusCode(statusCode);
        return ftVerify;
    }

    private Map<String, Object> getHeaders(Message message) {
        Message mess = message.getExchange().getInMessage();
        return (TreeMap)mess.get((Object)Message.PROTOCOL_HEADERS);
    }

    private void recordAccessLog(Message message, String userNmae, String msg) {
        Message mess = message.getExchange().getInMessage();
        String clientIpAddress = RequestUtil.getClientIpAddress((Message)message);
        String requestMethod = (String)mess.get((Object)"org.apache.cxf.request.method");
        String operationMethod = (String)message.getContextualProperty("org.apache.cxf.resource.operation.name");
        String pathInfo = (String)mess.get((Object)"org.apache.cxf.message.Message.BASE_PATH");
        StringBuilder sblog = new StringBuilder("client:");
        sblog.append(clientIpAddress);
        sblog.append(", user:");
        sblog.append(userNmae);
        sblog.append(", request method:");
        sblog.append(requestMethod);
        sblog.append(", request pathInfo:");
        sblog.append(pathInfo);
        sblog.append(", operation method:");
        sblog.append(operationMethod);
        sblog.append(".");
        if (!VerifyUtil.isEmpty((String)msg)) {
            sblog.append("msg:");
            sblog.append(msg);
        }
        logger.info((Object)sblog.toString());
    }
}

