/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.common;

public enum InnerSymmAlgorithm {
    UNKNOWN_ALGORITHM("UNKNOWN_ALGORITHM", 0),
    AES128_CBC("AES128_CBC", 5),
    AES256_CBC("AES256_CBC", 7),
    AES128_GCM("AES128_GCM", 8),
    AES256_GCM("AES256_GCM", 9),
    SM4_CBC("SM4_CBC", 10),
    SM4_CTR("SM4_CTR", 11);

    private String innerSymmAlg;
    private int value;

    private InnerSymmAlgorithm(String innerSymmAlg, int value) {
        this.innerSymmAlg = innerSymmAlg;
        this.value = value;
    }

    public static InnerSymmAlgorithm searchByName(String name) {
        if (name.isEmpty()) {
            return UNKNOWN_ALGORITHM;
        }
        InnerSymmAlgorithm algTemp = null;
        try {
            algTemp = InnerSymmAlgorithm.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            algTemp = UNKNOWN_ALGORITHM;
        }
        return algTemp != null ? algTemp : UNKNOWN_ALGORITHM;
    }

    public String getInnerSymmAlg() {
        return this.innerSymmAlg;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return "**not support toString**";
    }
}

