/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.base;

import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.IAppManager;
import com.huawei.lego.core.sdk.base.event.IStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.AppInfo;
import com.huawei.lego.core.sdk.base.model.ServiceInfo;
import com.huawei.lego.core.sdk.base.service.AppServiceHelperFactory;
import com.huawei.lego.core.sdk.base.service.IAppServiceHelper;
import com.huawei.lego.core.sdk.base.service.LocalAppServiceHelper;
import com.huawei.lego.core.sdk.base.service.RemoteAppServiceHelper;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.remoting.RemoteConnectFailureException;

public final class ServiceContext {
    private static final Log LOG = LogFactory.getInstance(ServiceContext.class);
    public static final String KEY_CONTEXT_USER = "key.context.user";
    public static final String KEY_CONTEXT_LOCALIZE = "key.context.localize";
    private static final String KEY_APPMANAGER_SERVER = "base.appmanager_server";
    private static final int VALUE_2 = 2;
    private static ServiceContext context;
    private static Object sLock;
    private ApplicationContext bContext = null;
    private IAppManager appManager = null;
    private boolean hasRegister = false;
    private String userDefIP = null;
    private String userDefPort = null;
    private List<IStatusChangedListener> listeners = new ArrayList<IStatusChangedListener>();

    private ServiceContext() {
    }

    public void setbContext(ApplicationContext applicationContext) {
        this.bContext = applicationContext;
    }

    public void setServiceEventListener(List<IStatusChangedListener> listenersParam) {
        this.listeners = listenersParam;
    }

    public List<IStatusChangedListener> getListeners() {
        return this.listeners;
    }

    private synchronized void initlizer(ApplicationContext bundleContext) {
        String appManagerIP = "";
        appManagerIP = this.userDefIP != null ? this.userDefIP : LegoProperties.getProperty(KEY_APPMANAGER_SERVER, "127.0.0.1");
        LOG.debug((Object)String.format(Locale.ENGLISH, "AppManager Server IP : %s.", appManagerIP), 200L);
        boolean isLocal = AddressUtil.checkLocalIP(appManagerIP);
        if (null == bundleContext) {
            isLocal = false;
        }
        IAppServiceHelper helper = AppServiceHelperFactory.getAppServiceQuery(isLocal);
        AppInfo info = new AppInfo();
        info.setAppName("appManager");
        info.setIp(appManagerIP);
        info.setPort(this.userDefPort != null ? NumberUtil.convertToInteger(this.userDefPort) : LegoProperties.getPort());
        ServiceInfo model = new ServiceInfo();
        model.setName("appManager");
        model.setInterfaceName(IAppManager.class.getName());
        model.setApp(info);
        LOG.debug((Object)String.format(Locale.ENGLISH, "AppManager Info : %s.", info), 200L);
        this.appManager = (IAppManager)helper.query(bundleContext, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceContext getInstance() {
        Object object = sLock;
        synchronized (object) {
            if (null == context) {
                context = new ServiceContext();
            }
            return context;
        }
    }

    public synchronized void register(AppInfo info) {
        if (!this.hasRegister) {
            this.initlizer(this.bContext);
            this.hasRegister = true;
        }
        LocalAppServiceHelper localHelper = new LocalAppServiceHelper();
        localHelper.register(this.bContext, info);
        RemoteAppServiceHelper remoteHelper = new RemoteAppServiceHelper();
        remoteHelper.register(this.bContext, info);
        try {
            this.appManager.add(info);
        }
        catch (RemoteConnectFailureException e) {
            this.initlizer(this.bContext);
            this.appManager.add(info);
        }
    }

    public synchronized void remove(ApplicationContext bundleContext, AppInfo info) {
        if (null == this.appManager) {
            this.initlizer(bundleContext);
        }
        try {
            this.appManager.remove(info.getAppName());
        }
        catch (RemoteConnectFailureException e) {
            this.initlizer(bundleContext);
            this.appManager.remove(info.getAppName());
        }
    }

    private Object lookup(ApplicationContext bundleContext, String name, Map cText) {
        if (null == this.appManager) {
            this.initlizer(bundleContext);
            if (null == this.appManager) {
                LOG.error((Object)"lookup service : null appManager", 200L);
                return null;
            }
        }
        ServiceInfo info = null;
        try {
            info = cText != null ? this.appManager.queryService(name, cText) : this.appManager.queryService(name);
        }
        catch (RemoteConnectFailureException e) {
            info = this.reInit(bundleContext, name, cText);
            LOG.error((Object)("lookup service : " + name + ", but the service is exist!"), (Throwable)e, 200L);
        }
        if (null == info) {
            LOG.error((Object)("lookup service : null info:" + name), 200L);
            return null;
        }
        Object obj = this.queryService(bundleContext, info);
        return obj;
    }

    private Object queryService(ApplicationContext bundleContext, ServiceInfo info) {
        boolean isLocal = AddressUtil.checkLocalIP(info.getApp().getIp());
        if (bundleContext == null) {
            isLocal = false;
        }
        IAppServiceHelper helper = AppServiceHelperFactory.getAppServiceQuery(isLocal);
        Object obj = null;
        obj = helper.query(bundleContext, info);
        return obj;
    }

    private ServiceInfo reInit(ApplicationContext bundleContext, String name, Map cText) {
        ServiceInfo info = null;
        this.initlizer(bundleContext);
        try {
            info = cText != null ? this.appManager.queryService(name, cText) : this.appManager.queryService(name);
        }
        catch (RemoteConnectFailureException e1) {
            LOG.error((Object)"Can not connect the remote server!", (Throwable)e1, 200L);
        }
        return info;
    }

    public Object lookup(ApplicationContext bundleContext, String name) {
        return this.lookup(bundleContext, name, null);
    }

    private void initUserDefNetContext(String addrCtx) {
        String[] netCtx = addrCtx.split(":");
        if (netCtx != null && netCtx.length == 2) {
            this.userDefIP = netCtx[0];
            this.userDefPort = netCtx[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String addrCtx, String name) {
        Object reValue = null;
        try {
            this.initUserDefNetContext(addrCtx);
            reValue = this.lookup(this.bContext, name);
        }
        catch (Exception e) {
            LOG.error((Object)ExceptionUtil.getErrorMessage(e), 200L);
        }
        finally {
            this.userDefIP = null;
            this.userDefPort = null;
        }
        return reValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(String addrCtx, String name, Map cText) {
        Object reValue = null;
        try {
            this.initUserDefNetContext(addrCtx);
            reValue = this.lookup(name, cText);
        }
        catch (Exception e) {
            LOG.error((Object)ExceptionUtil.getErrorMessage(e), 200L);
        }
        finally {
            this.userDefIP = null;
            this.userDefPort = null;
        }
        return reValue;
    }

    public Object lookup(String name) {
        return this.lookup(this.bContext, name);
    }

    public Object lookup(Class clazz) {
        Map map = this.bContext.getBeansOfType(clazz);
        if (map != null && !map.isEmpty()) {
            Collection valueSet = map.values();
            ArrayList valueList = new ArrayList(valueSet);
            return valueList.get(0);
        }
        return null;
    }

    public <T> List<T> lookupBeans(Class<T> clazz) {
        Map map = this.bContext.getBeansOfType(clazz);
        if (null != map && !map.isEmpty()) {
            Collection valueSet = map.values();
            return new ArrayList(valueSet);
        }
        return null;
    }

    public Object lookup(String name, Map cText) {
        return this.lookup(this.bContext, name, cText);
    }

    @Deprecated
    public Object lookup(String name, User userParam) {
        HashMap<String, User> ctext = new HashMap<String, User>();
        ctext.put(KEY_CONTEXT_USER, userParam);
        return this.lookup(name, ctext);
    }

    static {
        sLock = new Object();
    }
}

