/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.file.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class AdapterUtils {
    private static final Log LOGGER = LogFactory.getInstance(AdapterUtils.class);
    private static final int ONE = 1;
    private static final int FOUR = 4;
    private static final int SIX = 6;

    public static boolean isNullStr(String str) {
        return str == null || str.length() == 0;
    }

    public static ClassLoader getClassLoader(Class className) {
        ClassLoader classLoader = null;
        if (null != className) {
            classLoader = className.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = AdapterUtils.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = AdapterUtils.class.getClassLoader();
        }
        return classLoader;
    }

    public static List<URL> getClassPathEntries(String packageFileName) {
        int index = packageFileName.lastIndexOf("/");
        String classpath = "";
        String fileName = "";
        if (index > 0) {
            classpath = packageFileName.substring(0, index);
            fileName = packageFileName.substring(index + 1, packageFileName.length());
        }
        return AdapterUtils.getClassPathEntries(classpath, fileName);
    }

    public static List<URL> getAllClassPathEntries(String packageFileName) {
        int index = packageFileName.lastIndexOf("/");
        String classpath = "";
        String fileName = "";
        if (index >= 0) {
            classpath = packageFileName.substring(0, index);
            fileName = packageFileName.substring(index + 1, packageFileName.length());
        }
        return AdapterUtils.getAllClassPathEntries(classpath, fileName);
    }

    public static String getClassJarPath(Class tClass) {
        String jarfileName = null;
        String path = AdapterUtils.getClassPath(tClass);
        ClassLoader classLoader = tClass.getClassLoader();
        if (null == classLoader) {
            LOGGER.error("get class loader error!");
            return jarfileName;
        }
        URL url = classLoader.getResource(path);
        while (url == null) {
            tClass = tClass.getSuperclass();
            path = AdapterUtils.getClassPath(tClass);
            url = classLoader.getResource(path);
        }
        jarfileName = url.getFile();
        jarfileName = jarfileName.replaceAll(path, "");
        return jarfileName;
    }

    private static String getClassPath(Class tClass) {
        String path = tClass.getName();
        path = path.replace(".", "/");
        path = path + ".class";
        return path;
    }

    public static URL getUrlResourceFromJar(ClassLoader cl, String jarfileName, String configName) {
        try {
            Enumeration<URL> urlsss = cl.getResources(configName);
            while (urlsss.hasMoreElements()) {
                URL url = urlsss.nextElement();
                if (!url.getPath().contains(jarfileName)) continue;
                return url;
            }
        }
        catch (IOException e) {
            LOGGER.error("Read default.properties fail.");
        }
        return null;
    }

    public static InputStream getStreamResourceFromJar(Class cl, String configName) throws IOException {
        String jarfileName = AdapterUtils.getClassJarPath(cl);
        if (jarfileName == null) {
            LOGGER.error("read default.properties fail. class:" + cl + "  configName:" + configName);
            return null;
        }
        ClassLoader classLoader = AdapterUtils.getClassLoader(cl);
        if (null != classLoader) {
            URL url = AdapterUtils.getUrlResourceFromJar(classLoader, jarfileName, configName);
            if (url == null) {
                LOGGER.error("Read default.properties fail.");
                return null;
            }
            return url.openStream();
        }
        return null;
    }

    private static List<URL> getClassPathEntries(String classpath, String fileName) {
        File classpathFile = null;
        fileName = fileName.substring(1, fileName.length());
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(classpath);
            if (null == url) {
                LOGGER.error("The url is null");
                return new ArrayList<URL>();
            }
            classpathFile = new File(url.toURI());
            return AdapterUtils.getSubUrl(classpathFile, fileName);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"read classpath directory failed!!!", e);
            return new ArrayList<URL>();
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"parse classpath resource file failed!!!", e);
            return new ArrayList<URL>();
        }
    }

    private static List<URL> getAllClassPathEntries(String classpath, String fileName) {
        File classpathFile = null;
        fileName = fileName.substring(1, fileName.length());
        try {
            ArrayList<URL> list = new ArrayList<URL>();
            ClassLoader classLoader = AdapterUtils.getClassLoader(AdapterUtils.class);
            if (null == classLoader) {
                LOGGER.error("get AdapterUtil null!");
            } else {
                Enumeration<URL> emnum = classLoader.getResources(classpath);
                while (null != emnum && emnum.hasMoreElements()) {
                    URL url = emnum.nextElement();
                    if (null == url) {
                        LOGGER.error("The url is null");
                        return new ArrayList<URL>();
                    }
                    String urlPath = url.getPath();
                    if (urlPath.contains(".jar!/")) {
                        int index = urlPath.indexOf(".jar!/");
                        String jarPath = url.getPath().substring(0, index + 4);
                        AdapterUtils.getResourceFromJar(list, jarPath, fileName);
                        continue;
                    }
                    classpathFile = new File(url.toURI());
                    list.addAll(AdapterUtils.getSubUrl(classpathFile, fileName));
                }
            }
            return list;
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"read classpath directory failed!!!", e);
            return new ArrayList<URL>();
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)"parse classpath resource file failed!!!", e);
            return new ArrayList<URL>();
        }
        catch (IOException e) {
            LOGGER.error((Object)"parse classpath resource file failed!!!", e);
            return new ArrayList<URL>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getResourceFromJar(List<URL> list, String jarPath, String fileName) {
        ZipFile jarFile = null;
        try {
            String osName;
            if (jarPath.startsWith("file:/")) {
                jarPath = jarPath.substring(6);
            }
            if (null == (osName = System.getProperty("os.name")) || !osName.toLowerCase(Locale.ENGLISH).contains("windows")) {
                jarPath = "/" + jarPath;
            }
            jarFile = new JarFile(jarPath);
            String jarName = null;
            int index = jarPath.lastIndexOf("/");
            if (index >= 0) {
                jarName = jarPath.substring(index);
            }
            if (null == jarName) {
                LOGGER.error("jarName is null!");
                return;
            }
            Enumeration<JarEntry> es = ((JarFile)jarFile).entries();
            ClassLoader classLoader = AdapterUtils.getClassLoader(AdapterUtils.class);
            if (null == classLoader) {
                LOGGER.error("get adapterUtil class loader null!");
            } else {
                while (es.hasMoreElements()) {
                    JarEntry jarEntry = es.nextElement();
                    String resourceName = jarEntry.getName();
                    if (!resourceName.endsWith(fileName)) continue;
                    list.add(AdapterUtils.getUrlResourceFromJar(classLoader, jarName, resourceName));
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("get reource error " + ExceptionUtil.getErrorMessage(e));
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    LOGGER.error("get reource error " + ExceptionUtil.getErrorMessage(e));
                }
            }
        }
    }

    private static List<URL> getSubUrl(File parentDir, String fileName) throws MalformedURLException {
        ArrayList<URL> results = new ArrayList<URL>();
        File[] files = parentDir.listFiles();
        if (null != files && files.length > 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    results.addAll(AdapterUtils.getSubUrl(file, fileName));
                    continue;
                }
                if (file.getName().endsWith(fileName)) {
                    results.add(file.toURI().toURL());
                    continue;
                }
                if (!file.getName().endsWith(".jar")) continue;
                AdapterUtils.getResourceFromJar(results, file.getName(), fileName);
            }
        }
        return results;
    }
}

