/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class AddressUtil {
    public static final String IP4 = "IPV4";
    public static final String IP6 = "IPV6";
    public static final String IPV6REG = "^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|([0-9a-fA-F]{1,4}:){6,6}((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,1}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,4}):((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|:((:[0-9a-fA-F]{1,4}){1,5}):((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|:((:[0-9a-fA-F]{1,4}){1,7}|:)|[Ff][Ee]08:(:[0-9a-fA-F]{1,4}){2,2}%[0-9a-zA-Z]{1,}|(0{1,4}:){6,6}((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|(0{1,4}:){1,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|(0{1,4}:){1,4}:(0{1,4}:)((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|(0{1,4}:){1,3}:(0{1,4}:){1,2}((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|(0{1,4}:){1,2}:(0{1,4}:){1,3}((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|(0{1,4}:):(0{1,4}:){1,4}((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|::(0{1,4}:){1,5}((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|(0{1,4}:){5,5}[Ff]{4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|(0{1,4}:){1,4}:[Ff]{4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|(0{1,4}:){1,3}:(0{1,4}:)[Ff]{4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|(0{1,4}:){1,2}:(0{1,4}:){1,2}[Ff]{4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|(0{1,4}:):(0{1,4}:){1,3}[Ff]{4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|::(0{1,4}:){1,4}[Ff]{4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)|::([Ff]{4}:){0,1}((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d))$";
    private static final String IPV4REG = "((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]\\d|\\d)";
    private static final Log logger = LogFactory.getInstance(AddressUtil.class);

    private AddressUtil() {
    }

    public static boolean checkLocalIP(String ip) {
        if (null == ip || ip.length() <= 0) {
            return false;
        }
        if ("127.0.0.1".equals(ip)) {
            return true;
        }
        if ("localhost".equalsIgnoreCase(ip)) {
            return true;
        }
        InetAddress[] ipsAddr = AddressUtil.getAddress();
        String[] localServers = new String[ipsAddr.length];
        for (int i = 0; i < ipsAddr.length; ++i) {
            if (ipsAddr[i] == null) continue;
            localServers[i] = ipsAddr[i].getHostAddress();
            if (!ip.equals(localServers[i])) continue;
            return true;
        }
        return false;
    }

    private static InetAddress[] getAddress() {
        InetAddress addrd;
        try {
            addrd = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ee) {
            throw LegoExceptionTranslator.convert(ee);
        }
        String hostName = addrd.getHostName();
        InetAddress[] ipsAddr = null;
        try {
            ipsAddr = InetAddress.getAllByName(hostName);
        }
        catch (UnknownHostException ex) {
            throw LegoExceptionTranslator.convert(ex);
        }
        return ipsAddr;
    }

    public static String getLocalIP() {
        InetAddress[] ipsAddr = AddressUtil.getAddress();
        if (null != ipsAddr && ipsAddr.length > 0) {
            return ipsAddr[0].getHostAddress();
        }
        return "";
    }

    public static BigInteger ipToInt(String ipaddress) {
        if (Ipv4AddressUtil.isIPv4Address(ipaddress)) {
            long longIp = Ipv4AddressUtil.ipv4ToLong(ipaddress);
            return BigInteger.valueOf(longIp);
        }
        if (Ipv6AddressUtil.isIPv6Address(ipaddress)) {
            return Ipv6AddressUtil.ipv6ToInt(ipaddress);
        }
        logger.error("this ip is not a valid ip address. ip:" + ipaddress);
        return null;
    }

    public static String ipToString(BigInteger ipaddress) {
        if (VerifyUtil.isEmpty(ipaddress)) {
            return null;
        }
        byte[] addr = ipaddress.toByteArray();
        InetAddress address = null;
        try {
            address = InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            logger.error("this ip is not a valid ip address. ip:" + ipaddress);
            return null;
        }
        return address.getHostAddress();
    }

    public static String maskToIp(int mask) {
        String part = "";
        int xValue = mask / 8;
        int yValue = mask % 8;
        for (int i = 0; i < xValue; ++i) {
            if (xValue == 4) {
                part = "255.255.255.255";
                break;
            }
            part = part + "255.";
        }
        int sum = 0;
        int constant = 256;
        for (int i = 0; i < yValue; ++i) {
            sum += (constant >>= 1);
        }
        StringBuffer buf = new StringBuffer();
        if (xValue != 4) {
            for (int i = 0; i < 3 - xValue; ++i) {
                buf = buf.append(".0");
            }
            part = part + sum + buf.toString();
        }
        return part;
    }

    public static String getIpInStr(String text) {
        if (text == null || VerifyUtil.isEmpty(text)) {
            return null;
        }
        String ipString = Ipv4AddressUtil.getIpv4Addree(text);
        if (VerifyUtil.isEmpty(ipString)) {
            ipString = Ipv6AddressUtil.getIpv6Addree(text);
        }
        return ipString;
    }

    public static boolean isIpAddress(String ip) {
        return Ipv6AddressUtil.isIPv6Address(ip) || Ipv4AddressUtil.isIPv4Address(ip);
    }

    public static boolean isSameVersion(String ip1, String ip2) {
        if (ip1.contains(".") && ip2.contains(".")) {
            return true;
        }
        return ip1.contains(":") && ip2.contains(":");
    }

    public static String ipType(String ip) {
        if (Ipv4AddressUtil.isIPv4Address(ip)) {
            return IP4;
        }
        if (Ipv6AddressUtil.isIPv6Address(ip)) {
            return IP6;
        }
        return "";
    }

    public static String getStrWithoutPrecent(String ipStr) {
        if (ipStr.contains("%")) {
            return ipStr.split("\\%")[0];
        }
        return ipStr;
    }

    public static boolean isValidIP(String ip) {
        return Ipv4AddressUtil.isValidIPv4(ip) || Ipv6AddressUtil.isValidIPv6(ip);
    }
}

