/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ipv4AddressUtil {
    private static final Log logger = LogFactory.getInstance(Ipv4AddressUtil.class);
    private static final int VALUE_0X00FFFFFF = 0xFFFFFF;
    private static final int VALUE_0X0000FFFF = 65535;
    private static final int VALUE_0X000000FF = 255;
    private static Pattern patternIPv4 = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");

    public static long ipv4ToLong(String ipaddress) {
        if (VerifyUtil.isEmpty(ipaddress)) {
            return 0L;
        }
        long[] ip = new long[4];
        int position1 = ipaddress.indexOf(".");
        int position2 = ipaddress.indexOf(".", position1 + 1);
        int position3 = ipaddress.indexOf(".", position2 + 1);
        ip[0] = NumberUtil.convertToLong(ipaddress.substring(0, position1));
        ip[1] = NumberUtil.convertToLong(ipaddress.substring(position1 + 1, position2));
        ip[2] = NumberUtil.convertToLong(ipaddress.substring(position2 + 1, position3));
        ip[3] = NumberUtil.convertToLong(ipaddress.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static String longToIPv4(long ipaddress) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(ipaddress >>> 24));
        sb.append('.');
        sb.append(String.valueOf((ipaddress & 0xFFFFFFL) >>> 16));
        sb.append('.');
        sb.append(String.valueOf((ipaddress & 0xFFFFL) >>> 8));
        sb.append('.');
        sb.append(String.valueOf(ipaddress & 0xFFL));
        return sb.toString();
    }

    public static boolean isValidIPv4(String ip) {
        if (Ipv4AddressUtil.isIPv4Address(ip)) {
            String[] iPArray = ip.split("\\.");
            if (iPArray.length != 4) {
                return false;
            }
            int val = NumberUtil.convertToInteger(iPArray[0]);
            return val != 127;
        }
        return false;
    }

    public static boolean isIPv4Address(String ip) {
        if (VerifyUtil.isEmpty(ip)) {
            return false;
        }
        String ipv4 = Normalizer.normalize(ip, Normalizer.Form.NFKC);
        Matcher mat = patternIPv4.matcher(ipv4);
        if (mat.matches()) {
            try {
                InetAddress val = InetAddress.getByName(ip);
                if (null != val) {
                    return true;
                }
                logger.debug((Object)"%s is not a ipv4 address!", ipv4);
                return false;
            }
            catch (UnknownHostException ex) {
                logger.debug(ExceptionUtil.getErrorMessage(ex));
                return false;
            }
        }
        logger.debug((Object)"%s is not a ipv4 address!", ipv4);
        return false;
    }

    public static String getIpv4Addree(String text) {
        if (text == null || VerifyUtil.isEmpty(text)) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\d+(\\.\\d+){3,}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String matched = matcher.group();
            if (!matched.matches("(\\d+\\.){3}\\d+")) continue;
            return matched;
        }
        return null;
    }
}

