/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

public final class ReflectUtil {
    private static final Log logger = LogFactory.getInstance(ReflectUtil.class);

    private ReflectUtil() {
    }

    public static Method getter(Class<?> clazz, String fieldName, Class<?> fieldType) {
        fieldName = "get" + fieldName.substring(0, 1).toUpperCase(Locale.US) + fieldName.substring(1);
        return ReflectUtil.method(clazz, fieldName, fieldType, new Class[0]);
    }

    public static Method setter(Class<?> clazz, String fieldName, Class<?> fieldType) {
        fieldName = "set" + fieldName.substring(0, 1).toUpperCase(Locale.US) + fieldName.substring(1);
        return ReflectUtil.method(clazz, fieldName, Void.class, fieldType);
    }

    public static Method method(Class<?> clazz, String name, Class<?> retType, Class<?> ... argTypes) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(name, argTypes);
            return retType.isAssignableFrom(method.getReturnType()) ? method : null;
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.debug(ExceptionUtil.getErrorMessage(e));
            return ReflectUtil.method(clazz.getSuperclass(), name, retType, argTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object object, Method method) {
        if (method == null) {
            return null;
        }
        boolean needRestore = false;
        try {
            needRestore = ReflectUtil.modifyAccessible(method);
            Object object2 = method.invoke(object, new Object[0]);
            return object2;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.debug(ExceptionUtil.getErrorMessage(e));
        }
        finally {
            ReflectUtil.restoreAccessible(method, needRestore);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object object, Field field) {
        if (field == null) {
            return null;
        }
        boolean needRestore = false;
        try {
            needRestore = ReflectUtil.modifyAccessible(field);
            Object object2 = field.get(object);
            return object2;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.debug(ExceptionUtil.getErrorMessage(e));
        }
        finally {
            ReflectUtil.restoreAccessible(field, needRestore);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean set(Object object, Method method, Object value) {
        if (method == null) {
            return false;
        }
        boolean needRestore = false;
        try {
            needRestore = ReflectUtil.modifyAccessible(method);
            method.invoke(object, value);
            boolean bl = true;
            return bl;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error(e);
        }
        finally {
            ReflectUtil.restoreAccessible(method, needRestore);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean set(Object object, Field field, Object value) {
        if (field == null) {
            return false;
        }
        boolean needRestore = false;
        try {
            needRestore = ReflectUtil.modifyAccessible(field);
            field.set(object, value);
            boolean bl = true;
            return bl;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error(ExceptionUtil.getErrorMessage(e));
        }
        finally {
            ReflectUtil.restoreAccessible(field, needRestore);
        }
        return false;
    }

    private static boolean modifyAccessible(AccessibleObject ao) {
        if (ao.isAccessible()) {
            return false;
        }
        ao.setAccessible(true);
        return true;
    }

    private static void restoreAccessible(AccessibleObject ao, boolean needRestore) {
        if (needRestore) {
            ao.setAccessible(false);
        }
    }

    public static Field field(Class<?> clazz, String name, Class<?> fieldType) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(name);
            return fieldType.isAssignableFrom(field.getType()) ? field : null;
        }
        catch (NoSuchFieldException | SecurityException e) {
            logger.debug(ExceptionUtil.getErrorMessage(e));
            return ReflectUtil.field(clazz.getSuperclass(), name, fieldType);
        }
    }
}

