/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.sdk.util;

import com.huawei.lego.core.sdk.util.NumberUtil;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class TimeUtil {
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int SIX = 6;
    private static final int SEVEN = 7;
    private static final int SIXTY = 60;
    private static final int THOUSAND = 1000;
    private static final String YYYY_MM_DD_HH_MM_SS_UTC_Z = "yyyy-MM-dd HH:mm:ss 'UTC'Z";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int MILLISECOND = 60000;
    private static final int SECOND_TO_DAY = 86400;
    private static final int SECOND_TO_HOUR = 3600;
    private static final int SECOND_TO_MIUTE = 60;

    private TimeUtil() {
    }

    public static Date getAftertime(int minutes) {
        Date date = new Date();
        long time = date.getTime() + (long)minutes * 60000L;
        date.setTime(time);
        return date;
    }

    public static String getInterval(Date startDate) {
        Date currentDate = new Date();
        long currentTime = currentDate.getTime();
        long startTime = startDate.getTime();
        int minute = 0;
        int second = 0;
        long intervalTime = (currentTime - startTime) / 1000L;
        int day = 0;
        int hour = 0;
        day = (int)(intervalTime / 86400L);
        hour = (int)(intervalTime % 86400L) / 3600;
        minute = (int)(intervalTime % 3600L) / 60;
        second = (int)(intervalTime % 60L);
        return day + "day" + hour + "hour" + minute + "minute" + second + "second";
    }

    public static String getDefaultTimeZone() {
        TimeZone defaultTimezone = TimeZone.getDefault();
        SimpleDateFormat format = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_UTC_Z);
        format.setTimeZone(defaultTimezone);
        Date gmtTime = new Date();
        String str = format.format(gmtTime);
        StringBuilder sb = new StringBuilder(str);
        sb.insert(str.length() - 2, ":");
        if (defaultTimezone.useDaylightTime()) {
            sb.append(" DST");
        }
        return sb.substring(20);
    }

    public static String getDefaultTimeZone(Date gmtTime) {
        TimeZone defaultTimezone = TimeZone.getDefault();
        SimpleDateFormat format = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_UTC_Z);
        format.setTimeZone(defaultTimezone);
        String str = format.format(gmtTime);
        StringBuilder sb = new StringBuilder(str);
        sb.insert(str.length() - 2, ":");
        if (defaultTimezone.useDaylightTime()) {
            sb.append(" DST");
        }
        return sb.substring(20);
    }

    public static String getInterval(long startTime) {
        Date currentDate = new Date();
        long currentTime = currentDate.getTime();
        long intervalTime = (currentTime - startTime) / 1000L;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        day = (int)(intervalTime / 86400L);
        hour = (int)(intervalTime % 86400L) / 3600;
        minute = (int)(intervalTime % 3600L) / 60;
        second = (int)(intervalTime % 60L);
        return day + "day" + hour + "hour" + minute + "minute" + second + "second";
    }

    public static String getCurrentDate() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        return dateFormat.format(date);
    }

    public static String getCurrentDate(SimpleDateFormat dateFormat) {
        Date date = new Date();
        return dateFormat.format(date);
    }

    public static synchronized String localToGMT(String localString) {
        SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        try {
            Date retDate = yyyyMMddhhmmssSSDateFormate.parse(localString);
            return TimeUtil.toGMTString(retDate, TimeZone.getTimeZone("GMT"));
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static synchronized String toGMTString(Date date, TimeZone tz) {
        if (null == date || null == tz) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        df.setTimeZone(tz);
        return df.format(date);
    }

    public static synchronized String toLocalString(long date) {
        if (0L >= date) {
            return "";
        }
        return TimeUtil.toLocalString(new Date(date));
    }

    public static synchronized String toLocalString(Date date) {
        if (null == date) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        String id = TimeZone.getDefault().getID();
        format.setTimeZone(TimeZone.getTimeZone(id));
        return format.format(date);
    }

    public static synchronized String getTimeZoneOffset(int rawOffset) {
        String sign = rawOffset < 0 ? "-" : "+";
        int offset = Math.abs(rawOffset);
        int hour = offset / 3600000;
        int minute = offset % 3600000 / 60000;
        return MessageFormat.format("{0}{1,number,00}:{2,number,00}", sign, hour, minute);
    }

    public static synchronized Date getGmtDate(String gmtString, TimeZone timeZone) {
        SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        yyyyMMddhhmmssSSDateFormate.setTimeZone(timeZone);
        try {
            return yyyyMMddhhmmssSSDateFormate.parse(gmtString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static synchronized int rowOffsetStr2MS(String rowOffsetStr) {
        int offset = 0;
        offset += NumberUtil.convertToInteger(rowOffsetStr.substring(4, 6)) * 60 * 60 * 1000;
        offset += NumberUtil.convertToInteger(rowOffsetStr.substring(7)) * 60 * 1000;
        if (rowOffsetStr.charAt(3) == '-') {
            offset = -offset;
        }
        return offset;
    }

    public static synchronized Date yYYYMMddmmssToDate2(String dateString) {
        try {
            SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
            return yyyyMMddhhmmssSSDateFormate.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static synchronized Date timeStrToDate(String dateString, TimeZone timezone) {
        try {
            SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
            yyyyMMddhhmmssSSDateFormate.setTimeZone(timezone);
            return yyyyMMddhhmmssSSDateFormate.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static synchronized Date timeStrToDate(String dateString) {
        try {
            int index = dateString.lastIndexOf(58);
            dateString = dateString.substring(0, index) + dateString.substring(index + 1);
            SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_UTC_Z);
            return yyyyMMddhhmmssSSDateFormate.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String gmtToString(String gmtString, TimeZone timeZone) {
        try {
            Date date = TimeUtil.gmtStr2Date(gmtString);
            if (null == date) {
                return "";
            }
            return TimeUtil.gmtToString(date, timeZone);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static synchronized String gmtToString(Date gmtTime, TimeZone timeZone) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS_UTC_Z);
            format.setTimeZone(timeZone);
            String str = format.format(gmtTime);
            StringBuilder sb = new StringBuilder(str);
            sb.insert(str.length() - 2, ":");
            if (timeZone.useDaylightTime()) {
                sb.append(" DST");
            }
            return sb.toString();
        }
        catch (RuntimeException e) {
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private static synchronized Date gmtStr2Date(String gmtString) {
        SimpleDateFormat yyyyMMddhhmmssSSDateFormate = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        yyyyMMddhhmmssSSDateFormate.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return yyyyMMddhhmmssSSDateFormate.parse(gmtString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean isInTime(String sourceTime, String curTime) {
        if (sourceTime == null || !sourceTime.contains("-") || !sourceTime.contains(":")) {
            throw new IllegalArgumentException("Illegal Argument arg:" + sourceTime);
        }
        if (curTime == null || !curTime.contains(":")) {
            throw new IllegalArgumentException("Illegal Argument arg:" + curTime);
        }
        String[] args = sourceTime.split("-");
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        try {
            long end;
            long now = sdf.parse(curTime).getTime();
            long start = sdf.parse(args[0]).getTime();
            if (args[1].equals("00:00")) {
                args[1] = "24:00";
            }
            if ((end = sdf.parse(args[1]).getTime()) < start) {
                return now >= end && now < start;
            }
            return now >= start && now < end;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Illegal Argument arg:" + sourceTime, e);
        }
    }
}

