/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.sdk.model;

import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FaultConf {
    private String bundleName;
    private String trapoid;
    private String trapclass;
    private String synchronizeclass;
    private List<FaultDefine> defineList = new ArrayList<FaultDefine>();
    private String[] includeAlarmFile = new String[0];
    private boolean baseCfg = false;
    private Set<String> fileNames = new HashSet<String>();
    private String moMainType = "";
    private String moSubType = "";
    private boolean includeOffLineAlarm = true;

    public FaultConf() {
    }

    public FaultConf(String bundleName, String trapoid, String trapclass, String synchronizeclass) {
        this.bundleName = bundleName;
        this.trapoid = trapoid;
        this.trapclass = trapclass;
        this.synchronizeclass = synchronizeclass;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getTrapoid() {
        return this.trapoid;
    }

    public void setTrapoid(String trapoid) {
        this.trapoid = trapoid;
    }

    public String getTrapclass() {
        return this.trapclass;
    }

    public void setTrapclass(String trapclass) {
        this.trapclass = trapclass;
    }

    public String getSynchronizeclass() {
        return this.synchronizeclass;
    }

    public void setSynchronizeclass(String synchronizeclass) {
        this.synchronizeclass = synchronizeclass;
    }

    public void setDefineList(List<FaultDefine> defineList) {
        this.defineList = defineList;
    }

    public List<FaultDefine> getDefineList() {
        return this.defineList;
    }

    public void addFaultDefine(FaultDefine define) {
        this.defineList.add(define);
    }

    public void addFaultDefine(List<FaultDefine> faultDefineList) {
        this.defineList.addAll(faultDefineList);
    }

    public FaultDefine getFaultDefine(String faultId, String mMainType, String mSubType) {
        for (FaultDefine faultDefine : this.defineList) {
            if (!this.matchFauleDefine(faultId, faultDefine, mMainType, mSubType)) continue;
            return faultDefine;
        }
        return null;
    }

    private boolean matchFauleDefine(String faultId, FaultDefine faultDefine, String moMType, String mSubType) {
        if (!faultDefine.getFaultId().equals(faultId)) {
            return false;
        }
        if (null == moMType || "".equals(moMType)) {
            return true;
        }
        if (!moMType.equals(faultDefine.getMoMainType())) {
            return false;
        }
        return null == mSubType || "".equals(mSubType) || mSubType.equals(faultDefine.getMoSubType()) || "all".equalsIgnoreCase(faultDefine.getMoSubType());
    }

    public List<FaultDefine> getFaultDefine(String moType, String mSubType) {
        if (null == moType || "".equals(moType)) {
            return this.defineList;
        }
        ArrayList<FaultDefine> faultDefineList = new ArrayList<FaultDefine>();
        for (FaultDefine faultDefine : this.defineList) {
            if (!faultDefine.getMoMainType().equals(moType) || null != mSubType && !"".equals(mSubType) && !mSubType.equals(faultDefine.getMoSubType()) && !"all".equalsIgnoreCase(faultDefine.getMoSubType())) continue;
            faultDefineList.add(faultDefine);
        }
        return faultDefineList;
    }

    public List<FaultDefine> getFaultDefine() {
        return this.defineList;
    }

    public String[] getIncludeAlarmFile() {
        return this.includeAlarmFile;
    }

    public void setIncludeAlarmFile(String[] includeAlarmFile) {
        this.includeAlarmFile = includeAlarmFile;
    }

    public boolean isBaseCfg() {
        return this.baseCfg;
    }

    public void setBaseCfg(boolean baseCfg) {
        this.baseCfg = baseCfg;
    }

    public Set<String> getFileNames() {
        return this.fileNames;
    }

    public void addFileNames(String fileName) {
        this.fileNames.add(fileName);
    }

    public String getMoMainType() {
        return this.moMainType;
    }

    public void setMoMainType(String moMainType) {
        this.moMainType = moMainType;
    }

    public String getMoSubType() {
        return this.moSubType;
    }

    public void setMoSubType(String moSubType) {
        this.moSubType = moSubType;
    }

    public boolean isIncludeOffLineAlarm() {
        return this.includeOffLineAlarm;
    }

    public void setIncludeOffLineAlarm(boolean includeOffLineAlarm) {
        this.includeOffLineAlarm = includeOffLineAlarm;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundleName == null ? 0 : this.bundleName.hashCode());
        result = 31 * result + (this.defineList == null ? 0 : this.defineList.hashCode());
        result = 31 * result + (this.synchronizeclass == null ? 0 : this.synchronizeclass.hashCode());
        result = 31 * result + (this.trapclass == null ? 0 : this.trapclass.hashCode());
        result = 31 * result + (this.trapoid == null ? 0 : this.trapoid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (!(obj instanceof FaultConf)) {
            return false;
        }
        FaultConf other = (FaultConf)obj;
        return other.getBundleName().equals(this.bundleName) && other.getTrapoid().equals(this.trapoid) && other.getTrapclass().equals(this.trapclass) && other.getSynchronizeclass().equals(this.synchronizeclass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.bundleName + ", ");
        sb.append(this.trapoid + ", ");
        sb.append(this.trapclass + ", ");
        sb.append(this.synchronizeclass);
        return sb.toString();
    }
}

