/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.framework.log;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.helpers.LogLog;

public class FileUtils {
    private static final int BUFFER_SIZE = 10240;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File sourceFile, File zipFile) throws IOException {
        if (!sourceFile.exists() || !sourceFile.isFile()) {
            throw new IOException("Error sourceFile prepare to zip: " + sourceFile);
        }
        BufferedInputStream bis = null;
        ZipOutputStream out = null;
        FileInputStream fis = null;
        FileOutputStream dest = null;
        BufferedOutputStream bos = null;
        try {
            int count;
            fis = new FileInputStream(sourceFile);
            bis = new BufferedInputStream(fis, 10240);
            dest = new FileOutputStream(zipFile);
            bos = new BufferedOutputStream(dest, 10240);
            out = new ZipOutputStream(bos);
            ZipEntry zipEntry = new ZipEntry(sourceFile.getName());
            out.putNextEntry(zipEntry);
            byte[] data = new byte[10240];
            while ((count = bis.read(data, 0, 10240)) != -1) {
                out.write(data, 0, count);
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeIuputOutputStream(bis, out, fis, dest, bos);
            throw throwable;
        }
        FileUtils.closeIuputOutputStream(bis, out, fis, dest, bos);
    }

    private static void closeIuputOutputStream(BufferedInputStream bis, ZipOutputStream out, FileInputStream fis, FileOutputStream dest, BufferedOutputStream bos) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            LogLog.error((String)"IOException: out.close()");
        }
        try {
            if (bos != null) {
                bos.close();
            }
        }
        catch (IOException e) {
            LogLog.error((String)"IOException: bos.close()");
        }
        try {
            if (dest != null) {
                dest.close();
            }
        }
        catch (IOException e) {
            LogLog.error((String)"IOException: dest.close()");
        }
        try {
            if (bis != null) {
                bis.close();
            }
        }
        catch (IOException e) {
            LogLog.error((String)"IOException: bis.close()");
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException e) {
            LogLog.error((String)"IOException: fis.close()");
        }
    }
}

