/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.framework.log;

import com.huawei.wcc.framework.AppProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;

class LogConfigReader {
    private static final Set<String> LOADCONFSET = new HashSet<String>();
    private static volatile boolean hasInited = false;
    private static String lastpath = "";
    private static int loadFlag = 0;
    private static final int NUM_TWO = 2;
    private static final int LOG_RELOAD_DELAY = 60000;
    private static long delay = AppProperties.getAsInt((String)"LogConfReloadDelay", (int)60000);

    LogConfigReader() {
    }

    public static synchronized boolean isInited() {
        return hasInited;
    }

    public static void init(Properties pro) {
        PropertyConfigurator.configure((Properties)pro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(URL url) {
        if (LOADCONFSET.contains(url.toString())) {
            return;
        }
        Set<String> set = LOADCONFSET;
        synchronized (set) {
            if (!LOADCONFSET.contains(url.toString())) {
                PropertyConfigurator.configure((URL)url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        if (!configFile.exists()) {
            return;
        }
        if (LOADCONFSET.contains(configFile.getPath())) {
            return;
        }
        Set<String> set = LOADCONFSET;
        synchronized (set) {
            if (!LOADCONFSET.contains(configFile.getPath())) {
                PropertyConfigurator.configure((String)configFile.getPath());
            }
        }
    }

    public static synchronized void init() {
        if (hasInited) {
            return;
        }
        lastpath = AppProperties.getAppHome() + "log4j.properties";
        Enumeration enumeration = LogManager.getCurrentLoggers();
        if (!enumeration.hasMoreElements()) {
            LogConfigReader.loadconf();
            hasInited = true;
            return;
        }
        int val = AppProperties.getAsInt((String)"resource_LOG4J_REUSE", (int)0);
        if (val == 0) {
            LogConfigReader.loadconf();
        }
        hasInited = true;
    }

    private static void loadconf() {
        File file = new File(lastpath);
        if (file.exists()) {
            PropertyConfigurator.configureAndWatch((String)lastpath, (long)delay);
            loadFlag = 1;
            return;
        }
        URL url = LogConfigReader.getResUrlByClassLoader(lastpath);
        if (url != null) {
            loadFlag = 2;
            PropertyConfigurator.configure((URL)url);
        } else {
            try {
                url = new URL(lastpath);
                PropertyConfigurator.configure((URL)url);
            }
            catch (MalformedURLException e1) {
                LogConfigReader.otherway();
            }
        }
    }

    private static void otherway() {
        lastpath = AppProperties.getAppHome() + "log4j.xml";
        File file = new File(lastpath);
        if (file.exists()) {
            PropertyConfigurator.configureAndWatch((String)lastpath, (long)delay);
            loadFlag = 1;
            return;
        }
        lastpath = "config/log4j.properties";
        file = new File(lastpath);
        if (file.exists()) {
            PropertyConfigurator.configureAndWatch((String)lastpath, (long)delay);
            loadFlag = 1;
        } else {
            lastpath = "log4j.properties";
            file = new File(lastpath);
            if (file.exists()) {
                PropertyConfigurator.configureAndWatch((String)lastpath, (long)delay);
            } else {
                LogConfigReader.loadDef();
            }
        }
    }

    private static void loadDef() {
        Properties properties = new Properties();
        properties.put("log4j.rootLogger", "INFO,A1");
        properties.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        properties.put("log4j.appender.A1.target", "System.err");
        properties.put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
        properties.put("log4j.appender.A1.layout.ConversionPattern", "[%-5p] %d{yyyy-MM-dd HH:mm:ss,SSS} %m  [%l] %n");
        PropertyConfigurator.configure((Properties)properties);
    }

    private static URL getResUrlByClassLoader(String resource) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URL url = null;
        if (contextClassLoader != null) {
            url = contextClassLoader.getResource(resource);
        }
        return url != null ? url : ClassLoader.getSystemResource(resource);
    }
}

