/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.framework.log;

import java.util.HashMap;
import java.util.Map;

public final class LogFormatter {
    private static final int NUM_TWO = 2;
    private static final int NUM_50 = 50;

    public static String format(String messagePattern, Object arg) {
        return LogFormatter.arrayFormat(messagePattern, new Object[]{arg});
    }

    public static String format(String messagePattern, Object arg1, Object arg2) {
        return LogFormatter.arrayFormat(messagePattern, new Object[]{arg1, arg2});
    }

    public static String arrayFormat(String messagePattern, Object[] argArray) {
        if (messagePattern == null) {
            return null;
        }
        if (argArray == null) {
            return messagePattern;
        }
        int i = 0;
        StringBuffer sbuf = new StringBuffer(messagePattern.length() + 50);
        for (int h = 0; h < argArray.length; ++h) {
            int j = messagePattern.indexOf("{}", i);
            if (j == -1) {
                if (i == 0) {
                    return messagePattern;
                }
                sbuf.append(messagePattern.substring(i));
                return sbuf.toString();
            }
            if (LogFormatter.isEscapedDelimeter(messagePattern, j)) {
                if (!LogFormatter.isDoubleEscaped(messagePattern, j)) {
                    --h;
                    sbuf.append(messagePattern.substring(i, j - 1));
                    sbuf.append('{');
                    i = j + 1;
                    continue;
                }
                sbuf.append(messagePattern.substring(i, j - 1));
                LogFormatter.deeplyAppendParameter(sbuf, argArray[h], new HashMap<Object[], Object>());
                i = j + 2;
                continue;
            }
            sbuf.append(messagePattern.substring(i, j));
            LogFormatter.deeplyAppendParameter(sbuf, argArray[h], new HashMap<Object[], Object>());
            i = j + 2;
        }
        sbuf.append(messagePattern.substring(i));
        return sbuf.toString();
    }

    static boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        if (delimeterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimeterStartIndex - 1);
        return potentialEscape == '\\';
    }

    static boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        return delimeterStartIndex >= 2 && messagePattern.charAt(delimeterStartIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuffer sbuf, Object obj, Map<Object[], Object> seenMap) {
        if (obj == null) {
            sbuf.append("null");
            return;
        }
        if (!obj.getClass().isArray()) {
            LogFormatter.safeObjectAppend(sbuf, obj);
        } else if (obj instanceof boolean[]) {
            LogFormatter.booleanArrayAppend(sbuf, (boolean[])obj);
        } else if (obj instanceof byte[]) {
            LogFormatter.byteArrayAppend(sbuf, (byte[])obj);
        } else if (obj instanceof char[]) {
            LogFormatter.charArrayAppend(sbuf, (char[])obj);
        } else if (obj instanceof short[]) {
            LogFormatter.shortArrayAppend(sbuf, (short[])obj);
        } else if (obj instanceof int[]) {
            LogFormatter.intArrayAppend(sbuf, (int[])obj);
        } else if (obj instanceof long[]) {
            LogFormatter.longArrayAppend(sbuf, (long[])obj);
        } else if (obj instanceof float[]) {
            LogFormatter.floatArrayAppend(sbuf, (float[])obj);
        } else if (obj instanceof double[]) {
            LogFormatter.doubleArrayAppend(sbuf, (double[])obj);
        } else {
            LogFormatter.objectArrayAppend(sbuf, (Object[])obj, seenMap);
        }
    }

    private static void safeObjectAppend(StringBuffer sbuf, Object obj) {
        try {
            sbuf.append(obj.toString());
        }
        catch (Throwable t) {
            sbuf.append("[FAILED toString()]" + t.getMessage());
        }
    }

    private static void objectArrayAppend(StringBuffer sbuf, Object[] a, Map<Object[], Object> seenMap) {
        sbuf.append('[');
        if (seenMap.containsKey(a)) {
            sbuf.append("...");
        } else {
            seenMap.put(a, null);
            int len = a.length - 1;
            for (int i = 0; i <= len; ++i) {
                LogFormatter.deeplyAppendParameter(sbuf, a[i], seenMap);
                if (i >= len) continue;
                sbuf.append(", ");
            }
            seenMap.remove(a);
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuffer sbuf, boolean[] a) {
        sbuf.append('[');
        int len = a.length - 1;
        for (int i = 0; i <= len; ++i) {
            sbuf.append(a[i]);
            if (i >= len) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuffer sbuf, byte[] a) {
        sbuf.append('[');
        int len = a.length - 1;
        for (int i = 0; i <= len; ++i) {
            sbuf.append(a[i]);
            if (i >= len) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuffer sbuf, char[] a) {
        sbuf.append('[');
        int len = a.length - 1;
        for (int i = 0; i <= len; ++i) {
            sbuf.append(a[i]);
            if (i >= len) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuffer sbuf, short[] a) {
        sbuf.append('[');
        int len = a.length - 1;
        for (int i = 0; i <= len; ++i) {
            sbuf.append(a[i]);
            if (i >= len) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuffer sbuf, int[] a) {
        sbuf.append('[');
        int len = a.length - 1;
        for (int i = 0; i <= len; ++i) {
            sbuf.append(a[i]);
            if (i >= len) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuffer sbuf, long[] a) {
        sbuf.append('[');
        int len = a.length - 1;
        for (int i = 0; i <= len; ++i) {
            sbuf.append(a[i]);
            if (i >= len) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuffer sbuf, float[] a) {
        sbuf.append('[');
        int len = a.length - 1;
        for (int i = 0; i <= len; ++i) {
            sbuf.append(a[i]);
            if (i >= len) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuffer sbuf, double[] a) {
        sbuf.append('[');
        int len = a.length - 1;
        for (int i = 0; i <= len; ++i) {
            sbuf.append(a[i]);
            if (i >= len) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }
}

