/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.framework.log;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

class RollingCalendar
extends GregorianCalendar {
    public static final int NUM_TWO = 2;
    public static final int HOUR_IN_HALF_DAY = 12;
    public static final int HOUR_IN_DAY = 24;
    public static final int MINUTE_IN_HOUR = 60;
    public static final int MINUTE_IN_DAY = 1440;
    public static final long MILLIS_IN_ONE_DAY = 1440000L;
    protected static final int TOP_OF_TROUBLE = -1;
    protected static final int TOP_OF_MINUTE = 0;
    protected static final int TOP_OF_HOUR = 1;
    protected static final int HALF_DAY = 2;
    protected static final int TOP_OF_DAY = 3;
    protected static final int TOP_OF_WEEK = 4;
    protected static final int TOP_OF_MONTH = 5;
    private static final int MONTH_OF_YEAR = 12;
    private static final int HOUR_OF_HALF_DAY = 12;
    private static final int HALF_DAY_OF_DAY = 2;
    private static final long serialVersionUID = -3560331770601814177L;
    private int type = -1;

    RollingCalendar() {
    }

    RollingCalendar(TimeZone tz, Locale locale) {
        super(tz, locale);
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public long getNextCheckMillis(Date now) {
        return this.getNextCheckDate(now).getTime();
    }

    public Date getEndOfNextNthPeriod(Date now, int periods) {
        return this.innerGetEndOfNextNthPeriod(now, periods);
    }

    public Date getNextCheckDate(Date now) {
        return this.innerGetEndOfNextNthPeriod(now, 1);
    }

    public Date getsStartOfCurrentPeriod(long now) {
        Calendar aCal = Calendar.getInstance(this.getTimeZone());
        aCal.setTimeInMillis(now);
        return this.getEndOfNextNthPeriod(aCal.getTime(), 0);
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || !(that instanceof RollingCalendar)) {
            return false;
        }
        if (this.type != ((RollingCalendar)that).type) {
            return false;
        }
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.type;
    }

    private Date innerGetEndOfNextNthPeriod(Date now, int numPeriods) {
        this.setTime(now);
        this.set(14, 0);
        switch (this.type) {
            case 0: {
                this.set(13, 0);
                this.add(12, numPeriods);
                break;
            }
            case 1: {
                this.set(12, 0);
                this.set(13, 0);
                this.add(11, numPeriods);
                break;
            }
            case 2: {
                this.set(12, 0);
                this.set(13, 0);
                this.addNthHalfDay(numPeriods);
                break;
            }
            case 3: {
                this.set(12, 0);
                this.set(13, 0);
                this.set(11, 0);
                this.add(5, numPeriods);
                break;
            }
            case 4: {
                this.set(12, 0);
                this.set(13, 0);
                this.set(11, 0);
                this.set(7, this.getFirstDayOfWeek());
                this.add(3, numPeriods);
                break;
            }
            case 5: {
                this.set(this.get(1), this.get(2), 1, 0, 0, 0);
                this.add(2, numPeriods);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown periodicity type.");
            }
        }
        return this.getTime();
    }

    private void addNthHalfDay(int numPeriods) {
        int hour = this.get(11);
        int dayPeriods = numPeriods / 2;
        if (1 == numPeriods % 2) {
            if (hour < 12) {
                this.set(11, 12);
                this.add(5, dayPeriods);
            } else {
                this.set(11, 0);
                this.add(5, dayPeriods + 1);
            }
        } else if (-1 == numPeriods % 2) {
            if (hour < 12) {
                this.set(11, 12);
                this.add(5, dayPeriods - 1);
            } else {
                this.set(11, 0);
                this.add(5, dayPeriods);
            }
        } else if (hour < 12) {
            this.set(11, 0);
            this.add(5, dayPeriods);
        } else {
            this.set(11, 12);
            this.add(5, dayPeriods);
        }
    }

    public long periodBarriersCrossed(long start, long end) {
        if (start > end) {
            throw new IllegalArgumentException("End cannot come before start");
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTimeInMillis(start);
        Calendar endCal = Calendar.getInstance();
        endCal.setTimeInMillis(end);
        int dayDiff = endCal.get(6) - startCal.get(6);
        int hourDiff = endCal.get(11) - startCal.get(11);
        switch (this.type) {
            case 0: {
                int minuteDiff = endCal.get(12) - startCal.get(12);
                return dayDiff * 1440 + hourDiff * 60 + minuteDiff;
            }
            case 1: {
                return dayDiff * 24 + hourDiff;
            }
            case 2: {
                return dayDiff * 2 + hourDiff / 12;
            }
            case 3: {
                return dayDiff;
            }
            case 4: {
                int weekDiff = endCal.get(3) - startCal.get(3);
                return weekDiff;
            }
            case 5: {
                int yearDiff = endCal.get(1) - startCal.get(1);
                int monthDiff = endCal.get(2) - startCal.get(2);
                return yearDiff * 12 + monthDiff;
            }
        }
        throw new IllegalStateException("Unknown periodicity type.");
    }
}

