/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.framework.log;

import com.huawei.wcc.framework.log.FileUtils;
import com.huawei.wcc.framework.log.SizeRollingFileAppender;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.helpers.LogLog;

public class SizeRollingZipFileAppender
extends SizeRollingFileAppender {
    private static final String ZIP_SUFFIX = ".zip";
    private String zipFileName = null;

    @Override
    protected String getNewNameWithIndex(String filePath, String logNameAttch, int numIdx) {
        return super.getNewNameWithIndex(filePath, logNameAttch, numIdx) + ZIP_SUFFIX;
    }

    @Override
    protected String getFileMatchString(String fileName, String fileAttachName, String fileFullName) {
        return super.getFileMatchString(fileName, fileAttachName, fileFullName) + ZIP_SUFFIX;
    }

    @Override
    protected void doAfterRename() {
        this.zipit();
    }

    protected String getZipFileName() {
        return this.zipFileName;
    }

    protected void zipit() {
        String targetFileName = this.getTargetFileName();
        this.zipFileName = targetFileName + ZIP_SUFFIX;
        File target = new File(targetFileName);
        File zipTarget = new File(this.zipFileName);
        try {
            LogLog.debug((String)("ziping file " + target + " to " + zipTarget));
            FileUtils.zip(target, zipTarget);
        }
        catch (IOException e1) {
            LogLog.error((String)("zip file(" + this.fileName + ") failed."));
        }
        if (target.exists() && !target.delete()) {
            LogLog.error((String)("delete zip file(" + this.fileName + ") failed."));
        }
    }
}

