/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.framework.log;

import com.huawei.wcc.framework.log.FileSize;
import com.huawei.wcc.framework.log.FileUtils;
import com.huawei.wcc.framework.log.RollingCalendar;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class TimeBasedRollingFileAppender
extends FileAppender {
    protected static final long UNINITIALIZED = -1L;
    protected static final long INACTIVITY_TOLERANCE_IN_MILLIS = 46080000L;
    protected static final int MAX_VALUE_FOR_INACTIVITY_PERIODS = 336;
    protected static final TimeZone QMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static final int UNBOUND_TOTAL_SIZE = 0;
    private static final int UNTOUCHABLE_ARCHIVE_FILE_COUNT = 2;
    private static final String ZIP_SUFFIX = ".zip";
    private static final ExecutorService CLEAN_TASK_EXECUTOR = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable);
        thread.setUncaughtExceptionHandler((thr, error) -> LogLog.error((String)"Process ErrorStream Error."));
        thread.setDaemon(true);
        return thread;
    });
    private Date now = new Date();
    private SimpleDateFormat sdf;
    private RollingCalendar rc = new RollingCalendar();
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private String targetFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    private long lastCleanTime = -1L;
    private boolean firstCleanFlag = true;
    private int maxHistory;
    private boolean compressed;
    private String totalSizeCap;
    private long longTotalSizeCap = 0L;

    public TimeBasedRollingFileAppender() {
    }

    public TimeBasedRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public final void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.sdf = new SimpleDateFormat(this.datePattern);
            this.now.setTime(System.currentTimeMillis());
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
            if (this.totalSizeCap != null && !"".equals(this.totalSizeCap)) {
                FileSize sizeCap = FileSize.valueOf(this.totalSizeCap);
                this.longTotalSizeCap = sizeCap.getSize();
            }
        } else {
            LogLog.error((String)("Either File or DatePattern options are not set for appender [" + this.name + "]."));
        }
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            if (this.closed) {
                return;
            }
            this.fileName = this.targetFilename;
            this.reopenLogFile();
            if (!this.checkEntryConditions()) {
                return;
            }
        }
        this.subAppend(event);
    }

    private void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    private int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(QMT_TIME_ZONE, Locale.getDefault());
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(QMT_TIME_ZONE);
                String epochDateStr = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date nextCheckDate = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String nextCheckDateStr = simpleDateFormat.format(nextCheckDate);
                if (epochDateStr.equals(nextCheckDateStr)) continue;
                return i;
            }
        }
        return -1;
    }

    private void reopenLogFile() {
        try {
            this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.error((String)("setFile(" + this.fileName + ", true) call failed."));
        }
    }

    void rollOver() throws IOException {
        File file;
        boolean result;
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String datedFilename = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this.scheduledFilename);
        if (target.exists() && !target.delete() && !target.delete()) {
            LogLog.warn((String)("delete log file error: " + target.getName()));
        }
        if (result = (file = new File(this.fileName)).renameTo(target)) {
            LogLog.debug((String)(this.fileName + " -> " + this.scheduledFilename));
        } else {
            LogLog.error((String)("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "]."));
        }
        try {
            this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.errorHandler.error("setFile(" + this.fileName + ", true) call failed.");
        }
        this.targetFilename = this.scheduledFilename;
        this.scheduledFilename = datedFilename;
    }

    protected void subAppend(LoggingEvent event) {
        long curTime = System.currentTimeMillis();
        if (curTime >= this.nextCheck) {
            this.now.setTime(curTime);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException ioe) {
                if (ioe instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error((String)"rollOver() failed.", (Throwable)ioe);
            }
            this.cleanAsynchronously(this.now);
        } else {
            this.now.setTime(curTime);
            if (this.firstCleanFlag) {
                this.firstCleanFlag = false;
                this.cleanAsynchronously(this.now);
                this.lastCleanTime = this.rc.getEndOfNextNthPeriod(this.now, -1).getTime();
            }
        }
        super.subAppend(event);
    }

    protected void zipit() {
        String zipFilename = this.targetFilename + ZIP_SUFFIX;
        File target = new File(this.targetFilename);
        if (!target.exists() || !target.isFile()) {
            return;
        }
        File zipTarget = new File(zipFilename);
        try {
            LogLog.debug((String)("ziping file " + this.targetFilename + " to " + zipFilename));
            FileUtils.zip(target, zipTarget);
        }
        catch (IOException e1) {
            LogLog.error((String)("zip file(" + this.targetFilename + ") failed."));
        }
        if (target.exists() && !target.delete()) {
            LogLog.error((String)("delete zip source file(" + this.targetFilename + ") failed."));
        }
    }

    protected void clean(Date startTime) {
        long nowInMillis = startTime.getTime();
        int periodsElapsed = this.computeElapsedPeriodsSinceLastClean(nowInMillis);
        this.lastCleanTime = nowInMillis;
        if (periodsElapsed > 1) {
            LogLog.warn((String)("Multiple periods, i.e. " + periodsElapsed + " periods, seem to have elapsed. This is expected at application start."));
        }
        for (int i = 0; i < periodsElapsed; ++i) {
            int offset = this.getPeriodOffsetForDeletionTarget() - i;
            Date dateOfPeriodToClean = this.rc.getEndOfNextNthPeriod(startTime, offset);
            this.cleanPeriod(dateOfPeriodToClean);
        }
    }

    void capTotalSize(Date startTime) {
        int totalSize = 0;
        int totalRemoved = 0;
        for (int offset = 1; offset <= this.maxHistory; ++offset) {
            Date date = this.rc.getEndOfNextNthPeriod(startTime, -offset);
            File[] matchingFileArray = this.getFilesInPeriod(date);
            this.descendingSortByLastModified(matchingFileArray);
            for (File f : matchingFileArray) {
                long size = f.length();
                if ((long)totalSize + size > this.longTotalSizeCap) {
                    totalRemoved = this.getTotalRemoved(totalRemoved, offset, f, size);
                }
                totalSize = (int)((long)totalSize + size);
            }
        }
        LogLog.debug((String)("Removed  " + new FileSize(totalRemoved) + " of files"));
    }

    private int getTotalRemoved(int totalRemoved, int offset, File f, long size) {
        if (offset >= 2) {
            LogLog.debug((String)("Deleting [" + f.getName() + "] of size " + new FileSize(size)));
            totalRemoved = (int)((long)totalRemoved + size);
            if (!f.delete() && !f.delete()) {
                LogLog.warn((String)("delete log file error: " + f.getName()));
            }
        } else {
            LogLog.warn((String)("Skipping [" + f.getName() + "] of size " + new FileSize(size) + " as it is one of the two newest log achives."));
        }
        return totalRemoved;
    }

    private void descendingSortByLastModified(File[] matchingFileArray) {
        Arrays.sort(matchingFileArray, new FileComparator());
    }

    int getPeriodOffsetForDeletionTarget() {
        return -this.maxHistory - 1;
    }

    void cleanPeriod(Date dateOfPeriodToClean) {
        File[] matchingFileArray;
        for (File f : matchingFileArray = this.getFilesInPeriod(dateOfPeriodToClean)) {
            LogLog.debug((String)("deleting " + f.getName()));
            if (f.delete() || f.delete()) continue;
            LogLog.warn((String)("delete log file error: " + f.getName()));
        }
    }

    protected File[] getFilesInPeriod(Date dateOfPeriodToClean) {
        String filenameToDelete = this.fileName + this.sdf.format(dateOfPeriodToClean);
        File file2Delete = new File(filenameToDelete);
        String zipFileToDelete = this.fileName + this.sdf.format(dateOfPeriodToClean) + ZIP_SUFFIX;
        File zipFile2Delete = new File(zipFileToDelete);
        ArrayList<File> fileArrayList = new ArrayList<File>();
        if (this.fileExistsAndIsFile(file2Delete)) {
            fileArrayList.add(file2Delete);
        }
        if (this.fileExistsAndIsFile(zipFile2Delete)) {
            fileArrayList.add(zipFile2Delete);
        }
        return fileArrayList.toArray(new File[fileArrayList.size()]);
    }

    private boolean fileExistsAndIsFile(File file2Delete) {
        return file2Delete.exists() && file2Delete.isFile();
    }

    int computeElapsedPeriodsSinceLastClean(long nowInMillis) {
        long periodsElapsed;
        if (this.lastCleanTime == -1L) {
            LogLog.debug((String)"first clean up after appender initialization");
            periodsElapsed = this.rc.periodBarriersCrossed(nowInMillis, nowInMillis + 46080000L);
            periodsElapsed = Math.min(periodsElapsed, 336L);
        } else {
            periodsElapsed = this.rc.periodBarriersCrossed(this.lastCleanTime, nowInMillis);
        }
        return (int)periodsElapsed;
    }

    private Future cleanAsynchronously(Date startTime) {
        ArhiveRemoverRunnable runnable = new ArhiveRemoverRunnable(startTime);
        Future<?> future = CLEAN_TASK_EXECUTOR.submit(runnable);
        return future;
    }

    public Date getNow() {
        if (this.now == null) {
            return null;
        }
        return (Date)this.now.clone();
    }

    public void setNow(Date now) {
        if (now == null) {
            this.now = null;
            return;
        }
        this.now = (Date)now.clone();
    }

    public SimpleDateFormat getSdf() {
        return this.sdf;
    }

    public void setSdf(SimpleDateFormat sdf) {
        this.sdf = sdf;
    }

    public RollingCalendar getRc() {
        return this.rc;
    }

    public void setRc(RollingCalendar rc) {
        this.rc = rc;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public String getTotalSizeCap() {
        return this.totalSizeCap;
    }

    public void setTotalSizeCap(String totalSizeCap) {
        this.totalSizeCap = totalSizeCap;
    }

    private static class FileComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 5091221034873027854L;

        private FileComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            long l2;
            long l1 = f1.lastModified();
            if (l1 == (l2 = f2.lastModified())) {
                return 0;
            }
            if (l2 < l1) {
                return -1;
            }
            return 1;
        }
    }

    public class ArhiveRemoverRunnable
    implements Runnable {
        private Date now;

        ArhiveRemoverRunnable(Date now) {
            this.now = now;
        }

        @Override
        public void run() {
            if (TimeBasedRollingFileAppender.this.compressed) {
                TimeBasedRollingFileAppender.this.zipit();
            }
            TimeBasedRollingFileAppender.this.clean(this.now);
            if (TimeBasedRollingFileAppender.this.longTotalSizeCap != 0L && TimeBasedRollingFileAppender.this.longTotalSizeCap > 0L) {
                TimeBasedRollingFileAppender.this.capTotalSize(this.now);
            }
        }

        public Date getNow() {
            if (this.now == null) {
                return null;
            }
            return (Date)this.now.clone();
        }

        public void setNow(Date now) {
            if (now == null) {
                this.now = null;
                return;
            }
            this.now = (Date)now.clone();
        }
    }
}

