/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.license.util;

import com.huawei.lego.cbb.license.util.IEsnTool;
import com.huawei.lego.cbb.license.util.SignVerifier;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoCmdUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class EsnToolBase
implements IEsnTool {
    private static final Log LOGGER = LogFactory.getInstance(EsnToolBase.class);
    private static final int VALUE_2 = 2;
    private String toolpath = "";

    public EsnToolBase(String path) {
        this.toolpath = path;
    }

    @Override
    public List<String> getServerEsns() {
        ArrayList<String> arrayList;
        String str;
        BufferedReader br;
        Process process;
        ArrayList<String> esnlist;
        block6: {
            esnlist = new ArrayList<String>();
            String executeCmd = this.getExecuteCmd();
            LOGGER.info((Object)"Begin execute query esn command.", 1L);
            process = null;
            br = null;
            SignVerifier.getInstance().verify(executeCmd);
            process = Runtime.getRuntime().exec(executeCmd);
            br = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
            str = br.readLine();
            if (0 == LegoCmdUtil.waitProcessExecuteWithTimeout((Process)process)) break block6;
            ArrayList<String> arrayList2 = esnlist;
            CommonUtil.close((Closeable)br);
            CommonUtil.destroyProcess((Process)process);
            return arrayList2;
        }
        try {
            String[] strs;
            LOGGER.info((Object)"End esn process.", 1L);
            if (!"".equals(str) && this.getStrsLens(strs = str.split(":"))) {
                esnlist.add(strs[1]);
                LOGGER.info((Object)String.format(Locale.ENGLISH, "THE ESN: %s.", strs[1]), 1L);
            }
            LOGGER.info((Object)"End getServerEsns", 1L);
            arrayList = esnlist;
        }
        catch (Exception e) {
            try {
                LOGGER.error((Object)("getServerEsns error: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                throw new LegoUncheckedException("getServerEsns error: " + ExceptionUtil.getErrorMessage((Throwable)e));
            }
            catch (Throwable throwable) {
                CommonUtil.close(br);
                CommonUtil.destroyProcess(process);
                throw throwable;
            }
        }
        CommonUtil.close((Closeable)br);
        CommonUtil.destroyProcess((Process)process);
        return arrayList;
    }

    public abstract String getExecuteCmd();

    private boolean getStrsLens(String[] strs) {
        return strs.length != 0 && strs.length == 2;
    }

    public Log getLogger() {
        return LOGGER;
    }

    public String getToolpath() {
        return this.toolpath;
    }
}

