/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.roleservice;

import com.huawei.lego.cbb.user.dao.IRoleDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.OperationInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.huawei.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.service.common.ObjectConvertor;
import com.huawei.lego.cbb.user.service.roleservice.IRoleService;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.comm.SortUnit;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RoleService
implements IRoleService {
    private static final Log LOG = LogFactory.getInstance(RoleService.class);
    private IRoleDao roleDao;
    private ICommonDao commDao;

    @Override
    public synchronized int addRoleInfo(Role oRole, List<Long> mapOpts) {
        this.roleDao.checkRoleNameSingle(oRole.getRoleName());
        RoleInfo tmpRoleInfo = ObjectConvertor.translatePoRole(oRole);
        HashSet<OperationInfo> operationSet = new HashSet<OperationInfo>();
        for (Long m : mapOpts) {
            operationSet.add(new OperationInfo(m));
        }
        tmpRoleInfo.setOperationSet(operationSet);
        this.roleDao.addRoleInfo(tmpRoleInfo);
        return 0;
    }

    @Override
    public synchronized void deleteRole(long roleId) {
        this.roleDao.deleteRole(roleId);
    }

    @Override
    public synchronized BatchOperationResult batchDelRoles(List<BatchOperation> list) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != list) {
            operCount = list.size();
            for (BatchOperation batchOperation : list) {
                try {
                    this.roleDao.deleteRole(batchOperation.getTargetId());
                }
                catch (LegoCheckedException e) {
                    ++fail;
                    batchOperation.setDetailParam(e.getParameters());
                    batchOperation.setErrorCode(e.getErrorCode());
                }
                catch (LegoUncheckedException e) {
                    ++fail;
                    batchOperation.setErrorCode(e.getErrorCode());
                }
                catch (Exception e) {
                    ++fail;
                    batchOperation.setErrorCode(102L);
                }
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    @Override
    public synchronized Role getRoleInf(long iRoleId) {
        RoleInfo roleInfo = new RoleInfo();
        HashSet tmpOptInfo = new HashSet();
        roleInfo.setOperationSet(tmpOptInfo);
        roleInfo = this.roleDao.getRoleById(iRoleId, true);
        Role oRole = ObjectConvertor.translateBoRoleInfo(roleInfo, true);
        HashSet<Long> optIdsSet = new HashSet<Long>();
        Set optSet = roleInfo.getOperationSet();
        if (null != optSet && !optSet.isEmpty()) {
            for (OperationInfo opt : optSet) {
                optIdsSet.add(opt.getOpId());
            }
        }
        oRole.setOptIdsSet(optIdsSet);
        return oRole;
    }

    @Override
    public synchronized Role getRoleInf(String roleName) {
        RoleInfo roleInfo = this.roleDao.getRoleByName(roleName, true);
        Role oRole = ObjectConvertor.translateBoRoleInfo(roleInfo, true);
        HashSet<Long> optIdsSet = new HashSet<Long>();
        Set optSet = roleInfo.getOperationSet();
        if (null != optSet && !optSet.isEmpty()) {
            for (OperationInfo opt : optSet) {
                optIdsSet.add(opt.getOpId());
            }
        }
        oRole.setOptIdsSet(optIdsSet);
        return oRole;
    }

    @Override
    public RoleInfo getRole(long iRoleId) {
        return this.roleDao.getRoleById(iRoleId, true);
    }

    @Override
    public Role getRoleInfRelUser(long iRoleId, boolean isFetchUser) {
        Role oRole = new Role();
        RoleInfo roleInfo = this.roleDao.getRoleById(iRoleId, true);
        try {
            roleInfo = this.roleDao.getRoleInfRelUser(iRoleId, isFetchUser);
        }
        catch (Exception e) {
            LOG.info((Object)"the roleInfo  is empty!", 1L);
        }
        if (null != roleInfo.getUserSet() && !roleInfo.getUserSet().isEmpty()) {
            for (UserInfo userInfo : roleInfo.getUserSet()) {
                oRole.getUserSet().add(ObjectConvertor.getUser(userInfo, false, false));
            }
        }
        return oRole;
    }

    @Override
    public int updataRole(Role oRole, List<Long> mapOpts) {
        RoleInfo tmpRoleInfo = this.roleDao.getRoleById(oRole.getRoleId(), true);
        tmpRoleInfo.setOperationSet(new HashSet());
        RoleInfo tmpRoleInfoFromPo = ObjectConvertor.translatePoRole(oRole);
        tmpRoleInfo.setCreatorId(tmpRoleInfoFromPo.getCreatorId());
        tmpRoleInfo.setCreatTime(tmpRoleInfoFromPo.getCreatTime());
        tmpRoleInfo.setRoleDescription(tmpRoleInfoFromPo.getRoleDescription());
        tmpRoleInfo.setRoleName(tmpRoleInfoFromPo.getRoleName());
        HashSet<OperationInfo> operationSet = new HashSet<OperationInfo>();
        for (Long m : mapOpts) {
            operationSet.add(new OperationInfo(m));
        }
        tmpRoleInfo.setOperationSet(operationSet);
        this.roleDao.updataRole(tmpRoleInfo);
        return 0;
    }

    @Override
    public List<Role> getAllRoles(boolean isFetchRole) {
        List<RoleInfo> lstSingleRoleInfo = null;
        ArrayList<Role> lstRole = new ArrayList<Role>();
        lstSingleRoleInfo = this.roleDao.getAllRoles(false);
        String countHql = "select count(*) from UserIdAndRoleId as ur where ur.id.roleId = ?";
        int iCount = 0;
        for (RoleInfo tmpRoleInfo : lstSingleRoleInfo) {
            Role tmpRole = ObjectConvertor.translateBoRoleInfo(tmpRoleInfo, false);
            try {
                iCount = Integer.parseInt(String.valueOf(this.commDao.getBaseHibernateTemplate().find(countHql, (Object[])new Long[]{tmpRoleInfo.getRoleIdx()}).listIterator().next()));
                tmpRole.setUserNum(iCount);
            }
            catch (Exception e) {
                LOG.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
            }
            lstRole.add(tmpRole);
        }
        return lstRole;
    }

    @Override
    public Paging getAllRoles(int start, int length, SortUnit su) {
        List<?> lstSingleRoleInfo = null;
        ArrayList<Role> lstRole = new ArrayList<Role>();
        Paging rolepaging = new Paging();
        String rolepagehql = "FROM RoleInfo ";
        if (null != su) {
            String sortType = "asc";
            if ("desc".equalsIgnoreCase(su.getSortType())) {
                sortType = "desc";
            }
            rolepagehql = rolepagehql + " as d order by d." + ObjectConvertor.getRoleBoProByRoleVoPro(su.getFieldName()) + " " + sortType;
        }
        String countHql = "select count(*) from UserIdAndRoleId as ur where ur.id.roleId = ?";
        String couthql = "select count(*) from RoleInfo";
        try {
            lstSingleRoleInfo = this.commDao.findPage(rolepagehql, start, length);
            int iCount = 0;
            for (RoleInfo tmpRoleInfo : lstSingleRoleInfo) {
                Role tmpRole = ObjectConvertor.translateBoRoleInfo(tmpRoleInfo, false);
                iCount = Integer.parseInt(String.valueOf(this.commDao.getBaseHibernateTemplate().find(countHql, (Object[])new Long[]{tmpRoleInfo.getRoleIdx()}).listIterator().next()));
                tmpRole.setUserNum(iCount);
                lstRole.add(tmpRole);
            }
            rolepaging.setData(lstRole);
            iCount = Integer.parseInt(String.valueOf(this.commDao.getBaseHibernateTemplate().find(couthql, new Object[0]).listIterator().next()));
            rolepaging.setiCount(iCount);
        }
        catch (Exception e) {
            LOG.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return rolepaging;
    }

    public void setRoleDao(IRoleDao mRoleDao) {
        this.roleDao = mRoleDao;
    }

    public ICommonDao getCommDao() {
        return this.commDao;
    }

    public void setCommDao(ICommonDao commDao) {
        this.commDao = commDao;
    }
}

