/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.internal.jms;

import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class MessageTaskManager {
    private static final Log LOGGER = LogFactory.getInstance(MessageTaskManager.class);
    private ExecutorService threadPool = null;
    private String listenerAppName = "";

    public MessageTaskManager() {
        this.buildThraedPool(2, this.getClass().getName());
    }

    public MessageTaskManager(int poolsize, String listenAppName) {
        this.buildThraedPool(poolsize, listenAppName);
    }

    private void buildThraedPool(int poolsize, String listenAppName) {
        this.threadPool = 0 < poolsize && 11 > poolsize ? Executors.newFixedThreadPool(poolsize) : Executors.newFixedThreadPool(2);
        if (null != listenAppName && listenAppName.equals("")) {
            throw new LegoUncheckedException("when creating MessageTaskManager,the args needed listenerAppName,but current name is : " + listenAppName);
        }
        this.listenerAppName = listenAppName;
    }

    public abstract void onMessage(MessageUnit var1);

    public abstract MessageRegister[] getTypes();

    public final void setMessage(byte[] message) {
        MessageTask mt = new MessageTask();
        mt.setByteArray(message);
        Future<?> future = this.threadPool.submit(mt);
        if (null == future) {
            LOGGER.error((Object)"threadPool.submit failed.", 1L);
        }
    }

    public final void destory() {
        try {
            if (null != this.threadPool) {
                this.threadPool.shutdown();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    /*
     * Exception decompiling
     */
    private Optional<MessageUnit> decodeMessage(byte[] byteArr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public class MessageTask
    implements Runnable {
        private byte[] byteArray = null;

        public byte[] getByteArray() {
            return this.byteArray;
        }

        public void setByteArray(byte[] byteArray) {
            this.byteArray = byteArray;
        }

        @Override
        public void run() {
            if (this.byteArray == null) {
                LOGGER.warn((Object)"MessageTask execute failed cause byteArray is null");
                return;
            }
            long first = System.currentTimeMillis();
            Optional messageUnitOptional = MessageTaskManager.this.decodeMessage(this.byteArray);
            long second = System.currentTimeMillis();
            if (!messageUnitOptional.isPresent()) {
                return;
            }
            MessageUnit mu = (MessageUnit)messageUnitOptional.get();
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "Be ready for onMessage(mu)!receiveApp's name is :%s | the command code is : %s||||the time is : %s.", MessageTaskManager.this.listenerAppName, mu.getCmdcode(), second - first), 1L);
            MessageTaskManager.this.onMessage(mu);
        }
    }
}

